/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.remote;

import com.google.gwt.junit.remote.BrowserManager;
import com.google.gwt.junit.remote.BrowserManagerProcess;
import com.google.gwt.junit.remote.BrowserManagerServerLauncher;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserManagerServer
extends UnicastRemoteObject
implements BrowserManager {
    private static final Logger logger = Logger.getLogger(BrowserManagerServer.class.getName());
    private final BrowserManagerProcess.ProcessExitCb childExitCallback = new BrowserManagerProcess.ProcessExitCb(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childExited(int token, int exitValue) {
            Map map = BrowserManagerServer.this.processByToken;
            synchronized (map) {
                BrowserManagerServer.this.processByToken.remove(token);
                BrowserManagerServer.this.launchDelayedCommand();
            }
        }
    };
    private final String launchCmd;
    private Queue<LaunchCommand> launchCommandQueue = new LinkedList<LaunchCommand>();
    private int nextToken = 1;
    private final Map<Integer, BrowserManagerProcess> processByToken = new HashMap<Integer, BrowserManagerProcess>();
    private final boolean serializeFlag;
    private final Timer timer = new Timer();

    public static void main(String[] args) throws Exception {
        BrowserManagerServerLauncher serverMain = new BrowserManagerServerLauncher();
        if (serverMain.doProcessArgs(args)) {
            serverMain.run();
        }
    }

    BrowserManagerServer(String launchCmd, boolean serializeFlag) throws RemoteException {
        this.launchCmd = launchCmd;
        this.serializeFlag = serializeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepAlive(int token, long keepAliveMs) {
        if (keepAliveMs <= 0L) {
            throw new IllegalArgumentException();
        }
        Map<Integer, BrowserManagerProcess> map = this.processByToken;
        synchronized (map) {
            if (token < 0 || token >= this.nextToken) {
                throw new IllegalArgumentException();
            }
            BrowserManagerProcess process = this.processByToken.get(token);
            if (process != null) {
                if (process.keepAlive(keepAliveMs)) {
                    return;
                }
            } else if (this.launchCommandQueue.contains(new LaunchCommand(token))) {
                return;
            }
        }
        throw new IllegalStateException("Process " + token + " already dead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killBrowser(int token) {
        Map<Integer, BrowserManagerProcess> map = this.processByToken;
        synchronized (map) {
            if (token < 0 || token >= this.nextToken) {
                throw new IllegalArgumentException();
            }
            BrowserManagerProcess process = this.processByToken.get(token);
            if (process != null) {
                logger.info("Client kill for active browser: " + token);
                process.killBrowser();
            } else if (this.launchCommandQueue.contains(new LaunchCommand(token))) {
                this.launchCommandQueue.remove(new LaunchCommand(token));
                logger.info("Client kill for waiting browser: " + token);
            } else {
                logger.info("Client kill for inactive browser: " + token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int launchNewBrowser(String url, long keepAliveMs) {
        logger.info("Launching browser for url: " + url + " keepAliveMs: " + keepAliveMs);
        if (url == null || keepAliveMs <= 0L) {
            throw new IllegalArgumentException();
        }
        try {
            Map<Integer, BrowserManagerProcess> map = this.processByToken;
            synchronized (map) {
                int myToken = this.nextToken++;
                if (this.serializeFlag && !this.processByToken.isEmpty()) {
                    this.launchCommandQueue.add(new LaunchCommand(myToken, url, keepAliveMs));
                    logger.info("Queuing up request token: " + myToken + " for url: " + url + ".  Another launch command is active.");
                } else {
                    this.execChild(myToken, url, keepAliveMs);
                }
                return myToken;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error launching browser '" + this.launchCmd + "' for '" + url + "'", e);
            throw new RuntimeException("Error launching browser '" + this.launchCmd + "' for '" + url + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numQueued() {
        Map<Integer, BrowserManagerProcess> map = this.processByToken;
        synchronized (map) {
            return this.launchCommandQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numRunning() {
        Map<Integer, BrowserManagerProcess> map = this.processByToken;
        synchronized (map) {
            return this.processByToken.size();
        }
    }

    private void execChild(int token, String url, long keepAliveMs) throws IOException {
        StringTokenizer st = new StringTokenizer(this.launchCmd, "\n");
        int userTokens = st.countTokens();
        String[] cmdarray = new String[userTokens + 1];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        cmdarray[userTokens] = url;
        Process child = Runtime.getRuntime().exec(cmdarray);
        BrowserManagerProcess bmp = new BrowserManagerProcess(this.childExitCallback, this.timer, token, child, keepAliveMs);
        this.processByToken.put(token, bmp);
    }

    private void launchDelayedCommand() {
        if (!this.serializeFlag || !this.processByToken.isEmpty()) {
            return;
        }
        if (!this.launchCommandQueue.isEmpty()) {
            LaunchCommand lc = this.launchCommandQueue.remove();
            try {
                this.execChild(lc.token, lc.url, lc.keepAliveMsecs);
                logger.info("Started delayed browser: " + lc.token);
                return;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error launching browser '" + this.launchCmd + "' for '" + lc.url + "'", e);
                throw new RuntimeException("Error launching browser '" + this.launchCmd + "' for '" + lc.url + "'", e);
            }
        }
    }

    private static class LaunchCommand {
        long keepAliveMsecs;
        int token;
        String url;

        LaunchCommand(int tokenIn) {
            this(tokenIn, null, 0L);
        }

        LaunchCommand(int tokenIn, String urlIn, long keepAliveMsecsIn) {
            this.token = tokenIn;
            this.url = urlIn;
            this.keepAliveMsecs = keepAliveMsecsIn;
        }

        public boolean equals(Object obj) {
            return obj instanceof LaunchCommand && ((LaunchCommand)obj).token == this.token;
        }

        public int hashCode() {
            return this.token;
        }
    }
}

