/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGenerator;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceContext
implements ResourceContext {
    protected static final int MAX_INLINE_SIZE = 65536;
    private static final Map<TypeOracle, Map<String, Object>> CACHES = new WeakHashMap<TypeOracle, Map<String, Object>>();
    private static final String TYPE_ORACLE_RELOAD_COUNT_KEY = ":ReloadCount";
    private final TreeLogger logger;
    private final Map<String, Object> cache;
    private String currentResourceGeneratorType;
    private final GeneratorContext context;
    private final JClassType resourceBundleType;
    private String simpleSourceName;

    protected static String toBase64(byte[] data) {
        BASE64Encoder enc = new BASE64Encoder();
        String base64Contents = enc.encode(data).replaceAll("\\s+", "");
        return base64Contents;
    }

    private static Map<String, Object> getCache(TypeOracle oracle) {
        Map<String, Object> toReturn = CACHES.get(oracle);
        if (toReturn != null) {
            long expectedCount = (Long)toReturn.get(TYPE_ORACLE_RELOAD_COUNT_KEY);
            if (oracle.getReloadCount() == expectedCount) {
                return toReturn;
            }
        }
        toReturn = new HashMap<String, Object>();
        toReturn.put(TYPE_ORACLE_RELOAD_COUNT_KEY, oracle.getReloadCount());
        CACHES.put(oracle, toReturn);
        return toReturn;
    }

    protected AbstractResourceContext(TreeLogger logger, GeneratorContext context, JClassType resourceBundleType) {
        this.logger = logger;
        this.context = context;
        this.resourceBundleType = resourceBundleType;
        this.cache = AbstractResourceContext.getCache(context.getTypeOracle());
    }

    @Override
    public String deploy(URL resource, boolean xhrCompatible) throws UnableToCompleteException {
        String fileName = ResourceGeneratorUtil.baseName(resource);
        byte[] bytes = Util.readURLAsBytes((URL)resource);
        try {
            return this.deploy(fileName, resource.openConnection().getContentType(), bytes, xhrCompatible);
        }
        catch (IOException e) {
            this.getLogger().log(TreeLogger.ERROR, "Unable to determine mime type of resource", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    @Override
    public <T> T getCachedData(String key, Class<T> clazz) {
        return clazz.cast(this.cache.get(this.currentResourceGeneratorType + ":" + key));
    }

    @Override
    public JClassType getClientBundleType() {
        return this.resourceBundleType;
    }

    @Override
    public GeneratorContext getGeneratorContext() {
        return this.context;
    }

    @Override
    public String getImplementationSimpleSourceName() {
        if (this.simpleSourceName == null) {
            throw new IllegalStateException("Simple source name has not yet been set.");
        }
        return this.simpleSourceName;
    }

    @Override
    public <T> boolean putCachedData(String key, T value) {
        key = this.currentResourceGeneratorType + ":" + key;
        return value != this.cache.put(key, value);
    }

    protected GeneratorContext getContext() {
        return this.context;
    }

    protected TreeLogger getLogger() {
        return this.logger;
    }

    void setCurrentResourceGenerator(ResourceGenerator rg) {
        this.currentResourceGeneratorType = rg.getClass().getName();
    }

    void setSimpleSourceName(String name) {
        this.simpleSourceName = name;
    }
}

