/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.TextInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class DisclosurePanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String OPEN_IMAGE = "openImage";
    private static final String CLOSED_IMAGE = "closedImage";

    public void parse(XMLElement panelElem, String panelField, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        Children children = this.findChildren(panelElem, writer);
        if (null != children.body) {
            if (!writer.isWidgetElement(children.body)) {
                writer.die("In %s, %s must be a widget", panelElem, children.body);
            }
            String bodyField = writer.parseElementToField(children.body);
            writer.addInitStatement("%s.add(%s);", panelField, bodyField);
        }
        if (null != children.customHeader) {
            XMLElement headerElement = children.customHeader.consumeSingleChildElement();
            if (!writer.isWidgetElement(headerElement)) {
                writer.die("In %s of %s, %s is not a widget", children.customHeader, panelElem, headerElement);
            }
            String headerField = writer.parseElementToField(headerElement);
            writer.addInitStatement("%s.setHeader(%s);", panelField, headerField);
        }
        if (null != children.header) {
            String openImage = children.header.consumeImageResourceAttribute(OPEN_IMAGE);
            String closedImage = children.header.consumeImageResourceAttribute(CLOSED_IMAGE);
            String headerText = children.header.consumeInnerTextEscapedAsHtmlStringLiteral(new TextInterpreter(writer));
            if (openImage == null ^ closedImage == null) {
                writer.die("In %s of %s, both %s and %s must be specified, or neither", children.header, panelElem, OPEN_IMAGE, CLOSED_IMAGE);
            }
            String panelTypeName = type.getQualifiedSourceName();
            if (openImage != null) {
                writer.setFieldInitializer(panelField, String.format("new %s(%s, %s, \"%s\")", panelTypeName, openImage, closedImage, headerText));
            } else {
                writer.setFieldInitializer(panelField, String.format("new %s(\"%s\")", panelTypeName, headerText));
            }
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements(new XMLElement.Interpreter<Boolean>(){

            @Override
            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (this.hasAttribute(child, DisclosurePanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (this.hasAttribute(child, DisclosurePanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (null != children.body) {
                    writer.die("In %s, may have only one body element", elem);
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (null != children.header && null != children.customHeader) {
                    writer.die("In %1$s, may have only one %2$s:header or %2$s:customHeader", elem, elem.getPrefix());
                }
            }

            private boolean hasAttribute(XMLElement child, String attribute) {
                return this.rightNamespace(child) && child.getLocalName().equals(attribute);
            }

            private boolean rightNamespace(XMLElement child) {
                return child.getNamespaceUri().equals(elem.getNamespaceUri());
            }
        });
        return children;
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

