/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.rebind.FieldReference;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.FieldWriterOfExistingType;
import com.google.gwt.uibinder.rebind.FieldWriterOfGeneratedCssResource;
import com.google.gwt.uibinder.rebind.FieldWriterOfGeneratedType;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MonitoredLogger;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.model.ImplicitCssResource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class FieldManager {
    private static final String DUPLICATE_FIELD_ERROR = "Duplicate declaration of field %1$s.";
    private final TypeOracle types;
    private final MortalLogger logger;
    private final LinkedHashMap<String, FieldWriter> fieldsMap = new LinkedHashMap();
    private final LinkedList<FieldWriter> parsedFieldStack = new LinkedList();
    private LinkedHashMap<String, FieldReference> fieldReferences = new LinkedHashMap();

    public FieldManager(TypeOracle types, MortalLogger logger) {
        this.types = types;
        this.logger = logger;
    }

    public FieldWriter lookup(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    public void pop() {
        this.parsedFieldStack.removeFirst();
    }

    public void push(FieldWriter fieldWriter) {
        this.parsedFieldStack.addFirst(fieldWriter);
    }

    public FieldWriter registerField(JClassType fieldType, String fieldName) throws UnableToCompleteException {
        FieldWriterOfExistingType field = new FieldWriterOfExistingType(fieldType, fieldName, this.logger);
        return this.registerField(fieldName, field);
    }

    public FieldWriter registerFieldForGeneratedCssResource(ImplicitCssResource cssResource) throws UnableToCompleteException {
        FieldWriterOfGeneratedCssResource field = new FieldWriterOfGeneratedCssResource((JType)this.types.findType(String.class.getCanonicalName()), cssResource, this.logger);
        return this.registerField(cssResource.getName(), field);
    }

    public FieldWriter registerFieldOfGeneratedType(JClassType assignableType, String typePackage, String typeName, String fieldName) throws UnableToCompleteException {
        FieldWriterOfGeneratedType field = new FieldWriterOfGeneratedType(assignableType, typePackage, typeName, fieldName, this.logger);
        return this.registerField(fieldName, field);
    }

    public void registerFieldReference(String fieldReferenceString, JType type) {
        FieldReference fieldReference = this.fieldReferences.get(fieldReferenceString);
        if (fieldReference == null) {
            fieldReference = new FieldReference(fieldReferenceString, this, this.types);
            this.fieldReferences.put(fieldReferenceString, fieldReference);
        }
        fieldReference.addLeftHandType(type);
    }

    public void validate() throws UnableToCompleteException {
        boolean failed = false;
        for (Map.Entry<String, FieldReference> entry : this.fieldReferences.entrySet()) {
            FieldReference ref = entry.getValue();
            MonitoredLogger monitoredLogger = new MonitoredLogger(this.logger.getTreeLogger().branch(TreeLogger.Type.TRACE, "validating " + ref));
            ref.validate(monitoredLogger);
            failed |= monitoredLogger.hasErrors();
        }
        if (failed) {
            throw new UnableToCompleteException();
        }
    }

    public void writeGwtFieldsDeclaration(IndentedWriter writer, String ownerTypeName) throws UnableToCompleteException {
        Collection<FieldWriter> fields = this.fieldsMap.values();
        for (FieldWriter field : fields) {
            field.write(writer);
        }
    }

    private FieldWriter registerField(String fieldName, FieldWriter field) throws UnableToCompleteException {
        this.requireUnique(fieldName);
        this.fieldsMap.put(fieldName, field);
        if (this.parsedFieldStack.size() > 0) {
            this.parsedFieldStack.getFirst().needs(field);
        }
        return field;
    }

    private void requireUnique(String fieldName) throws UnableToCompleteException {
        if (this.fieldsMap.containsKey(fieldName)) {
            this.logger.die(DUPLICATE_FIELD_ERROR, fieldName);
        }
    }
}

