/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFieldSerializerValidator {
    private static final String NO_DESERIALIZE_METHOD = "Custom Field Serializer ''{0}'' does not define a deserialize method: ''public static void deserialize({1} reader,{2} instance)''";
    private static final String NO_INSTANTIATE_METHOD = "Custom Field Serializer ''{0}'' does not define an instantiate method: ''public static {1} instantiate({2} reader)''; but ''{1}'' is not default instantiable";
    private static final String NO_SERIALIZE_METHOD = "Custom Field Serializer ''{0}'' does not define a serialize method: ''public static void serialize({1} writer,{2} instance)''";
    private static final String TOO_MANY_METHODS = "Custom Field Serializer ''{0}'' defines too many methods named ''{1}''; please define only one method with that name";

    public static JMethod getDeserializationMethod(JClassType serializer, JClassType serializee) {
        return CustomFieldSerializerValidator.getMethod("deserialize", SerializationStreamReader.class.getName(), serializer, serializee);
    }

    public static JMethod getInstantiationMethod(JClassType serializer, JClassType serializee) {
        JMethod[] overloads;
        for (JMethod overload : overloads = serializer.getOverloads("instantiate")) {
            JClassType clazz;
            JType type;
            JParameter[] parameters = overload.getParameters();
            if (parameters.length != 1 || !parameters[0].getType().getQualifiedSourceName().equals(SerializationStreamReader.class.getName()) || !CustomFieldSerializerValidator.isValidCustomFieldSerializerMethod(overload) || (type = overload.getReturnType()).isPrimitive() != null || !(clazz = (JClassType)type).isAssignableFrom(serializee)) continue;
            return overload;
        }
        return null;
    }

    public static JMethod getSerializationMethod(JClassType serializer, JClassType serializee) {
        return CustomFieldSerializerValidator.getMethod("serialize", SerializationStreamWriter.class.getName(), serializer, serializee);
    }

    public static boolean hasDeserializationMethod(JClassType serializer, JClassType serializee) {
        return CustomFieldSerializerValidator.getDeserializationMethod(serializer, serializee) != null;
    }

    public static boolean hasInstantiationMethod(JClassType serializer, JClassType serializee) {
        return CustomFieldSerializerValidator.getInstantiationMethod(serializer, serializee) != null;
    }

    public static boolean hasSerializationMethod(JClassType serializer, JClassType serializee) {
        return CustomFieldSerializerValidator.getSerializationMethod(serializer, serializee) != null;
    }

    public static List<String> validate(JClassType serializer, JClassType serializee) {
        ArrayList<String> reasons = new ArrayList<String>();
        if (serializee.isEnum() != null) {
            reasons.add("Enumerated types cannot have custom field serializers.");
            return reasons;
        }
        if (!CustomFieldSerializerValidator.hasDeserializationMethod(serializer, serializee)) {
            reasons.add(MessageFormat.format(NO_DESERIALIZE_METHOD, serializer.getQualifiedSourceName(), SerializationStreamReader.class.getName(), serializee.getQualifiedSourceName()));
        } else {
            CustomFieldSerializerValidator.checkTooMany("deserialize", serializer, reasons);
        }
        if (!CustomFieldSerializerValidator.hasSerializationMethod(serializer, serializee)) {
            reasons.add(MessageFormat.format(NO_SERIALIZE_METHOD, serializer.getQualifiedSourceName(), SerializationStreamWriter.class.getName(), serializee.getQualifiedSourceName()));
        } else {
            CustomFieldSerializerValidator.checkTooMany("serialize", serializer, reasons);
        }
        if (!CustomFieldSerializerValidator.hasInstantiationMethod(serializer, serializee)) {
            if (!serializee.isDefaultInstantiable() && !serializee.isAbstract()) {
                reasons.add(MessageFormat.format(NO_INSTANTIATE_METHOD, serializer.getQualifiedSourceName(), serializee.getQualifiedSourceName(), SerializationStreamReader.class.getName()));
            }
        } else {
            CustomFieldSerializerValidator.checkTooMany("instantiate", serializer, reasons);
        }
        return reasons;
    }

    private static void checkTooMany(String methodName, JClassType serializer, List<String> reasons) {
        JMethod[] overloads = serializer.getOverloads(methodName);
        if (overloads.length > 1) {
            reasons.add(MessageFormat.format(TOO_MANY_METHODS, serializer.getQualifiedSourceName(), methodName));
        }
    }

    private static JMethod getMethod(String methodName, String streamClassName, JClassType serializer, JClassType serializee) {
        JMethod[] overloads;
        for (JMethod overload : overloads = serializer.getOverloads(methodName)) {
            JClassType clazz;
            JParameter serializeeParam;
            JType type;
            JParameter[] parameters = overload.getParameters();
            if (parameters.length != 2 || !parameters[0].getType().getQualifiedSourceName().equals(streamClassName) || (type = (serializeeParam = parameters[1]).getType()).isPrimitive() != null || !(clazz = (JClassType)type).isAssignableFrom(serializee) || !CustomFieldSerializerValidator.isValidCustomFieldSerializerMethod(overload) || overload.getReturnType() != JPrimitiveType.VOID) continue;
            return overload;
        }
        return null;
    }

    private static boolean isValidCustomFieldSerializerMethod(JMethod method) {
        if (method == null) {
            return false;
        }
        if (!method.isStatic()) {
            return false;
        }
        return method.isPublic();
    }

    private CustomFieldSerializerValidator() {
    }
}

