/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemReport {
    private Map<JClassType, List<Problem>> allProblems;
    private Map<JClassType, List<Problem>> auxiliaries;
    private Map<JClassType, List<Problem>> fatalProblems;
    private JClassType contextType;

    public ProblemReport() {
        Comparator<JClassType> comparator = new Comparator<JClassType>(){

            @Override
            public int compare(JClassType o1, JClassType o2) {
                assert (o1 != null);
                assert (o2 != null);
                return o1.getParameterizedQualifiedSourceName().compareTo(o2.getParameterizedQualifiedSourceName());
            }
        };
        this.allProblems = new TreeMap<JClassType, List<Problem>>(comparator);
        this.auxiliaries = new TreeMap<JClassType, List<Problem>>(comparator);
        this.fatalProblems = new TreeMap<JClassType, List<Problem>>(comparator);
        this.contextType = null;
    }

    public Problem add(JClassType type, String message, Priority priority, String ... extraLines) {
        String contextString = "";
        if (this.contextType != null) {
            contextString = " (reached via " + this.contextType.getParameterizedQualifiedSourceName() + ")";
        }
        message = message + contextString;
        Problem entry = new Problem(message, extraLines);
        if (priority == Priority.AUXILIARY) {
            this.addToMap(type, entry, this.auxiliaries);
            return entry;
        }
        this.addToMap(type, entry, this.allProblems);
        if (priority == Priority.FATAL) {
            this.addToMap(type, entry, this.fatalProblems);
        }
        return entry;
    }

    public String getWorstMessageForType(JClassType type) {
        List<Problem> list = this.fatalProblems.get(type);
        if (list == null && (list = this.allProblems.get(type)) == null) {
            list = this.auxiliaries.get(type);
        }
        if (list == null) {
            return null;
        }
        return list.get(0).getPrimaryMessage() + (list.size() > 1 ? ", etc." : "");
    }

    public boolean hasFatalProblems() {
        return !this.fatalProblems.isEmpty();
    }

    public void report(TreeLogger logger, TreeLogger.Type problemLevel, TreeLogger.Type auxLevel) {
        this.doReport(logger, auxLevel, this.auxiliaries);
        this.doReport(logger, problemLevel, this.allProblems);
    }

    public void reportFatalProblems(TreeLogger logger, TreeLogger.Type level) {
        this.doReport(logger, level, this.fatalProblems);
    }

    public void setContextType(JClassType newContext) {
        this.contextType = newContext;
    }

    List<Problem> getAuxiliaryMessagesForType(JClassType type) {
        List<Problem> list = this.auxiliaries.get(type);
        if (list == null) {
            list = new ArrayList<Problem>(0);
        }
        return list;
    }

    List<Problem> getProblemsForType(JClassType type) {
        List<Problem> list = this.allProblems.get(type);
        if (list == null) {
            list = new ArrayList<Problem>(0);
        }
        return list;
    }

    private void addToMap(JClassType type, Problem problem, Map<JClassType, List<Problem>> map) {
        List<Problem> list = map.get(type);
        if (list == null) {
            list = new ArrayList<Problem>();
            map.put(type, list);
        }
        list.add(problem);
    }

    private void doReport(TreeLogger logger, TreeLogger.Type level, Map<JClassType, List<Problem>> problems) {
        for (List<Problem> problemList : problems.values()) {
            for (Problem problem : problemList) {
                if (problem.hasSubMessages()) {
                    TreeLogger sublogger = logger.branch(level, problem.getPrimaryMessage());
                    for (String sub : problem.getSubMessages()) {
                        sublogger.log(level, sub);
                    }
                    continue;
                }
                logger.log(level, problem.getPrimaryMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        FATAL,
        DEFAULT,
        AUXILIARY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Problem {
        private String message;
        private List<String> childMessages;

        private Problem(String message, String[] children) {
            this.message = message;
            this.childMessages = new ArrayList<String>(children.length);
            for (int i = 0; i < children.length; ++i) {
                this.childMessages.add(children[i]);
            }
        }

        public void addChild(String message) {
            this.childMessages.add(message);
        }

        public String getPrimaryMessage() {
            return this.message;
        }

        public Iterable<String> getSubMessages() {
            return this.childMessages;
        }

        public boolean hasSubMessages() {
            return !this.childMessages.isEmpty();
        }
    }
}

