/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.ui;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.Util;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageBundleBuilder {
    private static final Comparator<HasRect> decreasingHeightComparator = new Comparator<HasRect>(){

        @Override
        public int compare(HasRect a, HasRect b) {
            int c = b.getHeight() - a.getHeight();
            return c != 0 ? c : b.getName().compareTo(a.getName());
        }
    };
    private static final Comparator<HasRect> decreasingWidthComparator = new Comparator<HasRect>(){

        @Override
        public int compare(HasRect a, HasRect b) {
            int c = b.getWidth() - a.getWidth();
            return c != 0 ? c : b.getName().compareTo(a.getName());
        }
    };
    private static final String BUNDLE_FILE_TYPE = "png";
    private final Map<String, ImageRect> imageNameToImageRectMap = new HashMap<String, ImageRect>();

    ImageBundleBuilder() {
    }

    static Size arrangeImages(Collection<? extends HasRect> rects) {
        if (rects.size() == 0) {
            return new Size(0, 0);
        }
        ArrayList<? extends HasRect> rectsOrderedByHeight = new ArrayList<HasRect>(rects);
        Collections.sort(rectsOrderedByHeight, decreasingHeightComparator);
        ArrayList<HasRect> rectsOrderedByWidth = new ArrayList<HasRect>(rects);
        Collections.sort(rectsOrderedByWidth, decreasingWidthComparator);
        HasRect first = rectsOrderedByHeight.get(0);
        first.setPosition(0, 0);
        int curX = first.getWidth();
        int colH = first.getHeight();
        int n = rectsOrderedByHeight.size();
        for (int i = 1; i < n; ++i) {
            if (rectsOrderedByHeight.get(i).hasBeenPositioned()) continue;
            int colW = 0;
            int curY = 0;
            ArrayList<HasRect> rectsInColumn = new ArrayList<HasRect>();
            for (int j = i; j < n; ++j) {
                HasRect current = rectsOrderedByHeight.get(j);
                if (current.hasBeenPositioned() || curY + current.getHeight() > colH) continue;
                current.setPosition(curX, 0);
                colW = Math.max(colW, current.getWidth());
                curY += current.getHeight();
                int pos = Collections.binarySearch(rectsInColumn, current, decreasingWidthComparator);
                assert (pos < 0);
                rectsInColumn.add(-1 - pos, current);
            }
            if (!rectsInColumn.isEmpty()) {
                ImageBundleBuilder.arrangeColumn(rectsInColumn, rectsOrderedByWidth);
            }
            curX += colW;
        }
        return new Size(curX, colH);
    }

    private static void arrangeColumn(List<HasRect> rectsInColumn, List<HasRect> remainingRectsOrderedByWidth) {
        HasRect first = rectsInColumn.get(0);
        int columnWidth = first.getWidth();
        int curY = first.getHeight();
        int m = rectsInColumn.size();
        for (int i = 1; i < m; ++i) {
            HasRect r = rectsInColumn.get(i);
            r.setPosition(r.getLeft(), curY);
            int curX = r.getWidth();
            int n = remainingRectsOrderedByWidth.size();
            for (int j = 0; j < n; ++j) {
                HasRect current = remainingRectsOrderedByWidth.get(j);
                if (current.hasBeenPositioned() || curX + current.getWidth() > columnWidth || current.getHeight() > r.getHeight()) continue;
                current.setPosition(r.getLeft() + curX, r.getTop());
                curX += current.getWidth();
            }
            curY += r.getHeight();
        }
    }

    public void assimilate(TreeLogger logger, String imageName) throws UnableToCompleteException {
        ImageRect rect = this.getMapping(imageName);
        if (rect == null) {
            rect = this.addImage(logger, imageName);
            this.putMapping(imageName, rect);
        }
    }

    public ImageRect getMapping(String imageName) {
        return this.imageNameToImageRectMap.get(imageName);
    }

    public String writeBundledImage(TreeLogger logger, GeneratorContext context) throws UnableToCompleteException {
        byte[] imageBytes;
        BufferedImage bundledImage = this.drawBundledImage();
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bundledImage, BUNDLE_FILE_TYPE, byteOutputStream);
            imageBytes = byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to generate file name for image bundle file", null);
            throw new UnableToCompleteException();
        }
        String bundleFileName = Util.computeStrongName((byte[])imageBytes) + ".cache." + BUNDLE_FILE_TYPE;
        OutputStream outStream = context.tryCreateResource(logger, bundleFileName);
        if (outStream != null) {
            try {
                outStream.write(imageBytes);
                context.commitResource(logger, outStream);
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Failed while writing", (Throwable)e);
                throw new UnableToCompleteException();
            }
        } else {
            logger.log(TreeLogger.TRACE, "Generated image bundle file already exists; no need to rewrite it.", null);
        }
        return bundleFileName;
    }

    private ImageRect addImage(TreeLogger logger, String imageName) throws UnableToCompleteException {
        logger = logger.branch(TreeLogger.TRACE, "Adding image '" + imageName + "'", null);
        try {
            BufferedImage image;
            URL imageUrl = this.getClass().getClassLoader().getResource(imageName);
            if (imageUrl == null) {
                logger.log(TreeLogger.ERROR, "Resource not found on classpath (is the name specified as Class.getResource() would expect?)", null);
                throw new UnableToCompleteException();
            }
            try {
                image = ImageIO.read(imageUrl);
            }
            catch (IllegalArgumentException iex) {
                if (imageName.toLowerCase().endsWith(BUNDLE_FILE_TYPE) && iex.getMessage() != null && iex.getStackTrace()[0].getClassName().equals("javax.imageio.ImageTypeSpecifier$Indexed")) {
                    logger.log(TreeLogger.ERROR, "Unable to read image. The image may not be in valid PNG format. This problem may also be due to a bug in versions of the JRE prior to 1.6. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5098176 for more information. If this bug is the cause of the error, try resaving the image using a different image program, or upgrade to a newer JRE.", null);
                    throw new UnableToCompleteException();
                }
                throw iex;
            }
            if (image == null) {
                logger.log(TreeLogger.ERROR, "Unrecognized image file format", null);
                throw new UnableToCompleteException();
            }
            return new ImageRect(imageName, image);
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to read image resource", null);
            throw new UnableToCompleteException();
        }
    }

    private BufferedImage drawBundledImage() {
        Collection<ImageRect> imageRects = this.imageNameToImageRectMap.values();
        Size size = ImageBundleBuilder.arrangeImages(imageRects);
        BufferedImage bundledImage = new BufferedImage(size.width, size.height, 3);
        Graphics2D g2d = bundledImage.createGraphics();
        for (ImageRect imageRect : imageRects) {
            g2d.drawImage((Image)imageRect.image, imageRect.left, imageRect.top, null);
        }
        g2d.dispose();
        return bundledImage;
    }

    private void putMapping(String imageName, ImageRect rect) {
        this.imageNameToImageRectMap.put(imageName, rect);
    }

    static interface HasRect {
        public String getName();

        public int getHeight();

        public int getLeft();

        public int getTop();

        public int getWidth();

        public boolean hasBeenPositioned();

        public void setPosition(int var1, int var2);
    }

    public static class ImageRect
    implements HasRect {
        private final String name;
        private final int height;
        private final int width;
        private final BufferedImage image;
        private int left;
        private int top;
        private boolean hasBeenPositioned;

        public ImageRect(String name, BufferedImage image) {
            this.name = name;
            this.image = image;
            this.width = image.getWidth();
            this.height = image.getHeight();
        }

        public int getHeight() {
            return this.height;
        }

        public int getLeft() {
            return this.left;
        }

        public String getName() {
            return this.name;
        }

        public int getTop() {
            return this.top;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean hasBeenPositioned() {
            return this.hasBeenPositioned;
        }

        public void setPosition(int left, int top) {
            this.hasBeenPositioned = true;
            this.left = left;
            this.top = top;
        }
    }

    private static class Size {
        private final int width;
        private final int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

