/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.text.shared.AbstractSafeHtmlRenderer;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLoadingCell
extends AbstractCell<String> {
    private static Template template;
    private final SafeHtmlRenderer<String> errorRenderer;
    private final SafeHtmlRenderer<String> imageRenderer;
    private final SafeHtmlRenderer<String> loadingRenderer;

    public ImageLoadingCell() {
        this((Renderers)GWT.create(DefaultRenderers.class));
    }

    public ImageLoadingCell(Renderers renderers) {
        super("load", "error");
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.errorRenderer = renderers.getErrorRenderer();
        this.imageRenderer = renderers.getImageRenderer();
        this.loadingRenderer = renderers.getLoadingRenderer();
    }

    @Override
    public void onBrowserEvent(Element parent, String value, Object key, NativeEvent event, ValueUpdater<String> valueUpdater) {
        String type = event.getType();
        if ("load".equals(type) && this.eventOccurredOnImage(event, parent)) {
            parent.getFirstChildElement().getStyle().setDisplay(Style.Display.NONE);
            Element imgWrapper = (Element)parent.getChild(1).cast();
            imgWrapper.getStyle().setProperty("height", "auto");
            imgWrapper.getStyle().setProperty("width", "auto");
            imgWrapper.getStyle().setProperty("overflow", "auto");
        } else if ("error".equals(type) && this.eventOccurredOnImage(event, parent)) {
            parent.getFirstChildElement().setInnerHTML(this.errorRenderer.render(value).asString());
        }
    }

    @Override
    public void render(String value, Object key, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(template.loading(this.loadingRenderer.render(value)));
            sb.append(template.image(this.imageRenderer.render(value)));
        }
    }

    private boolean eventOccurredOnImage(NativeEvent event, Element parent) {
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return false;
        }
        Element target = (Element)eventTarget.cast();
        Element imgWrapper = parent.getFirstChildElement().getNextSiblingElement();
        return imgWrapper.isOrHasChild(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultRenderers
    implements Renderers {
        private static SafeHtmlRenderer<String> IMAGE_RENDERER;
        private static SafeHtmlRenderer<String> LOADING_RENDERER;

        public DefaultRenderers() {
            if (IMAGE_RENDERER == null) {
                IMAGE_RENDERER = new AbstractSafeHtmlRenderer<String>(){

                    @Override
                    public SafeHtml render(String object) {
                        return template.img(object);
                    }
                };
            }
            if (LOADING_RENDERER == null) {
                Resources resources = (Resources)GWT.create(Resources.class);
                ImageResource res = resources.loading();
                final String loadingHtml = AbstractImagePrototype.create(res).getHTML();
                LOADING_RENDERER = new AbstractSafeHtmlRenderer<String>(){

                    @Override
                    public SafeHtml render(String object) {
                        return SafeHtmlUtils.fromSafeConstant(loadingHtml);
                    }
                };
            }
        }

        @Override
        public SafeHtmlRenderer<String> getErrorRenderer() {
            return this.getImageRenderer();
        }

        @Override
        public SafeHtmlRenderer<String> getImageRenderer() {
            return IMAGE_RENDERER;
        }

        @Override
        public SafeHtmlRenderer<String> getLoadingRenderer() {
            return LOADING_RENDERER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Renderers {
        public SafeHtmlRenderer<String> getErrorRenderer();

        public SafeHtmlRenderer<String> getImageRenderer();

        public SafeHtmlRenderer<String> getLoadingRenderer();
    }

    static interface Resources
    extends ClientBundle {
        public ImageResource loading();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div style='height:0px;width:0px;overflow:hidden;'>{0}</div>")
        public SafeHtml image(SafeHtml var1);

        @SafeHtmlTemplates.Template(value="<img src=\"{0}\"/>")
        public SafeHtml img(String var1);

        @SafeHtmlTemplates.Template(value="<div>{0}</div>")
        public SafeHtml loading(SafeHtml var1);
    }
}

