/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;

public class AsyncFragmentLoader {
    public static AsyncFragmentLoader BROWSER_LOADER = AsyncFragmentLoader.makeBrowserLoader(1, new int[0]);
    private int fragmentLoading = -1;
    private final int[] initialLoadSequence;
    private final boolean[] isLoaded;
    private final LoadingStrategy loadingStrategy;
    private final Logger logger;
    private final int numEntries;
    private LoadTerminatedHandler[] pendingDownloadErrorHandlers;
    private boolean prefetching = false;
    private BoundedIntQueue prefetchQueue = null;
    private BoundedIntQueue remainingInitialFragments = null;
    private final BoundedIntQueue requestedExclusives;

    public static void browserLoaderLeftoversFragmentHasLoaded() {
        BROWSER_LOADER.leftoversFragmentHasLoaded();
    }

    private static AsyncFragmentLoader makeBrowserLoader(int numFragments, int[] initialLoad) {
        if (GWT.isClient()) {
            return new AsyncFragmentLoader(numFragments, initialLoad, (LoadingStrategy)GWT.create(LoadingStrategy.class), (Logger)GWT.create(Logger.class));
        }
        return null;
    }

    public AsyncFragmentLoader(int numEntries, int[] initialLoadSequence, LoadingStrategy loadingStrategy, Logger logger) {
        this.numEntries = numEntries;
        this.initialLoadSequence = initialLoadSequence;
        this.loadingStrategy = loadingStrategy;
        this.logger = logger;
        int numEntriesPlusOne = numEntries + 1;
        this.requestedExclusives = new BoundedIntQueue(numEntriesPlusOne);
        this.isLoaded = new boolean[numEntriesPlusOne];
        this.pendingDownloadErrorHandlers = new LoadTerminatedHandler[numEntriesPlusOne];
    }

    public void fragmentHasLoaded(int fragment) {
        this.logFragmentLoaded(fragment);
        if (fragment < this.pendingDownloadErrorHandlers.length) {
            this.pendingDownloadErrorHandlers[fragment] = null;
        }
        if (this.isInitial(fragment)) {
            assert (fragment == this.remainingInitialFragments.peek());
            this.remainingInitialFragments.remove();
        }
        assert (fragment == this.fragmentLoading);
        this.fragmentLoading = -1;
        assert (!this.isLoaded[fragment]);
        this.isLoaded[fragment] = true;
        this.startLoadingNextFragment();
    }

    public void inject(int splitPoint, LoadTerminatedHandler loadErrorHandler) {
        this.pendingDownloadErrorHandlers[splitPoint] = loadErrorHandler;
        if (!this.isInitial(splitPoint)) {
            this.requestedExclusives.add(splitPoint);
        }
        this.startLoadingNextFragment();
    }

    public boolean isAlreadyLoaded(int splitPoint) {
        return this.isLoaded[splitPoint];
    }

    public boolean isLoading(int splitPoint) {
        return this.pendingDownloadErrorHandlers[splitPoint] != null;
    }

    public void leftoversFragmentHasLoaded() {
        this.fragmentHasLoaded(this.leftoversFragment());
    }

    public void logEventProgress(String eventGroup, String type) {
        this.logEventProgress(eventGroup, type, -1, -1);
    }

    public void setPrefetchQueue(int ... runAsyncSplitPoints) {
        if (this.prefetchQueue == null) {
            this.prefetchQueue = new BoundedIntQueue(this.numEntries);
        }
        this.prefetchQueue.clear();
        for (int sp : runAsyncSplitPoints) {
            this.prefetchQueue.add(sp);
        }
        this.startLoadingNextFragment();
    }

    public void startPrefetching() {
        this.prefetching = true;
        this.startLoadingNextFragment();
    }

    public void stopPrefetching() {
        this.prefetching = false;
    }

    private boolean anyPrefetchesRequested() {
        return this.prefetching && this.prefetchQueue != null && this.prefetchQueue.size() > 0;
    }

    private void clearRequestsAlreadyLoaded() {
        while (this.requestedExclusives.size() > 0 && this.isLoaded[this.requestedExclusives.peek()]) {
            int offset = this.requestedExclusives.remove();
            if (offset >= this.pendingDownloadErrorHandlers.length) continue;
            this.pendingDownloadErrorHandlers[offset] = null;
        }
        if (this.prefetchQueue != null) {
            while (this.prefetchQueue.size() > 0 && this.isLoaded[this.prefetchQueue.peek()]) {
                this.prefetchQueue.remove();
            }
        }
    }

    private String downloadGroup(int fragment) {
        return fragment == this.leftoversFragment() ? "leftoversDownload" : LwmLabels.downloadGroupForExclusive(fragment);
    }

    private boolean haveInitialFragmentsLoaded() {
        return this.remainingInitialFragments != null && this.remainingInitialFragments.size() == 0;
    }

    private void initializeRemainingInitialFragments() {
        if (this.remainingInitialFragments == null) {
            this.remainingInitialFragments = new BoundedIntQueue(this.initialLoadSequence.length + 1);
            for (int sp : this.initialLoadSequence) {
                this.remainingInitialFragments.add(sp);
            }
            this.remainingInitialFragments.add(this.leftoversFragment());
        }
    }

    private boolean isEmpty(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean isInitial(int splitPoint) {
        if (splitPoint == this.leftoversFragment()) {
            return true;
        }
        for (int sp : this.initialLoadSequence) {
            if (sp != splitPoint) continue;
            return true;
        }
        return false;
    }

    private int leftoversFragment() {
        return this.numEntries;
    }

    private void logDownloadStart(int fragment) {
        this.logEventProgress(this.downloadGroup(fragment), "begin", fragment, -1);
    }

    private void logEventProgress(String eventGroup, String type, int fragment, int size) {
        this.logger.logEventProgress(eventGroup, type, fragment, size);
    }

    private void logFragmentLoaded(int fragment) {
        String logGroup = this.downloadGroup(fragment);
        this.logEventProgress(logGroup, "end", fragment, -1);
    }

    private void startLoadingFragment(int fragment) {
        assert (this.fragmentLoading < 0);
        this.fragmentLoading = fragment;
        this.logDownloadStart(fragment);
        this.loadingStrategy.startLoadingFragment(fragment, new ResetAfterDownloadFailure(fragment));
    }

    private void startLoadingNextFragment() {
        if (this.fragmentLoading >= 0) {
            return;
        }
        this.initializeRemainingInitialFragments();
        this.clearRequestsAlreadyLoaded();
        if (this.isEmpty(this.pendingDownloadErrorHandlers) && !this.anyPrefetchesRequested()) {
            return;
        }
        if (this.remainingInitialFragments.size() > 0) {
            this.startLoadingFragment(this.remainingInitialFragments.peek());
            return;
        }
        assert (this.haveInitialFragmentsLoaded());
        if (this.requestedExclusives.size() > 0) {
            this.startLoadingFragment(this.requestedExclusives.remove());
            return;
        }
        if (this.anyPrefetchesRequested()) {
            this.startLoadingFragment(this.prefetchQueue.remove());
            return;
        }
        assert (false);
    }

    static /* synthetic */ LoadTerminatedHandler[] access$102(AsyncFragmentLoader x0, LoadTerminatedHandler[] x1) {
        x0.pendingDownloadErrorHandlers = x1;
        return x1;
    }

    private static class BoundedIntQueue {
        private final int[] array;
        private int read = 0;
        private int write = 0;

        public BoundedIntQueue(int maxPuts) {
            this.array = new int[maxPuts];
        }

        public void add(int x) {
            assert (this.write < this.array.length);
            this.array[this.write++] = x;
        }

        public void clear() {
            this.read = 0;
            this.write = 0;
        }

        public int peek() {
            assert (this.read < this.write);
            return this.array[this.read];
        }

        public int remove() {
            assert (this.read < this.write);
            return this.array[this.read++];
        }

        public int size() {
            return this.write - this.read;
        }
    }

    static class HttpDownloadFailure
    extends RuntimeException {
        private final int statusCode;

        public HttpDownloadFailure(String url, int statusCode, String statusText) {
            super("Download of " + url + " failed with status " + statusCode + "(" + statusText + ")");
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    static class HttpInstallFailure
    extends RuntimeException {
        public HttpInstallFailure(String url, String text, Throwable rootCause) {
            super("Install of " + url + " failed with text " + text, rootCause);
        }
    }

    public static interface LoadTerminatedHandler {
        public void loadTerminated(Throwable var1);
    }

    public static interface LoadingStrategy {
        public void startLoadingFragment(int var1, LoadTerminatedHandler var2);
    }

    public static interface Logger {
        public void logEventProgress(String var1, String var2, int var3, int var4);
    }

    public static class LwmLabels {
        public static final String BEGIN = "begin";
        public static final String END = "end";
        private static final String LEFTOVERS_DOWNLOAD = "leftoversDownload";

        private static String downloadGroupForExclusive(int splitPoint) {
            return "download" + splitPoint;
        }
    }

    private class ResetAfterDownloadFailure
    implements LoadTerminatedHandler {
        private final int fragment;

        public ResetAfterDownloadFailure(int myFragment) {
            this.fragment = myFragment;
        }

        public void loadTerminated(Throwable reason) {
            if (AsyncFragmentLoader.this.fragmentLoading != this.fragment) {
                return;
            }
            LoadTerminatedHandler[] handlersToRun = AsyncFragmentLoader.this.pendingDownloadErrorHandlers;
            AsyncFragmentLoader.access$102(AsyncFragmentLoader.this, new LoadTerminatedHandler[AsyncFragmentLoader.this.numEntries + 1]);
            AsyncFragmentLoader.this.requestedExclusives.clear();
            AsyncFragmentLoader.this.fragmentLoading = -1;
            RuntimeException lastException = null;
            for (LoadTerminatedHandler handler : handlersToRun) {
                if (handler == null) continue;
                try {
                    handler.loadTerminated(reason);
                }
                catch (RuntimeException e) {
                    lastException = e;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
    }

    public static class StandardLogger
    implements Logger {
        private static native boolean stats(JavaScriptObject var0);

        public void logEventProgress(String eventGroup, String type, int fragment, int size) {
            boolean toss = this.isStatsAvailable() && StandardLogger.stats(this.createStatsEvent(eventGroup, type, fragment, size));
        }

        private native JavaScriptObject createStatsEvent(String var1, String var2, int var3, int var4);

        private native boolean isStatsAvailable();
    }
}

