/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.util;

import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Name {
    private static final Pattern NON_TRAILING_DOLLAR = Pattern.compile("[$](\\p{javaJavaIdentifierStart})");
    private static final Pattern NON_TRAILING_DOLLAR_SLASH = Pattern.compile("[$/](\\p{javaJavaIdentifierStart})");

    public static String getBinaryNameForClass(Class<?> clazz) {
        return clazz.getName();
    }

    public static String getInternalNameForClass(Class<?> clazz) {
        return BinaryName.toInternalName(Name.getBinaryNameForClass(clazz));
    }

    public static String getSourceNameForClass(Class<?> clazz) {
        return clazz.getCanonicalName();
    }

    public static boolean isBinaryName(String name) {
        return name == null || !name.contains("/");
    }

    public static boolean isInternalName(String name) {
        return name == null || !name.contains(".");
    }

    public static boolean isSourceName(String name) {
        if (name == null) {
            return true;
        }
        int dollar = name.indexOf(36);
        return !name.contains("/") && (dollar < 0 || dollar == name.length() - 1);
    }

    public static boolean isSourceOrBinaryName(String name) {
        return name == null || !name.contains("/");
    }

    private Name() {
    }

    public static class BinaryName {
        public static String getClassName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            int lastDot = binaryName.lastIndexOf(46);
            if (lastDot < 0) {
                return binaryName;
            }
            return binaryName.substring(lastDot + 1);
        }

        public static String getInnerClassName(String outerClassBinaryName, String innerClassShortName) {
            assert (Name.isBinaryName(outerClassBinaryName));
            return outerClassBinaryName + '$' + innerClassShortName;
        }

        public static String getOuterClassName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            int lastDollar = binaryName.lastIndexOf(36);
            if (lastDollar < 0) {
                return null;
            }
            return binaryName.substring(0, lastDollar);
        }

        public static String getPackageName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            int lastDot = binaryName.lastIndexOf(46);
            if (lastDot < 0) {
                return "";
            }
            return binaryName.substring(0, lastDot);
        }

        public static String getShortClassName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            String className = BinaryName.getClassName(binaryName);
            int lastDollar = className.lastIndexOf(36, className.length() - 2);
            if (lastDollar < 0) {
                return className;
            }
            return className.substring(lastDollar + 1);
        }

        public static String toInternalName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            return binaryName.replace('.', '/');
        }

        public static String toSourceName(String binaryName) {
            assert (Name.isBinaryName(binaryName));
            return NON_TRAILING_DOLLAR.matcher(binaryName).replaceAll(".$1");
        }

        private BinaryName() {
        }
    }

    public static class InternalName {
        public static String getClassName(String name) {
            assert (Name.isInternalName(name));
            int lastSlash = name.lastIndexOf(47);
            if (lastSlash < 0) {
                return name;
            }
            return name.substring(lastSlash + 1);
        }

        public static String getInnerClassName(String outerClassInternalName, String innerClassShortName) {
            assert (Name.isInternalName(outerClassInternalName));
            return outerClassInternalName + '$' + innerClassShortName;
        }

        public static String getOuterClassName(String name) {
            int lastDollar = name.lastIndexOf(36);
            if (lastDollar < 0) {
                return null;
            }
            return name.substring(0, lastDollar);
        }

        public static String getPackageName(String name) {
            assert (Name.isInternalName(name));
            int lastSlash = name.lastIndexOf(47);
            if (lastSlash < 0) {
                return "";
            }
            return name.substring(0, lastSlash);
        }

        public static String getShortClassName(String internalName) {
            assert (Name.isInternalName(internalName));
            String className = InternalName.getClassName(internalName);
            int lastDollar = className.lastIndexOf(36, className.length() - 2);
            if (lastDollar < 0) {
                return className;
            }
            return className.substring(lastDollar + 1);
        }

        public static String toBinaryName(String internalName) {
            assert (Name.isInternalName(internalName));
            return internalName.replace('/', '.');
        }

        public static String toSourceName(String internalName) {
            assert (Name.isInternalName(internalName));
            return NON_TRAILING_DOLLAR_SLASH.matcher(internalName).replaceAll(".$1");
        }

        private InternalName() {
        }
    }

    public static class SourceName {
        public static String getInnerClassName(String outerClassSourceName, String innerClassShortName) {
            assert (Name.isSourceName(outerClassSourceName));
            return outerClassSourceName + '.' + innerClassShortName;
        }

        public static String getShortClassName(String sourceName) {
            assert (Name.isSourceName(sourceName));
            int lastDollar = sourceName.lastIndexOf(46);
            if (lastDollar < 0) {
                return sourceName;
            }
            return sourceName.substring(lastDollar + 1);
        }

        private SourceName() {
        }
    }

    public static class SourceOrBinaryName {
        public static String toSourceName(String dottedName) {
            return NON_TRAILING_DOLLAR.matcher(dottedName).replaceAll(".$1");
        }
    }
}

