/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.gwt.editor.client.AutoBean;
import com.google.gwt.editor.client.AutoBeanUtils;
import com.google.gwt.editor.client.AutoBeanVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoBean<T>
implements AutoBean<T> {
    protected static final Object[] EMPTY_OBJECT = new Object[0];
    protected final Map<String, Object> values;
    private boolean frozen;
    private Map<String, Object> tags;
    private final boolean usingSimplePeer;
    private T wrapped;

    protected AbstractAutoBean() {
        this.usingSimplePeer = true;
        this.values = new HashMap<String, Object>();
        this.wrapped = this.createSimplePeer();
        WeakMapping.set(this.wrapped, AutoBean.class.getName(), this);
    }

    protected AbstractAutoBean(AbstractAutoBean<T> toClone, boolean deep) {
        if (!toClone.usingSimplePeer) {
            throw new IllegalStateException("Cannot clone wrapped bean");
        }
        if (toClone.tags != null) {
            this.tags = new HashMap<String, Object>(toClone.tags);
        }
        this.usingSimplePeer = true;
        this.values = new HashMap<String, Object>(toClone.values);
        this.wrapped = this.createSimplePeer();
        if (deep) {
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                AutoBean auto = AutoBeanUtils.getAutoBean(entry.getValue());
                if (auto == null) continue;
                entry.setValue(auto.clone(true).as());
            }
        }
        WeakMapping.set(this.wrapped, AutoBean.class.getName(), this);
    }

    protected AbstractAutoBean(T wrapped) {
        this.usingSimplePeer = false;
        this.values = null;
        this.wrapped = wrapped;
        WeakMapping.set(wrapped, AutoBean.class.getName(), this);
    }

    @Override
    public void accept(AutoBeanVisitor visitor) {
        this.traverse(visitor, new OneShotContext());
    }

    @Override
    public abstract T as();

    @Override
    public abstract AutoBean<T> clone(boolean var1);

    @Override
    public <Q> Q getTag(String tagName) {
        return (Q)(this.tags == null ? null : this.tags.get(tagName));
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public boolean isWrapper() {
        return !this.usingSimplePeer;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public void setTag(String tagName, Object value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Object>();
        }
        this.tags.put(tagName, value);
    }

    public void traverse(AutoBeanVisitor visitor, OneShotContext ctx) {
        if (!ctx.seen.add(this)) {
            return;
        }
        if (visitor.visit(this, ctx)) {
            this.traverseProperties(visitor, ctx);
        }
        visitor.endVisit(this, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T unwrap() {
        if (this.usingSimplePeer) {
            throw new IllegalStateException();
        }
        try {
            WeakMapping.set(this.wrapped, AutoBean.class.getName(), null);
            T t = this.wrapped;
            return t;
        }
        finally {
            this.wrapped = null;
        }
    }

    protected void call(String method, Object returned, Object ... parameters) {
    }

    protected void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("The AutoBean has been frozen");
        }
    }

    protected void checkWrapped() {
        if (this.wrapped == null) {
            throw new IllegalStateException("The AutoBean has been unwrapped");
        }
    }

    protected T createSimplePeer() {
        throw new UnsupportedOperationException();
    }

    protected <V> V get(String method, V toReturn) {
        return toReturn;
    }

    protected <W> W getFromWrapper(W obj) {
        return (W)AutoBeanUtils.getAutoBean(obj).as();
    }

    protected T getWrapped() {
        return this.wrapped;
    }

    protected boolean isWrapped(Object obj) {
        return AutoBeanUtils.getAutoBean(obj) != null;
    }

    protected void set(String method, Object value) {
    }

    protected abstract void traverseProperties(AutoBeanVisitor var1, OneShotContext var2);

    public static class OneShotContext
    implements AutoBeanVisitor.Context {
        private final Set<AbstractAutoBean<?>> seen = new HashSet();
    }
}

