/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.place.shared;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.History;
import java.util.logging.Logger;

public class PlaceHistoryHandler {
    private static final Logger log = Logger.getLogger(PlaceHistoryHandler.class.getName());
    private final Historian historian;
    private final PlaceHistoryMapper mapper;
    private PlaceController placeController;
    private Place defaultPlace = Place.NOWHERE;

    public PlaceHistoryHandler(PlaceHistoryMapper mapper) {
        this(mapper, (Historian)GWT.create(DefaultHistorian.class));
    }

    public PlaceHistoryHandler(PlaceHistoryMapper mapper, Historian historian) {
        this.mapper = mapper;
        this.historian = historian;
    }

    public void handleCurrentHistory() {
        this.handleHistoryToken(this.historian.getToken());
    }

    public HandlerRegistration register(PlaceController placeController, EventBus eventBus, Place defaultPlace) {
        this.placeController = placeController;
        this.defaultPlace = defaultPlace;
        final HandlerRegistration placeReg = eventBus.addHandler(PlaceChangeEvent.TYPE, new PlaceChangeEvent.Handler(){

            public void onPlaceChange(PlaceChangeEvent event) {
                Place newPlace = event.getNewPlace();
                PlaceHistoryHandler.this.historian.newItem(PlaceHistoryHandler.this.tokenForPlace(newPlace), false);
            }
        });
        final HandlerRegistration historyReg = this.historian.addValueChangeHandler(new ValueChangeHandler<String>(){

            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                String token = event.getValue();
                PlaceHistoryHandler.this.handleHistoryToken(token);
            }
        });
        return new HandlerRegistration(){

            public void removeHandler() {
                PlaceHistoryHandler.this.defaultPlace = Place.NOWHERE;
                PlaceHistoryHandler.this.placeController = null;
                placeReg.removeHandler();
                historyReg.removeHandler();
            }
        };
    }

    Logger log() {
        return log;
    }

    private void handleHistoryToken(String token) {
        Place newPlace = null;
        if ("".equals(token)) {
            newPlace = this.defaultPlace;
        }
        if (newPlace == null) {
            newPlace = this.mapper.getPlace(token);
        }
        if (newPlace == null) {
            this.log().warning("Unrecognized history token: " + token);
            newPlace = this.defaultPlace;
        }
        this.placeController.goTo(newPlace);
    }

    private String tokenForPlace(Place newPlace) {
        if (this.defaultPlace.equals(newPlace)) {
            return "";
        }
        String token = this.mapper.getToken(newPlace);
        if (token != null) {
            return token;
        }
        this.log().warning("Place not mapped to a token: " + newPlace);
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultHistorian
    implements Historian {
        @Override
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> valueChangeHandler) {
            return History.addValueChangeHandler(valueChangeHandler);
        }

        @Override
        public String getToken() {
            return History.getToken();
        }

        @Override
        public void newItem(String token, boolean issueEvent) {
            History.newItem(token, issueEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Historian {
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> var1);

        public String getToken();

        public void newItem(String var1, boolean var2);
    }
}

