/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.requestfactory.server.DeadEntityException;
import com.google.gwt.requestfactory.server.ExceptionHandler;
import com.google.gwt.requestfactory.server.FindService;
import com.google.gwt.requestfactory.server.OperationRegistry;
import com.google.gwt.requestfactory.server.RequestDefinition;
import com.google.gwt.requestfactory.server.RequestFactoryInterfaceValidator;
import com.google.gwt.requestfactory.server.RequestProcessingException;
import com.google.gwt.requestfactory.server.RequestProcessor;
import com.google.gwt.requestfactory.server.RequestProperty;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.EntityProxyId;
import com.google.gwt.requestfactory.shared.ProxyFor;
import com.google.gwt.requestfactory.shared.ProxyForName;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.requestfactory.shared.WriteOperation;
import com.google.gwt.requestfactory.shared.impl.CollectionProperty;
import com.google.gwt.requestfactory.shared.impl.Constants;
import com.google.gwt.requestfactory.shared.impl.Property;
import com.google.gwt.user.server.Base64Utils;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonRequestProcessor
implements RequestProcessor<String> {
    public static final String RELATED = "related";
    private static final Logger log = Logger.getLogger(JsonRequestProcessor.class.getName());
    private RequestProperty propertyRefs;
    private final Map<String, JSONObject> relatedObjects = new HashMap<String, JSONObject>();
    private OperationRegistry operationRegistry;
    private ExceptionHandler exceptionHandler;
    private final Map<EntityKey, Object> cachedEntityLookup = new HashMap<EntityKey, Object>();
    private final Set<EntityKey> involvedKeys = new HashSet<EntityKey>();
    private final Map<EntityKey, DvsData> dvsDataMap = new HashMap<EntityKey, DvsData>();
    private final Map<EntityKey, SerializedEntity> beforeDataMap = new HashMap<EntityKey, SerializedEntity>();
    private Map<EntityKey, EntityData> afterDvsDataMap = new HashMap<EntityKey, EntityData>();

    JsonRequestProcessor() {
    }

    public static String base64Decode(String encoded) {
        byte[] decodedBytes;
        try {
            decodedBytes = Base64Utils.fromBase64(encoded);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("EntityKeyId was not Base64 encoded: " + encoded);
        }
        return new String(decodedBytes);
    }

    public static String base64Encode(String decoded) {
        byte[] decodedBytes = decoded.getBytes();
        return Base64Utils.toBase64(decodedBytes);
    }

    public static Class<EntityProxy> getRecordFromClassToken(String recordToken) {
        try {
            Class<EntityProxy> clazz = Class.forName(recordToken, false, JsonRequestProcessor.class.getClassLoader());
            if (EntityProxy.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            throw new SecurityException("Attempt to access non-record class " + recordToken);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Non-existent record class " + recordToken);
        }
    }

    public Collection<Property<?>> allProperties(Class<? extends EntityProxy> clazz) throws IllegalArgumentException {
        return this.getPropertiesFromRecordProxyType(clazz).values();
    }

    @Override
    public String decodeAndInvokeRequest(String encodedRequest) throws RequestProcessingException {
        try {
            Logger.getLogger(this.getClass().getName()).finest("Incoming request " + encodedRequest);
            String response = this.processJsonRequest(encodedRequest).toString();
            Logger.getLogger(this.getClass().getName()).finest("Outgoing response " + response);
            return response;
        }
        catch (InvocationTargetException e) {
            JSONObject exceptionResponse = this.buildExceptionResponse(e.getCause());
            throw new RequestProcessingException("Unexpected exception", e, exceptionResponse.toString());
        }
        catch (DeadEntityException e) {
            return this.buildExceptionResponse(e).toString();
        }
        catch (Exception e) {
            JSONObject exceptionResponse = this.buildExceptionResponse(e);
            throw new RequestProcessingException("Unexpected exception", e, exceptionResponse.toString());
        }
    }

    public Object decodeParameterValue(Type genericParameterType, String parameterValue) throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        ParameterizedType pType;
        if (parameterValue == null) {
            return null;
        }
        Class parameterType = null;
        if (genericParameterType instanceof Class) {
            parameterType = (Class)genericParameterType;
        }
        if (genericParameterType instanceof ParameterizedType && (pType = (ParameterizedType)genericParameterType).getRawType() instanceof Class) {
            Collection<Object> collection;
            Class rType;
            parameterType = rType = (Class)pType.getRawType();
            if (Collection.class.isAssignableFrom(rType) && (collection = this.createCollection(rType)) != null) {
                JSONArray array = new JSONArray(parameterValue);
                for (int i = 0; i < array.length(); ++i) {
                    String value = array.isNull(i) ? null : array.getString(i);
                    collection.add(this.decodeParameterValue(pType.getActualTypeArguments()[0], value));
                }
                return collection;
            }
        }
        if (String.class == parameterType) {
            return parameterValue;
        }
        if (Boolean.class == parameterType || Boolean.TYPE == parameterType) {
            return Boolean.valueOf(parameterValue);
        }
        if (Integer.class == parameterType || Integer.TYPE == parameterType) {
            return new Integer(parameterValue);
        }
        if (Byte.class == parameterType || Byte.TYPE == parameterType) {
            return new Byte(parameterValue);
        }
        if (Short.class == parameterType || Short.TYPE == parameterType) {
            return new Short(parameterValue);
        }
        if (Float.class == parameterType || Float.TYPE == parameterType) {
            return new Float(parameterValue);
        }
        if (Double.class == parameterType || Double.TYPE == parameterType) {
            return new Double(parameterValue);
        }
        if (Long.class == parameterType || Long.TYPE == parameterType) {
            return new Long(parameterValue);
        }
        if (Character.class == parameterType || Character.TYPE == parameterType) {
            return Character.valueOf(parameterValue.charAt(0));
        }
        if (BigInteger.class == parameterType) {
            return new BigInteger(parameterValue);
        }
        if (BigDecimal.class == parameterType) {
            return new BigDecimal(parameterValue);
        }
        if (parameterType.isEnum()) {
            int ordinal = Integer.parseInt(parameterValue);
            Method valuesMethod = parameterType.getDeclaredMethod("values", new Class[0]);
            if (valuesMethod != null) {
                Enum[] values;
                valuesMethod.setAccessible(true);
                for (Enum e : values = (Enum[])valuesMethod.invoke(null, new Object[0])) {
                    if (ordinal != e.ordinal()) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException("Can't decode enum " + parameterType + " no matching ordinal " + ordinal);
        }
        if (Date.class == parameterType) {
            return new Date(Long.parseLong(parameterValue));
        }
        if (EntityProxy.class.isAssignableFrom(parameterType)) {
            ProxyFor proxyFor = parameterType.getAnnotation(ProxyFor.class);
            ProxyForName proxyForName = parameterType.getAnnotation(ProxyForName.class);
            if (proxyFor != null || proxyForName != null) {
                EntityKey entityKey = this.getEntityKey(parameterValue.toString());
                DvsData dvsData = this.dvsDataMap.get(entityKey);
                if (dvsData != null) {
                    EntityData entityData = this.getEntityDataForRecordWithSettersApplied(entityKey, dvsData.jsonObject, dvsData.writeOperation);
                    return entityData.entityInstance;
                }
                this.involvedKeys.add(entityKey);
                return this.getEntityInstance(entityKey);
            }
        }
        if (EntityProxyId.class.isAssignableFrom(parameterType)) {
            EntityKey entityKey = this.getEntityKey(parameterValue.toString());
            ProxyFor proxyFor = entityKey.proxyType.getAnnotation(ProxyFor.class);
            ProxyForName proxyForName = entityKey.proxyType.getAnnotation(ProxyForName.class);
            if (proxyFor == null && proxyForName == null) {
                throw new IllegalArgumentException("Unknown service, unable to decode " + parameterValue);
            }
            this.involvedKeys.add(entityKey);
            return this.getEntityInstance(entityKey);
        }
        throw new IllegalArgumentException("Unknown parameter type: " + parameterType);
    }

    public Object encodePropertyValue(Object value) {
        if (value == null) {
            return JSONObject.NULL;
        }
        Class<?> type = value.getClass();
        if (Boolean.class == type) {
            return value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return String.valueOf(((Date)value).getTime());
        }
        if (Enum.class.isAssignableFrom(type)) {
            return (double)((Enum)value).ordinal();
        }
        if (BigDecimal.class == type || BigInteger.class == type || Long.class == type) {
            return String.valueOf(value);
        }
        if (Number.class.isAssignableFrom(type)) {
            return ((Number)value).doubleValue();
        }
        return String.valueOf(value);
    }

    public Object encodePropertyValueFromDataStore(Object entityElement, Property<?> property, String propertyName, RequestProperty propertyContext) throws SecurityException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, JSONException {
        Object returnValue = this.getRawPropertyValueFromDatastore(entityElement, propertyName);
        Class<?> proxyPropertyType = property.getType();
        Class<?> elementType = property instanceof CollectionProperty ? ((CollectionProperty)property).getLeafType() : proxyPropertyType;
        String encodedEntityId = this.isEntityReference(returnValue, proxyPropertyType);
        if (returnValue == null) {
            return JSONObject.NULL;
        }
        if (encodedEntityId != null) {
            String keyRef = this.encodeRelated(proxyPropertyType, propertyName, propertyContext, returnValue);
            return keyRef;
        }
        if (property instanceof CollectionProperty) {
            Class colType = ((CollectionProperty)property).getType();
            Collection<Object> col = this.createCollection(colType);
            if (col != null) {
                for (Object o : (Collection)returnValue) {
                    String encodedValId = this.isEntityReference(o, ((CollectionProperty)property).getLeafType());
                    if (encodedValId != null) {
                        col.add(this.encodeRelated(elementType, propertyName, propertyContext, o));
                        continue;
                    }
                    col.add(this.encodePropertyValue(o));
                }
                return col;
            }
            return null;
        }
        return this.encodePropertyValue(returnValue);
    }

    public EntityData getEntityDataForRecordWithSettersApplied(EntityKey entityKey, JSONObject recordObject, WriteOperation writeOperation) throws JSONException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Class<Object> entityType = this.getEntityTypeForProxyType(entityKey.proxyType);
        Map<String, Property<?>> propertiesInProxy = this.getPropertiesFromRecordProxyType(entityKey.proxyType);
        Map<String, Class<?>> propertiesInDomain = this.updatePropertyTypes(propertiesInProxy, entityType);
        this.validateKeys(recordObject, propertiesInDomain.keySet());
        Class<?> idType = this.getIdMethodForEntity(entityType).getReturnType();
        Object entityInstance = this.getEntityInstance(writeOperation, entityType, entityKey.decodedId(idType), idType);
        if (entityInstance == null) {
            throw new DeadEntityException("The requested entity is not available on the server");
        }
        this.cachedEntityLookup.put(entityKey, entityInstance);
        Iterator keys = recordObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Property<?> dtoProperty = propertiesInProxy.get(key);
            if (writeOperation == WriteOperation.PERSIST && "id".equals(key)) continue;
            Object propertyValue = null;
            if (!recordObject.isNull(key)) {
                if (dtoProperty instanceof CollectionProperty) {
                    Class<?> cType = dtoProperty.getType();
                    Class leafType = ((CollectionProperty)dtoProperty).getLeafType();
                    Collection<Object> col = this.createCollection(cType);
                    if (col != null) {
                        JSONArray array = recordObject.getJSONArray(key);
                        for (int i = 0; i < array.length(); ++i) {
                            propertyValue = EntityProxy.class.isAssignableFrom(leafType) ? this.getPropertyValueFromRequestCached(array, i, dtoProperty) : this.decodeParameterValue(leafType, array.getString(i));
                            col.add(propertyValue);
                        }
                        propertyValue = col;
                    }
                } else {
                    propertyValue = this.getPropertyValueFromRequestCached(recordObject, propertiesInProxy, key, dtoProperty);
                }
            }
            entityType.getMethod(this.getMethodNameFromPropertyName(key, "set"), propertiesInDomain.get(key)).invoke(entityInstance, propertyValue);
        }
        Set violations = Collections.emptySet();
        Validator validator = null;
        try {
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            validator = validatorFactory.getValidator();
        }
        catch (Exception e) {
            log.info(String.format("Ignoring exception caught initializing bean validation framework. It is probably unconfigured or misconfigured. [%s] %s ", e.getClass().getName(), e.getLocalizedMessage()));
        }
        if (validator != null) {
            violations = validator.validate(entityInstance, new Class[0]);
        }
        return new EntityData(entityInstance, violations.isEmpty() ? null : this.getViolationsAsJson(violations));
    }

    public Object getEntityInstance(EntityKey entityKey) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, JSONException, InstantiationException {
        Class<Object> entityClass = this.getEntityTypeForProxyType(entityKey.proxyType);
        Class<?> idType = this.getIdMethodForEntity(entityClass).getReturnType();
        Object entityInstance = entityClass.getMethod("find" + entityClass.getSimpleName(), idType).invoke(null, entityKey.decodedId(idType));
        return entityInstance;
    }

    public Object getEntityInstance(WriteOperation writeOperation, Class<?> entityType, Object idValue, Class<?> idType) throws SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IllegalArgumentException, JSONException {
        if (writeOperation == WriteOperation.PERSIST) {
            return entityType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return entityType.getMethod("find" + entityType.getSimpleName(), idType).invoke(null, this.decodeParameterValue(idType, idValue.toString()));
    }

    public Class<Object> getEntityTypeForProxyType(Class<? extends EntityProxy> record) {
        ProxyFor dtoAnn = record.getAnnotation(ProxyFor.class);
        if (dtoAnn != null) {
            return dtoAnn.value();
        }
        ProxyForName name = record.getAnnotation(ProxyForName.class);
        if (name != null) {
            try {
                return Class.forName(name.value(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find ProxyForName class", e);
            }
        }
        throw new IllegalArgumentException("Proxy class " + record.getName() + " missing ProxyFor annotation");
    }

    public JSONArray getJsonArray(Collection<?> resultList, Class<? extends EntityProxy> entityKeyClass) throws IllegalArgumentException, SecurityException, IllegalAccessException, JSONException, NoSuchMethodException, InvocationTargetException {
        JSONArray jsonArray = new JSONArray();
        if (resultList.size() == 0) {
            return jsonArray;
        }
        for (Object entityElement : resultList) {
            if (entityElement instanceof Number || entityElement instanceof String || entityElement instanceof Character || entityElement instanceof Date || entityElement instanceof Boolean || entityElement instanceof Enum) {
                jsonArray.put(this.encodePropertyValue(entityElement));
                continue;
            }
            if (entityElement instanceof List || entityElement instanceof Set) {
                jsonArray.put((Object)this.getJsonArray((Collection)entityElement, entityKeyClass));
                continue;
            }
            jsonArray.put(this.getJsonObject(entityElement, entityKeyClass, this.propertyRefs));
        }
        return jsonArray;
    }

    public Object getJsonObject(Object entityElement, Class<? extends EntityProxy> entityKeyClass, RequestProperty propertyContext) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (entityElement == null || !EntityProxy.class.isAssignableFrom(entityKeyClass)) {
            return JSONObject.NULL;
        }
        JSONObject jsonObject = this.getJsonObjectWithIdAndVersion(this.isEntityReference(entityElement, entityKeyClass), entityElement, propertyContext);
        for (Property<?> p : this.allProperties(entityKeyClass)) {
            if (!this.requestedProperty(p, propertyContext)) continue;
            String propertyName = p.getName();
            jsonObject.put(propertyName, this.encodePropertyValueFromDataStore(entityElement, p, propertyName, propertyContext));
        }
        return jsonObject;
    }

    public String getMethodNameFromPropertyName(String propertyName, String prefix) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null");
        }
        StringBuffer methodName = new StringBuffer(prefix);
        methodName.append(propertyName.substring(0, 1).toUpperCase());
        methodName.append(propertyName.substring(1));
        return methodName.toString();
    }

    public Object[][] getObjectsFromParameterMap(boolean isInstanceMethod, Map<String, String> parameterMap, Type[] parameterClasses) throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        assert (parameterClasses != null);
        Object[][] args = new Object[2][];
        args[0] = new Object[1];
        if (isInstanceMethod) {
            EntityKey entityKey = this.getEntityKey(parameterMap.get("param0"));
            this.involvedKeys.add(entityKey);
            args[0][0] = entityKey;
        } else {
            args[0][0] = null;
        }
        int offset = isInstanceMethod ? 1 : 0;
        args[1] = new Object[parameterClasses.length - offset];
        for (int i = 0; i < parameterClasses.length - offset; ++i) {
            args[1][i] = this.decodeParameterValue(parameterClasses[i + offset], parameterMap.get("param" + (i + offset)));
        }
        return args;
    }

    public RequestDefinition getOperation(String operationName) {
        RequestDefinition operation = this.operationRegistry.getOperation(operationName);
        if (null == operation) {
            throw new IllegalArgumentException("Unknown operation " + operationName);
        }
        return operation;
    }

    public Map<String, String> getParameterMap(JSONObject jsonObject) throws JSONException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (!key.startsWith("param")) continue;
            parameterMap.put(key, jsonObject.getString(key));
            String value = jsonObject.isNull(key) ? null : jsonObject.getString(key);
            parameterMap.put(key, value);
        }
        return parameterMap;
    }

    public Map<String, Property<?>> getPropertiesFromRecordProxyType(Class<? extends EntityProxy> record) throws SecurityException {
        Method[] methods;
        if (!EntityProxy.class.isAssignableFrom(record)) {
            return Collections.emptyMap();
        }
        LinkedHashMap properties = new LinkedHashMap();
        for (Method method : methods = record.getMethods()) {
            Property existing;
            Type[] parameterTypes;
            String methodName = method.getName();
            String propertyName = null;
            Property<?> newProperty = null;
            if (methodName.startsWith("get")) {
                propertyName = Introspector.decapitalize(methodName.substring(3));
                if (propertyName.length() == 0) continue;
                newProperty = this.getPropertyFromGenericType(propertyName, method.getGenericReturnType());
            } else if (methodName.startsWith("set") && (propertyName = Introspector.decapitalize(methodName.substring(3))).length() > 0 && (parameterTypes = method.getGenericParameterTypes()).length > 0) {
                newProperty = this.getPropertyFromGenericType(propertyName, parameterTypes[parameterTypes.length - 1]);
            }
            if (newProperty == null || (existing = (Property)properties.put(propertyName, newProperty)) == null || existing.equals(newProperty)) continue;
            throw new IllegalStateException(String.format("In %s, mismatched getter and setter types for property %s, found %s and %s", record.getName(), propertyName, existing.getName(), newProperty.getName()));
        }
        return properties;
    }

    public Property<?> getPropertyFromGenericType(String propertyName, Type type) {
        if (type instanceof ParameterizedType) {
            Type leafType;
            ParameterizedType pType = (ParameterizedType)type;
            Class rawType = (Class)pType.getRawType();
            Type[] typeArgs = pType.getActualTypeArguments();
            if (Collection.class.isAssignableFrom(rawType) && typeArgs.length == 1 && (leafType = typeArgs[0]) instanceof Class) {
                return new CollectionProperty(propertyName, rawType, (Class)leafType);
            }
        } else {
            return new Property(propertyName, (Class)type);
        }
        return null;
    }

    public Object getPropertyValueFromRequest(JSONArray recordArray, int index, Class<?> propertyType) throws JSONException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        return this.decodeParameterValue(propertyType, recordArray.get(index).toString());
    }

    public Object getPropertyValueFromRequest(JSONObject recordObject, String key, Class<?> propertyType) throws JSONException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        return this.decodeParameterValue(propertyType, recordObject.isNull(key) ? null : recordObject.get(key).toString());
    }

    public JSONObject getViolationsAsJson(Set<ConstraintViolation<Object>> violations) throws JSONException {
        JSONObject violationsAsJson = new JSONObject();
        for (ConstraintViolation<Object> violation : violations) {
            violationsAsJson.put(violation.getPropertyPath().toString(), (Object)violation.getMessage());
        }
        return violationsAsJson;
    }

    public Object invokeDomainMethod(Object domainObject, Method domainMethod, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return domainMethod.invoke(domainObject, args);
    }

    public JSONObject processJsonRequest(String jsonRequestString) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, SecurityException, InstantiationException {
        EntityData domainEntityData;
        JSONObject topLevelJsonObject = new JSONObject(jsonRequestString);
        String operationName = topLevelJsonObject.getString("operation");
        String propertyRefsString = topLevelJsonObject.has("propertyRefs") ? topLevelJsonObject.getString("propertyRefs") : "";
        this.propertyRefs = RequestProperty.parse(propertyRefsString);
        RequestDefinition operation = this.getOperation(operationName);
        Class<?> domainClass = Class.forName(operation.getDomainClassName());
        RequestFactoryInterfaceValidator validator = new RequestFactoryInterfaceValidator(log, new RequestFactoryInterfaceValidator.ClassLoaderLoader(JsonRequestProcessor.class.getClassLoader()));
        validator.validateRequestContext(operationName.substring(0, operationName.indexOf("::")));
        if (validator.isPoisoned()) {
            log.severe("Unable to validate RequestContext");
            throw new RuntimeException();
        }
        Method domainMethod = domainClass.getMethod(operation.getDomainMethod().getName(), operation.getParameterTypes());
        if (Modifier.isStatic(domainMethod.getModifiers()) == operation.isInstance()) {
            throw new IllegalArgumentException("the " + domainMethod.getName() + " should " + (operation.isInstance() ? "not " : "") + "be static");
        }
        if (topLevelJsonObject.has("contentData")) {
            this.decodeDVS(topLevelJsonObject.getString("contentData"));
        }
        Object[][] args = this.getObjectsFromParameterMap(operation.isInstance(), this.getParameterMap(topLevelJsonObject), operation.getRequestParameterTypes());
        this.constructBeforeDataMap();
        this.constructAfterDvsDataMapAfterCallingSetters();
        JSONArray violationsAsJson = this.getViolations();
        if (violationsAsJson.length() > 0) {
            JSONObject envelop = new JSONObject();
            envelop.put("violations", (Object)violationsAsJson);
            return envelop;
        }
        EntityKey domainEntityKey = null;
        if (args[0][0] != null && (domainEntityData = this.afterDvsDataMap.get(domainEntityKey = (EntityKey)args[0][0])) != null) {
            args[0][0] = domainEntityData.entityInstance;
            assert (args[0][0] != null);
        }
        Object result = this.invokeDomainMethod(args[0][0], domainMethod, args[1]);
        JSONObject sideEffects = this.getSideEffects();
        if (result != null && result instanceof List != List.class.isAssignableFrom(operation.getDomainMethod().getReturnType())) {
            throw new IllegalArgumentException(String.format("Type mismatch, expected %s%s, but %s returns %s", List.class.isAssignableFrom(operation.getReturnType()) ? "list of " : "", operation.getReturnType(), domainMethod, domainMethod.getReturnType()));
        }
        JSONObject envelop = new JSONObject();
        if (result instanceof List || result instanceof Set) {
            envelop.put("result", this.toJsonArray(operation, result));
        } else if (result instanceof Number || result instanceof Enum || result instanceof String || result instanceof Date || result instanceof Character || result instanceof Boolean) {
            envelop.put("result", this.encodePropertyValue(result));
        } else {
            Class<Object> returnType = null;
            if (operation.getDomainClassName().equals(FindService.class.getName())) {
                if (this.involvedKeys.size() == 1) {
                    returnType = this.involvedKeys.iterator().next().proxyType;
                } else {
                    System.out.println("null find");
                }
            } else {
                returnType = operation.getReturnType();
            }
            Object jsonObject = this.getJsonObject(result, returnType, this.propertyRefs);
            envelop.put("result", jsonObject);
        }
        envelop.put("sideEffects", (Object)sideEffects);
        envelop.put(RELATED, (Object)this.encodeRelatedObjectsToJson());
        return envelop;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void setOperationRegistry(OperationRegistry operationRegistry) {
        this.operationRegistry = operationRegistry;
    }

    public void validateKeys(JSONObject recordObject, Set<String> declaredProperties) {
        recordObject.remove("!id");
        recordObject.remove("!version");
        Iterator keys = recordObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (declaredProperties.contains(key)) continue;
            throw new IllegalArgumentException("key " + key + " is not permitted to be set");
        }
    }

    boolean hasChanged(JSONArray beforeArray, JSONArray afterArray) throws JSONException {
        if (beforeArray.length() != afterArray.length()) {
            return true;
        }
        for (int i = 0; i < beforeArray.length(); ++i) {
            Object bVal = beforeArray.get(i);
            Object aVal = afterArray.get(i);
            if (aVal != null && bVal != null) {
                if (aVal == bVal || aVal.equals(bVal)) continue;
                if (aVal.getClass() != bVal.getClass()) {
                    return true;
                }
                if (aVal instanceof JSONObject && this.hasChanged((JSONObject)bVal, (JSONObject)aVal)) {
                    return true;
                }
                if (aVal instanceof JSONArray && this.hasChanged((JSONArray)bVal, (JSONArray)aVal)) {
                    return true;
                }
            }
            if (aVal == bVal) continue;
            return true;
        }
        return false;
    }

    boolean hasChanged(JSONObject before, JSONObject after) throws JSONException {
        if (before == null) {
            return after != null;
        }
        if (after == null) {
            return true;
        }
        Iterator keyIterator = before.keys();
        while (keyIterator.hasNext()) {
            Object afterValue;
            String key = keyIterator.next().toString();
            Object beforeValue = before.isNull(key) ? null : before.get(key);
            Object object = afterValue = after.isNull(key) ? null : after.get(key);
            if (beforeValue == null) {
                if (afterValue == null) continue;
                return true;
            }
            if (afterValue == null) {
                return true;
            }
            if (beforeValue.equals(afterValue)) continue;
            if (beforeValue instanceof JSONArray && afterValue instanceof JSONArray) {
                JSONArray beforeArray = (JSONArray)beforeValue;
                JSONArray afterArray = (JSONArray)afterValue;
                if (!this.hasChanged(beforeArray, afterArray)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void addRelatedObject(String keyRef, Object returnValue, Class<? extends EntityProxy> propertyType, RequestProperty propertyContext) throws JSONException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (!this.relatedObjects.containsKey(keyRef)) {
            this.relatedObjects.put(keyRef, null);
            Object jsonObject = this.getJsonObject(returnValue, propertyType, propertyContext);
            if (jsonObject != JSONObject.NULL) {
                this.relatedObjects.put(keyRef, (JSONObject)jsonObject);
            }
        }
    }

    private JSONObject buildExceptionResponse(Throwable throwable) {
        JSONObject exceptionResponse = new JSONObject();
        ServerFailure failure = this.exceptionHandler.createServerFailure(throwable);
        try {
            JSONObject exceptionMessage = new JSONObject();
            String message = failure.getMessage();
            String exceptionType = failure.getExceptionType();
            String stackTraceString = failure.getStackTraceString();
            if (message != null && message.length() != 0) {
                exceptionMessage.put("message", (Object)message);
            }
            if (exceptionType != null && exceptionType.length() != 0) {
                exceptionMessage.put("type", (Object)exceptionType);
            }
            if (stackTraceString != null && stackTraceString.length() != 0) {
                exceptionMessage.put("trace", (Object)stackTraceString);
            }
            exceptionResponse.put("exception", (Object)exceptionMessage);
        }
        catch (JSONException jsonException) {
            throw new IllegalStateException(jsonException);
        }
        return exceptionResponse;
    }

    private Class<? extends EntityProxy> castToRecordClass(Class<?> propertyType) {
        return propertyType;
    }

    private void constructAfterDvsDataMapAfterCallingSetters() throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        this.afterDvsDataMap = new HashMap<EntityKey, EntityData>();
        HashSet<EntityKey> done = new HashSet<EntityKey>();
        HashSet<EntityKey> queue = new HashSet<EntityKey>(this.involvedKeys);
        while (!queue.isEmpty()) {
            for (EntityKey entityKey : queue) {
                DvsData dvsData = this.dvsDataMap.get(entityKey);
                if (dvsData != null) {
                    EntityData entityData = this.getEntityDataForRecordWithSettersApplied(entityKey, dvsData.jsonObject, dvsData.writeOperation);
                    if (entityKey.isFuture) {
                        // empty if block
                    }
                    this.afterDvsDataMap.put(entityKey, entityData);
                    continue;
                }
                if (entityKey.isFuture) {
                    throw new RuntimeException("Future object with no dvsData");
                }
                SerializedEntity serializedEntity = this.beforeDataMap.get(entityKey);
                Object entityInstance = serializedEntity == null ? this.getEntityInstance(entityKey) : serializedEntity.entityInstance;
                if (entityInstance == null) continue;
                this.afterDvsDataMap.put(entityKey, new EntityData(entityInstance, null));
            }
            done.addAll(queue);
            queue.addAll(this.involvedKeys);
            queue.removeAll(done);
        }
    }

    private void constructBeforeDataMap() throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSONException, InstantiationException {
        for (EntityKey entityKey : this.involvedKeys) {
            if (entityKey.isFuture) continue;
            this.beforeDataMap.put(entityKey, this.getSerializedEntity(entityKey));
        }
    }

    private Collection<Object> createCollection(Class<?> colType) {
        return colType == List.class ? new ArrayList<Object>() : (colType == Set.class ? new HashSet() : null);
    }

    private void decodeDVS(String content) throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        JSONObject jsonObject = new JSONObject(content);
        for (WriteOperation writeOperation : WriteOperation.values()) {
            if (!jsonObject.has(writeOperation.name())) continue;
            JSONArray reportArray = new JSONArray(jsonObject.getString(writeOperation.name()));
            int length = reportArray.length();
            if (length == 0) {
                throw new IllegalArgumentException("No json array for " + writeOperation.name() + " should have been sent");
            }
            for (int i = 0; i < length; ++i) {
                JSONObject recordWithSchema = reportArray.getJSONObject(i);
                Iterator iterator = recordWithSchema.keys();
                String recordToken = (String)iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalArgumentException("There cannot be more than one record token");
                }
                JSONObject recordObject = recordWithSchema.getJSONObject(recordToken);
                Class<EntityProxy> record = JsonRequestProcessor.getRecordFromClassToken(recordToken);
                EntityKey entityKey = new EntityKey(recordObject.getString("!id"), writeOperation == WriteOperation.PERSIST, record);
                this.involvedKeys.add(entityKey);
                this.dvsDataMap.put(entityKey, new DvsData(recordObject, writeOperation));
            }
        }
    }

    private String encodeId(Object id) {
        if (id instanceof String) {
            return JsonRequestProcessor.base64Encode((String)id);
        }
        return this.encodePropertyValue(id).toString();
    }

    private String encodeRelated(Class<?> propertyType, String propertyName, RequestProperty propertyContext, Object returnValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, JSONException {
        String encodedId = this.isEntityReference(returnValue, propertyType);
        String keyRef = new EntityKey(encodedId, false, propertyType).toString();
        this.addRelatedObject(keyRef, returnValue, this.castToRecordClass(propertyType), propertyContext.getProperty(propertyName));
        return keyRef;
    }

    private JSONObject encodeRelatedObjectsToJson() throws JSONException {
        JSONObject array = new JSONObject();
        for (Map.Entry<String, JSONObject> entry : this.relatedObjects.entrySet()) {
            array.put(entry.getKey(), (Object)entry.getValue());
        }
        return array;
    }

    private JSONObject getCreateReturnRecord(EntityKey originalEntityKey, EntityData entityData) throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        assert (originalEntityKey.isFuture);
        Object entityInstance = entityData.entityInstance;
        assert (entityInstance != null);
        Object newId = this.getRawPropertyValueFromDatastore(entityInstance, "id");
        if (newId == null) {
            return null;
        }
        newId = this.encodeId(newId);
        JSONObject returnObject = this.getJsonObjectWithIdAndVersion(this.getSchemaAndId(originalEntityKey.proxyType, newId), entityInstance, this.propertyRefs);
        returnObject.put("!futureId", (Object)(originalEntityKey.encodedId + ""));
        return returnObject;
    }

    private EntityKey getEntityKey(String string) {
        String[] parts = string.split("@");
        assert (parts.length == 3);
        String encodedId = parts[0];
        return new EntityKey(encodedId, "IS".equals(parts[1]), JsonRequestProcessor.getRecordFromClassToken(parts[2]));
    }

    private Method getIdMethodForEntity(Class<?> entityType) throws NoSuchMethodException {
        Method idMethod = entityType.getMethod(this.getMethodNameFromPropertyName("id", "get"), new Class[0]);
        return idMethod;
    }

    private JSONObject getJsonObjectWithIdAndVersion(String encodedId, Object entityElement, RequestProperty propertyContext) throws JSONException, SecurityException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("!id", (Object)encodedId);
        jsonObject.put("!version", this.encodePropertyValueFromDataStore(entityElement, Constants.ENTITY_VERSION_PROPERTY, Constants.ENTITY_VERSION_PROPERTY.getName(), propertyContext));
        return jsonObject;
    }

    private Object getPropertyValueFromRequestCached(JSONArray recordArray, int index, Property<?> dtoProperty) throws JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object propertyValue;
        Class<Object> leafType;
        Class<Object> clazz = leafType = dtoProperty instanceof CollectionProperty ? ((CollectionProperty)dtoProperty).getLeafType() : dtoProperty.getType();
        if (EntityProxy.class.isAssignableFrom(leafType)) {
            EntityKey propKey = this.getEntityKey(recordArray.getString(index));
            Object cacheValue = this.cachedEntityLookup.get(propKey);
            propertyValue = this.cachedEntityLookup.containsKey(propKey) ? cacheValue : this.getPropertyValueFromRequest(recordArray, index, leafType);
        } else {
            propertyValue = this.getPropertyValueFromRequest(recordArray, index, leafType);
        }
        return propertyValue;
    }

    private Object getPropertyValueFromRequestCached(JSONObject recordObject, Map<String, Property<?>> propertiesInProxy, String key, Property<?> dtoProperty) throws JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object propertyValue;
        if (!recordObject.isNull(key) && EntityProxy.class.isAssignableFrom(dtoProperty.getType())) {
            EntityKey propKey = this.getEntityKey(recordObject.getString(key));
            Object cacheValue = this.cachedEntityLookup.get(propKey);
            propertyValue = this.cachedEntityLookup.containsKey(propKey) ? cacheValue : this.getPropertyValueFromRequest(recordObject, key, propertiesInProxy.get(key).getType());
        } else {
            propertyValue = this.getPropertyValueFromRequest(recordObject, key, propertiesInProxy.get(key).getType());
        }
        return propertyValue;
    }

    private Object getRawPropertyValueFromDatastore(Object entityElement, String propertyName) throws SecurityException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = this.getMethodNameFromPropertyName(propertyName, "get");
        Method method = entityElement.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(entityElement, new Object[0]);
    }

    private String getSchemaAndId(Class<? extends EntityProxy> proxyType, Object newId) {
        return proxyType.getName() + "@" + newId;
    }

    private SerializedEntity getSerializedEntity(EntityKey entityKey) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSONException, InstantiationException {
        Object entityInstance = this.getEntityInstance(entityKey);
        JSONObject serializedEntity = this.serializeEntity(entityInstance, entityKey);
        return new SerializedEntity(entityInstance, serializedEntity);
    }

    private JSONObject getSideEffects() throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IllegalArgumentException, InstantiationException {
        JSONObject sideEffects = new JSONObject();
        JSONArray createArray = new JSONArray();
        JSONArray deleteArray = new JSONArray();
        JSONArray updateArray = new JSONArray();
        for (EntityKey entityKey : this.involvedKeys) {
            EntityData entityData = this.afterDvsDataMap.get(entityKey);
            if (entityData == null) continue;
            if (entityKey.isFuture) {
                JSONObject createRecord = this.getCreateReturnRecord(entityKey, entityData);
                if (createRecord == null) continue;
                createArray.put((Object)createRecord);
                continue;
            }
            Object entityInstanceAfterOperation = this.getEntityInstance(entityKey);
            if (null == entityInstanceAfterOperation) {
                JSONObject deleteRecord = new JSONObject();
                deleteRecord.put("!id", (Object)this.getSchemaAndId(entityKey.proxyType, entityKey.encodedId));
                deleteArray.put((Object)deleteRecord);
                continue;
            }
            boolean clientNeedsUpdating = false;
            DvsData dvsData = this.dvsDataMap.get(entityKey);
            if (dvsData != null && dvsData.version != null) {
                Integer serverVersion = (Integer)this.getRawPropertyValueFromDatastore(entityInstanceAfterOperation, Constants.ENTITY_VERSION_PROPERTY.getName());
                if (!dvsData.version.equals(serverVersion)) {
                    clientNeedsUpdating = true;
                }
            }
            if (!clientNeedsUpdating && !this.hasServerVersionChanged(entityKey, entityInstanceAfterOperation)) continue;
            updateArray.put((Object)this.getJsonObjectWithIdAndVersion(this.getSchemaAndId(entityKey.proxyType, entityKey.encodedId), entityInstanceAfterOperation, this.propertyRefs));
        }
        if (createArray.length() > 0) {
            sideEffects.put(WriteOperation.PERSIST.name(), (Object)createArray);
        }
        if (deleteArray.length() > 0) {
            sideEffects.put(WriteOperation.DELETE.name(), (Object)deleteArray);
        }
        if (updateArray.length() > 0) {
            sideEffects.put(WriteOperation.UPDATE.name(), (Object)updateArray);
        }
        return sideEffects;
    }

    private JSONArray getViolations() throws JSONException {
        JSONArray violations = new JSONArray();
        for (EntityKey entityKey : this.involvedKeys) {
            DvsData dvsData;
            EntityData entityData = this.afterDvsDataMap.get(entityKey);
            if (entityData == null || entityData.violations == null || entityData.violations.length() == 0 || (dvsData = this.dvsDataMap.get(entityKey)) == null) continue;
            JSONObject returnObject = new JSONObject();
            returnObject.put("violations", (Object)entityData.violations);
            if (entityKey.isFuture) {
                returnObject.put("!futureId", (Object)entityKey.encodedId);
                returnObject.put("!id", (Object)this.getSchemaAndId(entityKey.proxyType, null));
            } else {
                returnObject.put("!id", (Object)this.getSchemaAndId(entityKey.proxyType, entityKey.encodedId));
            }
            violations.put((Object)returnObject);
        }
        return violations;
    }

    private boolean hasServerVersionChanged(EntityKey entityKey, Object entityInstanceAfterOperation) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSONException, InstantiationException {
        SerializedEntity beforeEntity = this.beforeDataMap.get(entityKey);
        return beforeEntity != null && this.hasChanged(beforeEntity.serializedEntity, this.serializeEntity(entityInstanceAfterOperation, entityKey));
    }

    private String isEntityReference(Object entity, Class<?> proxyPropertyType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (entity != null && EntityProxy.class.isAssignableFrom(proxyPropertyType)) {
            Method idMethod = this.getIdMethodForEntity(entity.getClass());
            return this.encodeId(idMethod.invoke(entity, new Object[0]));
        }
        return null;
    }

    private boolean requestedProperty(Property<?> p, RequestProperty propertyContext) {
        if (propertyContext == null) {
            return false;
        }
        Class<Object> leafType = p.getType();
        if (p instanceof CollectionProperty) {
            leafType = ((CollectionProperty)p).getLeafType();
        }
        if (EntityProxy.class.isAssignableFrom(leafType)) {
            return propertyContext.hasProperty(p.getName());
        }
        return true;
    }

    private JSONObject serializeEntity(Object entityInstance, EntityKey entityKey) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, JSONException {
        if (entityInstance == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("!id", (Object)entityKey.encodedId);
        for (Property<?> p : this.allProperties(entityKey.proxyType)) {
            Object propertyValue;
            String propertyName = p.getName();
            String methodName = this.getMethodNameFromPropertyName(propertyName, "get");
            Method method = entityInstance.getClass().getMethod(methodName, new Class[0]);
            Object returnValue = method.invoke(entityInstance, new Object[0]);
            String encodedEntityId = this.isEntityReference(returnValue, p.getType());
            if (returnValue == null) {
                propertyValue = JSONObject.NULL;
            } else if (encodedEntityId != null) {
                propertyValue = encodedEntityId + "@NO@" + this.operationRegistry.getSecurityProvider().encodeClassType(p.getType());
            } else if (p instanceof CollectionProperty) {
                JSONArray array = new JSONArray();
                for (Object val : (Collection)returnValue) {
                    String encodedIdVal = this.isEntityReference(val, p.getType());
                    propertyValue = encodedIdVal != null ? encodedIdVal + "@NO@" + this.operationRegistry.getSecurityProvider().encodeClassType(p.getType()) : this.encodePropertyValue(val);
                    array.put(propertyValue);
                }
                propertyValue = array;
            } else {
                propertyValue = this.encodePropertyValue(returnValue);
            }
            jsonObject.put(propertyName, propertyValue);
        }
        return jsonObject;
    }

    private Object toJsonArray(RequestDefinition operation, Object result) throws IllegalAccessException, JSONException, NoSuchMethodException, InvocationTargetException {
        JSONArray jsonArray = this.getJsonArray((Collection)result, operation.getReturnType());
        return jsonArray;
    }

    private Map<String, Class<?>> updatePropertyTypes(Map<String, Property<?>> propertiesInProxy, Class<?> entity) {
        HashMap toReturn = new HashMap();
        for (Field field : entity.getDeclaredFields()) {
            Property<?> property = propertiesInProxy.get(field.getName());
            if (property == null) continue;
            Class<?> fieldType = property.getType();
            if (property instanceof CollectionProperty) {
                toReturn.put(field.getName(), fieldType);
                continue;
            }
            if (fieldType == null) continue;
            if (EntityProxy.class.isAssignableFrom(fieldType)) {
                ProxyForName pFN;
                ProxyFor pFor = fieldType.getAnnotation(ProxyFor.class);
                if (pFor != null) {
                    fieldType = pFor.value();
                }
                if ((pFN = fieldType.getAnnotation(ProxyForName.class)) != null) {
                    try {
                        fieldType = Class.forName(pFN.value(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException ignored) {
                        // empty catch block
                    }
                }
                if (!fieldType.equals(field.getType())) {
                    fieldType = field.getType();
                }
            }
            toReturn.put(field.getName(), fieldType);
        }
        return toReturn;
    }

    private class DvsData {
        private final JSONObject jsonObject;
        private final WriteOperation writeOperation;
        private final Integer version;

        DvsData(JSONObject jsonObject, WriteOperation writeOperation) throws JSONException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            this.jsonObject = jsonObject;
            this.writeOperation = writeOperation;
            this.version = (Integer)(jsonObject.has("!version") ? JsonRequestProcessor.this.decodeParameterValue(Constants.ENTITY_VERSION_PROPERTY.getType(), jsonObject.get("!version").toString()) : null);
        }
    }

    private static class EntityData {
        private final Object entityInstance;
        private final JSONObject violations;

        EntityData(Object entityInstance, JSONObject violations) {
            this.entityInstance = entityInstance;
            this.violations = violations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntityKey {
        final boolean isFuture;
        final String encodedId;
        final Class<? extends EntityProxy> proxyType;

        EntityKey(String id, boolean isFuture, Class<? extends EntityProxy> proxyType) {
            this.encodedId = id;
            this.isFuture = isFuture;
            assert (proxyType != null);
            this.proxyType = proxyType;
        }

        public Object decodedId(Class<?> entityIdType) throws SecurityException, JSONException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
            if (this.isFuture) {
                return this.encodedId;
            }
            if (String.class.isAssignableFrom(entityIdType)) {
                return JsonRequestProcessor.base64Decode(this.encodedId);
            }
            return JsonRequestProcessor.this.decodeParameterValue(entityIdType, this.encodedId);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof EntityKey)) {
                return false;
            }
            EntityKey other = (EntityKey)ob;
            return this.encodedId.equals(other.encodedId) && this.isFuture == other.isFuture && this.proxyType.equals(other.proxyType);
        }

        public int hashCode() {
            return 31 * this.proxyType.hashCode() + (31 * this.encodedId.hashCode() + (this.isFuture ? 1 : 0));
        }

        public String toString() {
            return this.encodedId + "@" + (this.isFuture ? "IS" : "NO") + "@" + this.proxyType.getName();
        }
    }

    private static class SerializedEntity {
        private final Object entityInstance;
        private final JSONObject serializedEntity;

        SerializedEntity(Object entityInstance, JSONObject serializedEntity) {
            this.entityInstance = entityInstance;
            this.serializedEntity = serializedEntity;
        }
    }
}

