/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridParser
implements ElementParser {
    private static final String ROW_TAG = "row";
    private static final String CELL_TAG = "cell";
    private static final String CUSTOMCELL_TAG = "customCell";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        ArrayList<List<CellContent>> matrix = new ArrayList<List<CellContent>>();
        this.parseRows(elem, fieldName, writer, matrix);
        Size size = this.getMatrixSize(matrix);
        if (size.getRows() > 0 || size.getColumns() > 0) {
            writer.addStatement("%s.resize(%s, %s);", new Object[]{fieldName, Integer.toString(size.getRows()), Integer.toString(size.getColumns())});
            for (List list : matrix) {
                for (CellContent column : list) {
                    if (column.getTagName().equals(CELL_TAG)) {
                        writer.addStatement("%s.setHTML(%s, %s, \"%s\");", new Object[]{fieldName, Integer.toString(matrix.indexOf(list)), Integer.toString(list.indexOf(column)), column.getConent()});
                    }
                    if (!column.getTagName().equals(CUSTOMCELL_TAG)) continue;
                    writer.addStatement("%s.setWidget(%s, %s, %s);", new Object[]{fieldName, Integer.toString(matrix.indexOf(list)), Integer.toString(list.indexOf(column)), column.getConent()});
                }
            }
        }
    }

    private Size getMatrixSize(List<List<CellContent>> matrix) {
        Size size = new Size();
        size.setRows(matrix.size());
        int maxColumns = 0;
        for (List<CellContent> column : matrix) {
            maxColumns = column.size() > maxColumns ? column.size() : maxColumns;
        }
        size.setColumns(maxColumns);
        return size;
    }

    private void parseColumns(String fieldName, UiBinderWriter writer, List<List<CellContent>> matrix, XMLElement child) throws UnableToCompleteException {
        for (XMLElement cell : child.consumeChildElements()) {
            String tagName = cell.getLocalName();
            if (!tagName.equals(CELL_TAG) && !tagName.equals(CUSTOMCELL_TAG) || !cell.getPrefix().equals(child.getPrefix())) {
                writer.die("Grid's row tag in %s may only contain %s or %s element.", new Object[]{fieldName, CELL_TAG, CUSTOMCELL_TAG});
            }
            CellContent newColumn = null;
            if (tagName.equals(CELL_TAG)) {
                HtmlInterpreter htmlInt = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                String html = cell.consumeInnerHtml((XMLElement.Interpreter)htmlInt);
                newColumn = new CellContent(tagName, html);
            }
            if (tagName.equals(CUSTOMCELL_TAG)) {
                newColumn = new CellContent(tagName, writer.parseElementToField(cell.consumeSingleChildElement()));
            }
            matrix.get(matrix.size() - 1).add(newColumn);
        }
    }

    private void parseRows(XMLElement elem, String fieldName, UiBinderWriter writer, List<List<CellContent>> matrix) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            String tagName = child.getLocalName();
            if (!tagName.equals(ROW_TAG) || !elem.getPrefix().equals(child.getPrefix())) {
                writer.die("%1$s:Grid elements must contain only %1$s:%2$s children, found %3$s:%4$s", new Object[]{elem.getPrefix(), ROW_TAG, child.getPrefix(), tagName});
            }
            ArrayList newRow = new ArrayList();
            matrix.add(newRow);
            this.parseColumns(fieldName, writer, matrix, child);
        }
    }

    private static class CellContent {
        private String tagName;
        private String content;

        public CellContent(String tagName, String content) {
            this.tagName = tagName;
            this.content = content;
        }

        public String getConent() {
            return this.content;
        }

        public String getTagName() {
            return this.tagName;
        }
    }

    private static class Size {
        private int rows = 0;
        private int columns = 0;

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public void setColumns(int cols) {
            this.columns = cols;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }
    }
}

