/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HasDataPresenter<T>
implements HasData<T>,
HasKeyProvider<T>,
HasKeyboardPagingPolicy {
    static final int PAGE_INCREMENT = 30;
    private final HasData<T> display;
    private int keyboardSelectedRow = 0;
    private T keyboardSelectedRowValue;
    private HasKeyboardPagingPolicy.KeyboardPagingPolicy keyboardPagingPolicy = HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE;
    private HasKeyboardSelectionPolicy.KeyboardSelectionPolicy keyboardSelectionPolicy = HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED;
    private final ProvidesKey<T> keyProvider;
    private SafeHtml lastContents = null;
    private int pageSize;
    private int pageStart = 0;
    private boolean pageStartChangedSinceRender;
    private int rowCount = 0;
    private boolean rowCountIsExact;
    private final List<T> rowData = new ArrayList<T>();
    private final Set<Integer> selectedRows = new HashSet<Integer>();
    private HandlerRegistration selectionHandler;
    private SelectionModel<? super T> selectionModel;
    private final View<T> view;

    public HasDataPresenter(HasData<T> display, View<T> view, int pageSize, ProvidesKey<T> keyProvider) {
        this.display = display;
        this.view = view;
        this.pageSize = pageSize;
        this.keyProvider = keyProvider;
    }

    @Override
    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.view.addHandler(handler, RangeChangeEvent.getType());
    }

    @Override
    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.view.addHandler(handler, RowCountChangeEvent.getType());
    }

    public void clearSelectionModel() {
        if (this.selectionHandler != null) {
            this.selectionHandler.removeHandler();
            this.selectionHandler = null;
        }
        this.selectionModel = null;
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        throw new UnsupportedOperationException();
    }

    public int getCurrentPageSize() {
        return Math.min(this.pageSize, this.rowCount - this.pageStart);
    }

    @Override
    public HasKeyboardPagingPolicy.KeyboardPagingPolicy getKeyboardPagingPolicy() {
        return this.keyboardPagingPolicy;
    }

    public int getKeyboardSelectedRow() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy ? -1 : this.keyboardSelectedRow;
    }

    @Override
    public HasKeyboardSelectionPolicy.KeyboardSelectionPolicy getKeyboardSelectionPolicy() {
        return this.keyboardSelectionPolicy;
    }

    @Override
    public ProvidesKey<T> getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public List<T> getRowData() {
        return this.rowData;
    }

    @Override
    public SelectionModel<? super T> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public Range getVisibleRange() {
        return new Range(this.pageStart, this.pageSize);
    }

    public boolean hasKeyboardNext() {
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy) {
            return false;
        }
        if (this.keyboardSelectedRow < this.rowData.size() - 1) {
            return true;
        }
        return !this.keyboardPagingPolicy.isLimitedToRange() && (this.keyboardSelectedRow + this.pageStart < this.rowCount - 1 || !this.rowCountIsExact);
    }

    public boolean hasKeyboardPrev() {
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy) {
            return false;
        }
        if (this.keyboardSelectedRow > 0) {
            return true;
        }
        return !this.keyboardPagingPolicy.isLimitedToRange() && this.pageStart > 0;
    }

    @Override
    public boolean isRowCountExact() {
        return this.rowCountIsExact;
    }

    public void keyboardEnd() {
        if (!this.keyboardPagingPolicy.isLimitedToRange()) {
            this.setKeyboardSelectedRow(this.rowCount - 1, true);
        }
    }

    public void keyboardHome() {
        if (!this.keyboardPagingPolicy.isLimitedToRange()) {
            this.setKeyboardSelectedRow(-this.pageStart, true);
        }
    }

    public void keyboardNext() {
        if (this.hasKeyboardNext()) {
            this.setKeyboardSelectedRow(this.keyboardSelectedRow + 1, true);
        }
    }

    public void keyboardNextPage() {
        if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == this.keyboardPagingPolicy) {
            this.setKeyboardSelectedRow(this.pageSize, true);
        } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == this.keyboardPagingPolicy) {
            this.setKeyboardSelectedRow(this.keyboardSelectedRow + 30, true);
        }
    }

    public void keyboardPrev() {
        if (this.hasKeyboardPrev()) {
            this.setKeyboardSelectedRow(this.keyboardSelectedRow - 1, true);
        }
    }

    public void keyboardPrevPage() {
        if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == this.keyboardPagingPolicy) {
            this.setKeyboardSelectedRow(-this.pageSize, true);
        } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == this.keyboardPagingPolicy) {
            this.setKeyboardSelectedRow(this.keyboardSelectedRow - 30, true);
        }
    }

    public void keyboardToggleSelect() {
        T value;
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED == this.keyboardSelectionPolicy && this.selectionModel != null && this.keyboardSelectedRow >= 0 && this.keyboardSelectedRow < this.rowData.size() && (value = this.rowData.get(this.keyboardSelectedRow)) != null) {
            this.selectionModel.setSelected(value, !this.selectionModel.isSelected(value));
        }
    }

    public void redraw() {
        this.lastContents = null;
        this.setRowData(this.pageStart, this.rowData);
    }

    @Override
    public void setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("KeyboardPagingPolicy cannot be null");
        }
        this.keyboardPagingPolicy = policy;
    }

    public void setKeyboardSelectedRow(int index, boolean stealFocus) {
        int absIndex;
        boolean isBound;
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy) {
            return;
        }
        boolean bl = isBound = HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.keyboardSelectionPolicy;
        if (this.keyboardSelectedRow >= 0 && this.keyboardSelectedRow < this.view.getChildCount()) {
            this.view.setKeyboardSelected(this.keyboardSelectedRow, false, false);
            if (isBound) {
                this.deselectKeyboardValue();
            }
        }
        if ((absIndex = this.pageStart + index) < 0) {
            absIndex = 0;
        } else if (absIndex >= this.rowCount && this.rowCountIsExact) {
            absIndex = this.rowCount - 1;
        }
        index = absIndex - this.pageStart;
        if (this.keyboardPagingPolicy.isLimitedToRange()) {
            index = Math.max(0, Math.min(index, this.pageSize - 1));
        }
        int newPageStart = this.pageStart;
        int newPageSize = this.pageSize;
        this.keyboardSelectedRow = 0;
        if (index >= 0 && index < this.pageSize) {
            this.keyboardSelectedRow = index;
            if (isBound) {
                this.selectKeyboardValue(index);
            }
            this.view.setKeyboardSelected(index, true, stealFocus);
            return;
        }
        if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == this.keyboardPagingPolicy) {
            while (index < 0) {
                newPageStart -= this.pageSize;
                index += this.pageSize;
            }
            while (index >= this.pageSize) {
                newPageStart += this.pageSize;
                index -= this.pageSize;
            }
        } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == this.keyboardPagingPolicy) {
            while (index < 0) {
                newPageSize += 30;
                newPageStart -= 30;
                index += 30;
            }
            if (newPageStart < 0) {
                index += newPageStart;
                newPageSize += newPageStart;
                newPageStart = 0;
            }
            while (index >= newPageSize) {
                newPageSize += 30;
            }
            if (this.isRowCountExact()) {
                newPageSize = Math.min(newPageSize, this.rowCount - newPageStart);
                if (index >= this.rowCount) {
                    index = this.rowCount - 1;
                }
            }
        }
        if (newPageStart != this.pageStart || newPageSize != this.pageSize) {
            this.deselectKeyboardValue();
            this.keyboardSelectedRow = index;
            this.setVisibleRange(new Range(newPageStart, newPageSize), false, false);
        }
    }

    @Override
    public void setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("KeyboardSelectionPolicy cannot be null");
        }
        this.keyboardSelectionPolicy = policy;
    }

    @Override
    public final void setRowCount(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowCount(int count, boolean isExact) {
        if (count == this.rowCount && isExact == this.rowCountIsExact) {
            return;
        }
        this.rowCount = count;
        this.rowCountIsExact = isExact;
        this.updateLoadingState();
        if (this.keyboardSelectedRow >= count) {
            this.keyboardSelectedRow = Math.max(0, count - 1);
        }
        if (this.updateCachedData()) {
            this.redraw();
        }
        RowCountChangeEvent.fire(this.display, count, this.rowCountIsExact);
    }

    @Override
    public void setRowData(int start, List<? extends T> values) {
        int valuesLength = values.size();
        int valuesEnd = start + valuesLength;
        int pageEnd = this.pageStart + this.pageSize;
        int boundedStart = Math.max(start, this.pageStart);
        int boundedEnd = Math.min(valuesEnd, pageEnd);
        if (start != this.pageStart && boundedStart >= boundedEnd) {
            return;
        }
        if (valuesEnd > this.rowCount) {
            this.rowCount = valuesEnd;
            RowCountChangeEvent.fire(this.display, this.rowCount, this.rowCountIsExact);
        }
        int cacheOffset = Math.max(0, boundedStart - this.pageStart - this.rowData.size());
        for (int i = 0; i < cacheOffset; ++i) {
            this.rowData.add(null);
        }
        Object keyboardSelectedKey = null;
        int keyboardSelectedAbsoluteRow = this.pageStart + this.keyboardSelectedRow;
        boolean keyboardSelectedInRange = false;
        boolean keyboardSelectedStillExists = false;
        if (keyboardSelectedAbsoluteRow >= boundedStart && keyboardSelectedAbsoluteRow < boundedEnd) {
            keyboardSelectedInRange = true;
            if (this.keyboardSelectedRowValue != null) {
                keyboardSelectedKey = this.getRowValueKey(this.keyboardSelectedRowValue);
                this.keyboardSelectedRow = 0;
            }
        }
        for (int i = boundedStart; i < boundedEnd; ++i) {
            T value = values.get(i - start);
            int dataIndex = i - this.pageStart;
            if (dataIndex < this.rowData.size()) {
                this.rowData.set(dataIndex, value);
            } else {
                this.rowData.add(value);
            }
            if (this.selectionModel != null) {
                if (value != null && this.selectionModel.isSelected(value)) {
                    this.selectedRows.add(i);
                } else {
                    this.selectedRows.remove(i);
                }
            }
            if (keyboardSelectedKey == null || value == null || !keyboardSelectedKey.equals(this.getRowValueKey(value))) continue;
            this.keyboardSelectedRow = i - this.pageStart;
            keyboardSelectedStillExists = true;
        }
        boundedStart = this.pageStartChangedSinceRender ? this.pageStart : boundedStart;
        List<T> boundedValues = this.rowData.subList((boundedStart -= cacheOffset) - this.pageStart, boundedEnd - this.pageStart);
        int boundedSize = boundedValues.size();
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.view.render(sb, boundedValues, boundedStart, this.selectionModel);
        this.updateLoadingState();
        int childCount = this.view.getChildCount();
        if (boundedStart == this.pageStart && (boundedSize >= childCount || boundedSize >= this.getCurrentPageSize() || this.rowData.size() < childCount)) {
            SafeHtml newContents = sb.toSafeHtml();
            if (!((Object)newContents).equals(this.lastContents)) {
                this.lastContents = newContents;
                this.view.replaceAllChildren(boundedValues, newContents);
            }
            this.view.resetFocus();
        } else {
            this.lastContents = null;
            this.view.replaceChildren(boundedValues, boundedStart - this.pageStart, sb.toSafeHtml());
            if (keyboardSelectedStillExists) {
                this.view.resetFocus();
            }
        }
        this.pageStartChangedSinceRender = false;
        if (keyboardSelectedInRange && !keyboardSelectedStillExists) {
            if (keyboardSelectedKey != null) {
                this.deselectKeyboardValue();
            }
            if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.keyboardSelectionPolicy) {
                this.selectKeyboardValue(this.keyboardSelectedRow);
            }
        }
    }

    @Override
    public final void setVisibleRange(int start, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVisibleRange(Range range) {
        this.setVisibleRange(range, false, false);
    }

    @Override
    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.setVisibleRange(range, true, forceRangeChangeEvent);
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.clearSelectionModel();
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            this.selectionHandler = selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

                public void onSelectionChange(SelectionChangeEvent event) {
                    HasDataPresenter.this.updateSelection();
                }
            });
        }
        this.updateSelection();
    }

    private void deselectKeyboardValue() {
        if (this.selectionModel != null && this.keyboardSelectedRowValue != null) {
            T curValue = this.keyboardSelectedRowValue;
            this.keyboardSelectedRow = 0;
            this.keyboardSelectedRowValue = null;
            this.selectionModel.setSelected(curValue, false);
        }
    }

    private Object getRowValueKey(T rowValue) {
        return this.keyProvider == null ? rowValue : this.keyProvider.getKey(rowValue);
    }

    private void selectKeyboardValue(int row) {
        if (this.selectionModel != null && row >= 0 && row < this.rowData.size()) {
            this.keyboardSelectedRowValue = this.rowData.get(row);
            if (this.keyboardSelectedRowValue != null) {
                this.selectionModel.setSelected(this.keyboardSelectedRowValue, true);
            }
        }
    }

    private void setVisibleRange(Range range, boolean clearData, boolean forceRangeChangeEvent) {
        boolean pageSizeChanged;
        boolean pageStartChanged;
        int start = range.getStart();
        int length = range.getLength();
        if (length < 0) {
            throw new IllegalArgumentException("Range length cannot be less than 1");
        }
        boolean bl = pageStartChanged = this.pageStart != start;
        if (pageStartChanged) {
            if (!clearData) {
                if (start > this.pageStart) {
                    int increase = start - this.pageStart;
                    if (this.rowData.size() > increase) {
                        for (int i = 0; i < increase; ++i) {
                            this.rowData.remove(0);
                        }
                    } else {
                        this.rowData.clear();
                    }
                } else {
                    int decrease = this.pageStart - start;
                    if (this.rowData.size() > 0 && decrease < this.pageSize) {
                        for (int i = 0; i < decrease; ++i) {
                            this.rowData.add(0, null);
                        }
                    } else {
                        this.rowData.clear();
                    }
                }
            }
            this.pageStart = start;
            this.pageStartChangedSinceRender = true;
        }
        boolean bl2 = pageSizeChanged = this.pageSize != length;
        if (pageSizeChanged) {
            this.pageSize = length;
        }
        if (clearData) {
            this.rowData.clear();
            this.selectedRows.clear();
        }
        this.updateLoadingState();
        if (pageStartChanged || clearData || this.updateCachedData()) {
            this.redraw();
        }
        if (pageStartChanged || pageSizeChanged || forceRangeChangeEvent) {
            RangeChangeEvent.fire(this.display, this.getVisibleRange());
        }
    }

    private boolean updateCachedData() {
        boolean updated = false;
        int expectedLastIndex = Math.max(0, Math.min(this.pageSize, this.rowCount - this.pageStart));
        for (int lastIndex = this.rowData.size() - 1; lastIndex >= expectedLastIndex; --lastIndex) {
            this.rowData.remove(lastIndex);
            this.selectedRows.remove(lastIndex + this.pageStart);
            updated = true;
        }
        return updated;
    }

    private void updateLoadingState() {
        int curPageSize;
        int cacheSize = this.rowData.size();
        int n = curPageSize = this.isRowCountExact() ? this.getCurrentPageSize() : this.pageSize;
        if (this.rowCount == 0 && this.rowCountIsExact) {
            this.view.setLoadingState(LoadingState.EMPTY);
        } else if (cacheSize >= curPageSize) {
            this.view.setLoadingState(LoadingState.LOADED);
        } else if (cacheSize == 0) {
            this.view.setLoadingState(LoadingState.LOADING);
        } else {
            this.view.setLoadingState(LoadingState.PARTIALLY_LOADED);
        }
    }

    private void updateSelection() {
        this.view.onUpdateSelection();
        boolean dependsOnSelection = this.view.dependsOnSelection();
        boolean refreshRequired = false;
        ElementIterator children = this.view.getChildIterator();
        int row = this.pageStart;
        for (T value : this.rowData) {
            boolean selected;
            if (!children.hasNext()) break;
            children.next();
            boolean bl = selected = this.selectionModel == null ? false : this.selectionModel.isSelected(value);
            if (selected != this.selectedRows.contains(row)) {
                refreshRequired = true;
                if (selected) {
                    this.selectedRows.add(row);
                } else {
                    this.selectedRows.remove(row);
                }
                if (!dependsOnSelection) {
                    children.setSelected(selected);
                }
            }
            ++row;
        }
        if (refreshRequired && dependsOnSelection) {
            this.redraw();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultElementIterator
    implements ElementIterator {
        private Element current;
        private Element next;
        private final View<?> view;

        public DefaultElementIterator(View<?> view, Element first) {
            this.view = view;
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.next.getNextSiblingElement();
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSelected(boolean selected) throws IllegalStateException {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.view.setSelected(this.current, selected);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ElementIterator
    extends Iterator<Element> {
        public void setSelected(boolean var1) throws IllegalStateException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LoadingState {
        LOADING,
        PARTIALLY_LOADED,
        LOADED,
        EMPTY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface View<T> {
        public <H extends EventHandler> HandlerRegistration addHandler(H var1, GwtEvent.Type<H> var2);

        public boolean dependsOnSelection();

        public int getChildCount();

        public ElementIterator getChildIterator();

        public void onUpdateSelection();

        public void render(SafeHtmlBuilder var1, List<T> var2, int var3, SelectionModel<? super T> var4);

        public void replaceAllChildren(List<T> var1, SafeHtml var2);

        public void replaceChildren(List<T> var1, int var2, SafeHtml var3);

        public void resetFocus();

        public void setKeyboardSelected(int var1, boolean var2, boolean var3);

        public void setLoadingState(LoadingState var1);

        public void setSelected(Element var1, boolean var2);
    }
}

