/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;

public class NotificationMole
extends Composite {
    private static final Binder BINDER = (Binder)GWT.create(Binder.class);
    @UiField
    DivElement borderElement;
    @UiField
    DivElement heightMeasure;
    @UiField
    SpanElement notificationText;
    int showAttempts = 0;
    Timer showTimer = new Timer(){

        public void run() {
            if (NotificationMole.this.showAttempts > 0) {
                NotificationMole.this.showImpl();
            }
        }
    };
    private final MoleAnimation animation = new MoleAnimation();
    private int animationDuration;

    public NotificationMole() {
        this.initWidget((Widget)BINDER.createAndBindUi(this));
    }

    public void hide() {
        if (this.showAttempts > 0) {
            --this.showAttempts;
        }
        if (this.showAttempts == 0) {
            this.animation.animateMole(this.heightMeasure.getOffsetHeight(), 0, this.animationDuration);
            return;
        }
    }

    public void hideNow() {
        this.showAttempts = 0;
        this.animation.animateMole(this.heightMeasure.getOffsetHeight(), 0, this.animationDuration);
    }

    public void setAnimationDuration(int duration) {
        this.animationDuration = duration;
    }

    public void setMessage(String message) {
        this.notificationText.setInnerText(message);
    }

    public void show() {
        ++this.showAttempts;
        this.showImpl();
    }

    public void show(String message) {
        this.setMessage(message);
        this.show();
    }

    public void showDelayed(int delay) {
        if (this.showAttempts == 0) {
            if (delay == 0) {
                this.show();
            } else {
                ++this.showAttempts;
                this.showTimer.schedule(delay);
            }
        }
    }

    private void showImpl() {
        this.borderElement.getStyle().setDisplay(Style.Display.BLOCK);
        this.borderElement.getStyle().setWidth(this.notificationText.getOffsetWidth(), Style.Unit.PX);
        this.animation.animateMole(0, this.heightMeasure.getOffsetHeight(), this.animationDuration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Binder
    extends UiBinder<HTMLPanel, NotificationMole> {
    }

    private class MoleAnimation
    extends Animation {
        private int endSize;
        private int startSize;

        private MoleAnimation() {
        }

        protected void onComplete() {
            if (this.endSize == 0) {
                NotificationMole.this.borderElement.getStyle().setDisplay(Style.Display.NONE);
                return;
            }
            NotificationMole.this.borderElement.getStyle().setHeight(this.endSize, Style.Unit.PX);
        }

        protected void onUpdate(double progress) {
            double delta = (double)(this.endSize - this.startSize) * progress;
            double newSize = (double)this.startSize + delta;
            NotificationMole.this.borderElement.getStyle().setHeight(newSize, Style.Unit.PX);
        }

        void animateMole(int startSize, int endSize, int duration) {
            this.startSize = startSize;
            this.endSize = endSize;
            if (duration == 0) {
                this.onComplete();
                return;
            }
            this.run(duration);
        }
    }

    public static interface Style
    extends CssResource {
        public String container();

        public String notificationText();
    }
}

