/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AttributeReply;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPDaemon;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.Service;
import ch.ethz.iks.slp.impl.ServiceAcknowledgement;
import ch.ethz.iks.slp.impl.ServiceDeregistration;
import ch.ethz.iks.slp.impl.ServiceRegistration;
import ch.ethz.iks.slp.impl.ServiceReply;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeReply;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SLPDaemonImpl
implements SLPDaemon {
    private boolean running = true;
    private Map registeredServices = new HashMap();
    private SortedMap serviceDisposalQueue = new TreeMap();

    public SLPDaemonImpl() throws Exception {
        new TcpServerThread();
        new ServiceDisposalThread();
        SLPCore.platform.logDebug("jSLP daemon starting ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ServiceRegistration serviceRegistration) {
        Service service = new Service(serviceRegistration);
        Iterator iterator = serviceRegistration.scopeList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.toLowerCase();
            Object object = this.registeredServices;
            synchronized (object) {
                SLPUtils.addValue(this.registeredServices, string, service);
            }
            if (serviceRegistration.url.getLifetime() > -1) {
                object = this.serviceDisposalQueue;
                synchronized (object) {
                    long l = System.currentTimeMillis() + (long)(serviceRegistration.url.getLifetime() * 1000);
                    ArrayList arrayList = new ArrayList(this.serviceDisposalQueue.keySet());
                    Iterator iterator2 = ((AbstractList)arrayList).iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!this.serviceDisposalQueue.get(e).equals(serviceRegistration.url)) continue;
                        this.serviceDisposalQueue.remove(e);
                    }
                    this.serviceDisposalQueue.put(new Long(l), serviceRegistration.url);
                    this.serviceDisposalQueue.notifyAll();
                }
            }
            SLPCore.platform.logTraceReg("REGISTERED " + serviceRegistration.url);
            object = (List)SLPCore.dAs.get(string);
            if ((object == null || object.isEmpty()) && !SLPCore.noDiscovery) {
                try {
                    SLPCore.daLookup(Arrays.asList(string));
                    Map map = SLPCore.dAs;
                    synchronized (map) {
                        try {
                            SLPCore.dAs.wait(SLPCore.CONFIG.getWaitTime());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    object = (List)SLPCore.dAs.get(string);
                }
                catch (ServiceLocationException serviceLocationException) {
                    SLPCore.platform.logError(serviceLocationException.getMessage(), serviceLocationException.fillInStackTrace());
                }
            }
            if (object == null || object.isEmpty()) continue;
            String[] stringArray = object.toArray(new String[object.size()]);
            ServiceRegistration serviceRegistration2 = new ServiceRegistration(serviceRegistration.url, serviceRegistration.serviceType, serviceRegistration.scopeList, serviceRegistration.attList, serviceRegistration.locale);
            serviceRegistration2.authBlocks = serviceRegistration.authBlocks;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.announceService(stringArray[i], serviceRegistration2);
                    SLPCore.platform.logTraceReg("ANNOUNCED " + serviceRegistration2.url + " to " + stringArray[i]);
                    continue;
                }
                catch (ServiceLocationException serviceLocationException) {
                    SLPUtils.removeValueFromAll(SLPCore.dAs, stringArray[i]);
                    SLPCore.dASPIs.remove(stringArray[i]);
                    SLPCore.platform.logError(serviceLocationException.getMessage(), serviceLocationException.fillInStackTrace());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterService(ServiceDeregistration serviceDeregistration) throws ServiceLocationException {
        String[] stringArray = this.registeredServices.keySet().toArray(new String[this.registeredServices.size()]);
        block5: for (int i = 0; i < stringArray.length; ++i) {
            List list = (List)this.registeredServices.get(stringArray[i]);
            Service[] serviceArray = list.toArray(new Service[list.size()]);
            for (int j = 0; j < serviceArray.length; ++j) {
                Object object;
                if (!serviceDeregistration.url.matches(serviceArray[j].url)) continue;
                List list2 = (List)SLPCore.dAs.get(stringArray[i].toLowerCase());
                if (list2 != null) {
                    object = list2.iterator();
                    while (object.hasNext()) {
                        try {
                            Object object2;
                            String string = (String)object.next();
                            serviceDeregistration.address = InetAddress.getByName(string);
                            serviceDeregistration.port = 427;
                            serviceDeregistration.xid = SLPCore.nextXid();
                            if (SLPCore.CONFIG.getSecurityEnabled()) {
                                object2 = (List)SLPCore.dASPIs.get(string);
                                serviceDeregistration.sign((List)object2);
                            }
                            object2 = SLPCore.sendMessage(serviceDeregistration, true);
                            if (((ReplyMessage)object2).errorCode == 0) continue;
                            throw new ServiceLocationException((short)((ReplyMessage)object2).errorCode, "Error during deregistration: " + ((ReplyMessage)object2).errorCode);
                        }
                        catch (UnknownHostException unknownHostException) {
                            throw new ServiceLocationException(19, unknownHostException.getMessage());
                        }
                    }
                }
                object = this.registeredServices;
                synchronized (object) {
                    SLPUtils.removeValue(this.registeredServices, stringArray[i], serviceArray[j]);
                    continue block5;
                }
            }
        }
    }

    public ReplyMessage handleMessage(SLPMessage sLPMessage) throws ServiceLocationException {
        if (sLPMessage == null) {
            return null;
        }
        String string = sLPMessage.tcp ? " (tcp)" : " (udp)";
        SLPCore.platform.logTraceMessage("RECEIVED (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + string);
        ReplyMessage replyMessage = null;
        switch (sLPMessage.funcID) {
            case 1: {
                ServiceRequest serviceRequest = (ServiceRequest)sLPMessage;
                ArrayList<ServiceURL> arrayList = new ArrayList<ServiceURL>();
                Iterator iterator = serviceRequest.scopeList.iterator();
                while (iterator.hasNext()) {
                    List list = (List)this.registeredServices.get(iterator.next());
                    if (list == null) continue;
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        Service service = (Service)iterator2.next();
                        if (!service.url.getServiceType().matches(serviceRequest.serviceType)) continue;
                        if (serviceRequest.predicate == null) {
                            arrayList.add(service.url);
                            continue;
                        }
                        if (!serviceRequest.predicate.match(service.attributes)) continue;
                        arrayList.add(service.url);
                    }
                }
                if (arrayList.size() == 0 && serviceRequest.multicast) {
                    return null;
                }
                replyMessage = new ServiceReply(serviceRequest, arrayList);
                if (SLPCore.CONFIG.getSecurityEnabled()) {
                    ((ServiceReply)replyMessage).sign(serviceRequest.spi);
                }
                return replyMessage;
            }
            case 6: {
                AttributeRequest attributeRequest = (AttributeRequest)sLPMessage;
                ArrayList arrayList = new ArrayList();
                Iterator iterator = attributeRequest.scopeList.iterator();
                while (iterator.hasNext()) {
                    Serializable serializable;
                    List list = (List)this.registeredServices.get(iterator.next());
                    if (list == null) continue;
                    boolean bl = false;
                    if (attributeRequest.url.indexOf("//") == -1) {
                        serializable = new ServiceType(attributeRequest.url);
                    } else {
                        bl = true;
                        serializable = new ServiceURL(attributeRequest.url, 0);
                    }
                    if (!attributeRequest.spi.equals("") && (!bl || !attributeRequest.tagList.isEmpty())) continue;
                    Iterator iterator3 = list.iterator();
                    while (iterator3.hasNext()) {
                        Service service = (Service)iterator3.next();
                        if (!service.url.matches(serializable)) continue;
                        arrayList.addAll(SLPUtils.findMatches(attributeRequest.tagList, service.attributes));
                    }
                }
                replyMessage = new AttributeReply(attributeRequest, arrayList);
                if (SLPCore.CONFIG.getSecurityEnabled()) {
                    ((AttributeReply)replyMessage).sign(attributeRequest.spi);
                }
                return replyMessage;
            }
            case 9: {
                ServiceTypeRequest serviceTypeRequest = (ServiceTypeRequest)sLPMessage;
                ArrayList<ServiceType> arrayList = new ArrayList<ServiceType>();
                Iterator iterator = serviceTypeRequest.scopeList.iterator();
                while (iterator.hasNext()) {
                    List list = (List)this.registeredServices.get(iterator.next());
                    if (list == null) continue;
                    Iterator iterator4 = list.iterator();
                    while (iterator4.hasNext()) {
                        Service service = (Service)iterator4.next();
                        ServiceType serviceType = service.url.getServiceType();
                        if (!serviceTypeRequest.namingAuthority.equals("*") && !serviceTypeRequest.namingAuthority.equals("") && !serviceType.getNamingAuthority().equals(serviceTypeRequest.namingAuthority) || arrayList.contains(serviceType)) continue;
                        arrayList.add(serviceType);
                    }
                }
                replyMessage = new ServiceTypeReply(serviceTypeRequest, arrayList);
                return replyMessage;
            }
            case 3: {
                this.registerService((ServiceRegistration)sLPMessage);
                replyMessage = new ServiceAcknowledgement(sLPMessage, 0);
                return replyMessage;
            }
            case 4: {
                this.deregisterService((ServiceDeregistration)sLPMessage);
                replyMessage = new ServiceAcknowledgement(sLPMessage, 0);
                return replyMessage;
            }
            case 5: {
                ReplyMessage replyMessage2 = (ReplyMessage)sLPMessage;
                if (replyMessage2.errorCode != 0) {
                    SLPCore.platform.logWarning(sLPMessage.address + " replied with error code " + replyMessage2.errorCode + " (" + replyMessage2 + ")");
                }
                return null;
            }
        }
        throw new ServiceLocationException(16, "The message type " + SLPMessage.getType(sLPMessage.funcID) + " is not implemented");
    }

    public void newDaDiscovered(DAAdvertisement dAAdvertisement) {
        Iterator iterator = dAAdvertisement.scopeList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.registeredServices.get(string);
            if (list == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                try {
                    Service service = (Service)iterator2.next();
                    ServiceRegistration serviceRegistration = new ServiceRegistration(service.url, service.url.getServiceType(), Arrays.asList(string), SLPUtils.dictToAttrList(service.attributes), SLPCore.DEFAULT_LOCALE);
                    SLPCore.platform.logDebug("Registering " + service.url + " with new DA " + dAAdvertisement.url);
                    this.announceService(dAAdvertisement.url, serviceRegistration);
                }
                catch (ServiceLocationException serviceLocationException) {
                    SLPCore.platform.logError(serviceLocationException.getMessage(), serviceLocationException.fillInStackTrace());
                }
            }
        }
    }

    private void announceService(String string, ServiceRegistration serviceRegistration) throws ServiceLocationException {
        try {
            serviceRegistration.address = InetAddress.getByName(string);
            serviceRegistration.port = 427;
            serviceRegistration.xid = SLPCore.nextXid();
            if (SLPCore.CONFIG.getSecurityEnabled()) {
                List list = (List)SLPCore.dASPIs.get(string);
                serviceRegistration.sign(list);
            }
            this.handleMessage(SLPCore.sendMessage(serviceRegistration, true));
        }
        catch (UnknownHostException unknownHostException) {
            SLPCore.platform.logError("Service announcement to " + string + " failed. ", unknownHostException.fillInStackTrace());
        }
    }

    private final class ServiceDisposalThread
    extends Thread {
        private ServiceDisposalThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (SLPDaemonImpl.this.running) {
                    SortedMap sortedMap = SLPDaemonImpl.this.serviceDisposalQueue;
                    synchronized (sortedMap) {
                        if (SLPDaemonImpl.this.serviceDisposalQueue.isEmpty()) {
                            SLPCore.platform.logDebug("ServiceDisposalThread sleeping ...");
                            SLPDaemonImpl.this.serviceDisposalQueue.wait();
                        } else {
                            long l;
                            Long l2;
                            while (!SLPDaemonImpl.this.serviceDisposalQueue.isEmpty() && (l2 = (Long)SLPDaemonImpl.this.serviceDisposalQueue.firstKey()) <= System.currentTimeMillis()) {
                                ServiceURL serviceURL = (ServiceURL)SLPDaemonImpl.this.serviceDisposalQueue.get(l2);
                                ServiceDeregistration serviceDeregistration = new ServiceDeregistration(serviceURL, null, null, SLPCore.DEFAULT_LOCALE);
                                try {
                                    SLPDaemonImpl.this.deregisterService(serviceDeregistration);
                                }
                                catch (ServiceLocationException serviceLocationException) {
                                    SLPCore.platform.logError(serviceLocationException.getMessage(), serviceLocationException.fillInStackTrace());
                                }
                                SLPCore.platform.logTraceReg("disposed service " + serviceURL);
                                SLPDaemonImpl.this.serviceDisposalQueue.remove(l2);
                            }
                            if (!SLPDaemonImpl.this.serviceDisposalQueue.isEmpty() && (l = (l2 = (Long)SLPDaemonImpl.this.serviceDisposalQueue.firstKey()) - System.currentTimeMillis()) > 0L) {
                                SLPCore.platform.logDebug("sleeping for " + l / 1000L + " seconds.");
                                SLPDaemonImpl.this.serviceDisposalQueue.wait(l);
                            }
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final class TcpServerThread
    extends Thread {
        private ServerSocket socket = new ServerSocket(SLPCore.SLP_PORT);

        private TcpServerThread() throws IOException {
            this.start();
        }

        public void run() {
            while (SLPDaemonImpl.this.running) {
                try {
                    Socket socket = this.socket.accept();
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                    SLPMessage sLPMessage = SLPMessage.parse(socket.getInetAddress(), socket.getPort(), dataInputStream, true);
                    ReplyMessage replyMessage = SLPDaemonImpl.this.handleMessage(sLPMessage);
                    if (replyMessage != null) {
                        SLPCore.platform.logTraceMessage("SEND REPLY (" + replyMessage.address + ":" + replyMessage.port + ") " + replyMessage);
                        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                        replyMessage.writeTo(dataOutputStream);
                        dataOutputStream.close();
                    }
                    dataInputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    SLPCore.platform.logError("Exception in TCP receiver thread", exception);
                }
            }
        }
    }
}

