/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtorm.client.Access;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.PrimaryKey;
import com.google.gwtorm.client.Query;
import com.google.gwtorm.client.ResultSet;

public interface ChangeAccess
extends Access<Change, Change.Id> {
    @PrimaryKey(value="changeId")
    public Change get(Change.Id var1) throws OrmException;

    @Query(value="WHERE changeKey = ?")
    public ResultSet<Change> byKey(Change.Key var1) throws OrmException;

    @Query(value="WHERE changeKey >= ? AND changeKey <= ?")
    public ResultSet<Change> byKeyRange(Change.Key var1, Change.Key var2) throws OrmException;

    @Query(value="WHERE dest.projectName = ? AND changeKey = ?")
    public ResultSet<Change> byProjectKey(Project.NameKey var1, Change.Key var2) throws OrmException;

    @Query(value="WHERE dest.projectName = ?")
    public ResultSet<Change> byProject(Project.NameKey var1) throws OrmException;

    @Query(value="WHERE owner = ? AND open = true ORDER BY createdOn, changeId")
    public ResultSet<Change> byOwnerOpen(Account.Id var1) throws OrmException;

    @Query(value="WHERE owner = ? AND open = false ORDER BY lastUpdatedOn DESC LIMIT 5")
    public ResultSet<Change> byOwnerClosed(Account.Id var1) throws OrmException;

    @Query(value="WHERE owner = ? AND open = false ORDER BY lastUpdatedOn")
    public ResultSet<Change> byOwnerClosedAll(Account.Id var1) throws OrmException;

    @Query(value="WHERE dest = ? AND status = 's' ORDER BY lastUpdatedOn")
    public ResultSet<Change> submitted(Branch.NameKey var1) throws OrmException;

    @Query(value="WHERE status = 's'")
    public ResultSet<Change> allSubmitted() throws OrmException;

    @Query(value="WHERE open = true AND sortKey > ? ORDER BY sortKey LIMIT ?")
    public ResultSet<Change> allOpenPrev(String var1, int var2) throws OrmException;

    @Query(value="WHERE open = true AND sortKey < ? ORDER BY sortKey DESC LIMIT ?")
    public ResultSet<Change> allOpenNext(String var1, int var2) throws OrmException;

    @Query(value="WHERE open = true AND dest.projectName = ?")
    public ResultSet<Change> byProjectOpenAll(Project.NameKey var1) throws OrmException;

    @Query(value="WHERE open = true AND dest.projectName = ? AND sortKey > ? ORDER BY sortKey LIMIT ?")
    public ResultSet<Change> byProjectOpenPrev(Project.NameKey var1, String var2, int var3) throws OrmException;

    @Query(value="WHERE open = true AND dest.projectName = ? AND sortKey < ? ORDER BY sortKey DESC LIMIT ?")
    public ResultSet<Change> byProjectOpenNext(Project.NameKey var1, String var2, int var3) throws OrmException;

    @Query(value="WHERE open = false AND status = ? AND dest.projectName = ? AND sortKey > ? ORDER BY sortKey LIMIT ?")
    public ResultSet<Change> byProjectClosedPrev(char var1, Project.NameKey var2, String var3, int var4) throws OrmException;

    @Query(value="WHERE open = false AND status = ? AND dest.projectName = ? AND sortKey < ? ORDER BY sortKey DESC LIMIT ?")
    public ResultSet<Change> byProjectClosedNext(char var1, Project.NameKey var2, String var3, int var4) throws OrmException;

    @Query(value="WHERE open = false AND status = ? AND sortKey > ? ORDER BY sortKey LIMIT ?")
    public ResultSet<Change> allClosedPrev(char var1, String var2, int var3) throws OrmException;

    @Query(value="WHERE open = false AND status = ? AND sortKey < ? ORDER BY sortKey DESC LIMIT ?")
    public ResultSet<Change> allClosedNext(char var1, String var2, int var3) throws OrmException;

    @Query
    public ResultSet<Change> all() throws OrmException;
}

