/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadElement;
import com.google.gwt.dom.client.StyleElement;

public class StyleInjector {
    private static final JsArrayString toInject = (JsArrayString)JavaScriptObject.createArray().cast();
    private static final JsArrayString toInjectAtEnd = (JsArrayString)JavaScriptObject.createArray().cast();
    private static final JsArrayString toInjectAtStart = (JsArrayString)JavaScriptObject.createArray().cast();
    private static Scheduler.ScheduledCommand flusher = new Scheduler.ScheduledCommand(){

        public void execute() {
            if (needsInjection) {
                StyleInjector.flush(null);
            }
        }
    };
    private static boolean needsInjection = false;

    public static void inject(String css) {
        StyleInjector.inject(css, false);
    }

    public static void inject(String css, boolean immediate) {
        toInject.push(css);
        StyleInjector.inject(immediate);
    }

    public static void injectAtEnd(String css) {
        StyleInjector.injectAtEnd(css, false);
    }

    public static void injectAtEnd(String css, boolean immediate) {
        toInjectAtEnd.push(css);
        StyleInjector.inject(immediate);
    }

    public static void injectAtStart(String css) {
        StyleInjector.injectAtStart(css, false);
    }

    public static void injectAtStart(String css, boolean immediate) {
        toInjectAtStart.unshift(css);
        StyleInjector.inject(immediate);
    }

    @Deprecated
    public static StyleElement injectStylesheet(String contents) {
        toInject.push(contents);
        return StyleInjector.flush(toInject);
    }

    @Deprecated
    public static StyleElement injectStylesheetAtEnd(String contents) {
        toInjectAtEnd.push(contents);
        return StyleInjector.flush(toInjectAtEnd);
    }

    @Deprecated
    public static StyleElement injectStylesheetAtStart(String contents) {
        toInjectAtStart.unshift(contents);
        return StyleInjector.flush(toInjectAtStart);
    }

    @Deprecated
    public static void setContents(StyleElement style, String contents) {
        StyleInjectorImpl.IMPL.setContents(style, contents);
    }

    private static StyleElement flush(JavaScriptObject which) {
        StyleElement maybeReturn;
        String css;
        StyleElement toReturn = null;
        if (toInjectAtStart.length() != 0) {
            css = toInjectAtStart.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheetAtStart(css);
            if (toInjectAtStart == which) {
                toReturn = maybeReturn;
            }
            toInjectAtStart.setLength(0);
        }
        if (toInject.length() != 0) {
            css = toInject.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheet(css);
            if (toInject == which) {
                toReturn = maybeReturn;
            }
            toInject.setLength(0);
        }
        if (toInjectAtEnd.length() != 0) {
            css = toInjectAtEnd.join("");
            maybeReturn = StyleInjectorImpl.IMPL.injectStyleSheetAtEnd(css);
            if (toInjectAtEnd == which) {
                toReturn = maybeReturn;
            }
            toInjectAtEnd.setLength(0);
        }
        needsInjection = false;
        return toReturn;
    }

    private static void inject(boolean immediate) {
        if (immediate) {
            StyleInjector.flush(null);
        } else {
            StyleInjector.schedule();
        }
    }

    private static void schedule() {
        if (!needsInjection) {
            needsInjection = true;
            Scheduler.get().scheduleFinally(flusher);
        }
    }

    private StyleInjector() {
    }

    public static class StyleInjectorImpl {
        private static final StyleInjectorImpl IMPL = (StyleInjectorImpl)GWT.create(StyleInjectorImpl.class);
        private HeadElement head;

        public StyleElement injectStyleSheet(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().appendChild(style);
            return style;
        }

        public StyleElement injectStyleSheetAtEnd(String contents) {
            return this.injectStyleSheet(contents);
        }

        public StyleElement injectStyleSheetAtStart(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().insertBefore(style, this.head.getFirstChild());
            return style;
        }

        public void setContents(StyleElement style, String contents) {
            style.setInnerText(contents);
        }

        private StyleElement createElement(String contents) {
            StyleElement style = Document.get().createStyleElement();
            style.setPropertyString("language", "text/css");
            this.setContents(style, contents);
            return style;
        }

        private HeadElement getHead() {
            if (this.head == null) {
                Element elt = Document.get().getElementsByTagName("head").getItem(0);
                assert (elt != null) : "The host HTML page does not have a <head> element which is required by StyleInjector";
                this.head = HeadElement.as(elt);
            }
            return this.head;
        }
    }

    public static class StyleInjectorImplIE
    extends StyleInjectorImpl {
        private static final int MAX_STYLE_SHEETS = 30;
        private static int[] styleSheetLengths = new int[30];

        private static native int getDocumentStyleCount();

        private static native StyleElement getDocumentStyleSheet(int var0);

        private static native int getDocumentStyleSheetLength(int var0);

        public native void appendContents(StyleElement var1, String var2);

        public StyleElement injectStyleSheet(String contents) {
            int numStyles = StyleInjectorImplIE.getDocumentStyleCount();
            if (numStyles < 30) {
                return this.createNewStyleSheet(contents);
            }
            int shortestLen = Integer.MAX_VALUE;
            int shortestIdx = -1;
            for (int i = 0; i < numStyles; ++i) {
                int len = styleSheetLengths[i];
                if (len == 0) {
                    len = StyleInjectorImplIE.styleSheetLengths[i] = StyleInjectorImplIE.getDocumentStyleSheetLength(i);
                }
                if (len > shortestLen) continue;
                shortestLen = len;
                shortestIdx = i;
            }
            int n = shortestIdx;
            styleSheetLengths[n] = styleSheetLengths[n] + contents.length();
            return this.appendToStyleSheet(shortestIdx, contents, true);
        }

        public StyleElement injectStyleSheetAtEnd(String contents) {
            int documentStyleCount = StyleInjectorImplIE.getDocumentStyleCount();
            if (documentStyleCount == 0) {
                return this.createNewStyleSheet(contents);
            }
            return this.appendToStyleSheet(documentStyleCount - 1, contents, true);
        }

        public StyleElement injectStyleSheetAtStart(String contents) {
            if (StyleInjectorImplIE.getDocumentStyleCount() == 0) {
                return this.createNewStyleSheet(contents);
            }
            return this.appendToStyleSheet(0, contents, false);
        }

        public native void prependContents(StyleElement var1, String var2);

        private StyleElement appendToStyleSheet(int idx, String contents, boolean append) {
            StyleElement style = StyleInjectorImplIE.getDocumentStyleSheet(idx);
            if (append) {
                this.appendContents(style, contents);
            } else {
                this.prependContents(style, contents);
            }
            return style;
        }

        private native StyleElement createElement();

        private StyleElement createNewStyleSheet(String contents) {
            StyleElement style = this.createElement();
            style.setCssText(contents);
            return style;
        }
    }
}

