/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.ByteValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.FloatValueCommand;
import com.google.gwt.rpc.client.ast.IntValueCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.ShortValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSerializationUtil {
    private static final Map<Class<?>, Accessor> ACCESSORS = new IdentityHashMap();
    private static final Unsafe theUnsafe;

    public static Accessor getAccessor(Class<?> clazz) {
        Accessor toReturn = ACCESSORS.get(clazz);
        if (toReturn == null) {
            toReturn = TypeAccessor.OBJECT;
        }
        return toReturn;
    }

    static <T> T allocateInstance(Class<T> clazz) throws InstantiationException {
        Object obj = theUnsafe.allocateInstance(clazz);
        return clazz.cast(obj);
    }

    private static long objectFieldOffset(Field f) {
        return theUnsafe.objectFieldOffset(f);
    }

    private CommandSerializationUtil() {
    }

    static {
        Exception ex = null;
        Unsafe localUnsafe = null;
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            localUnsafe = (Unsafe)f.get(null);
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            throw new RuntimeException("Unable to get Unsafe instance", ex);
        }
        theUnsafe = localUnsafe;
        for (TypeAccessor setter : TypeAccessor.values()) {
            ACCESSORS.put(setter.getTargetType(), setter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Accessor {
        public boolean canMakeValueCommand();

        public boolean canSet(Class<?> var1);

        public Object get(Object var1, Field var2);

        public Class<?> getTargetType();

        public ValueCommand makeValueCommand(Object var1);

        public Object readNext(SerializationStreamReader var1) throws SerializationException;

        public void set(Object var1, Field var2, Object var3);

        public void set(Object var1, int var2, Object var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeAccessor implements Accessor
    {
        BOOL{

            @Override
            public boolean canSet(Class<?> clazz) {
                return Boolean.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
            }

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getBoolean(instance, offset);
            }

            @Override
            public Object getDefaultValue() {
                return false;
            }

            @Override
            public Class<?> getTargetType() {
                return Boolean.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new BooleanValueCommand((Boolean)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readBoolean();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putBoolean(instance, offset, this.toBoolean(value));
            }

            private boolean toBoolean(Object value) {
                if (value instanceof Number) {
                    return ((Number)value).intValue() != 0;
                }
                if (value instanceof String) {
                    return Boolean.valueOf((String)value);
                }
                return Boolean.TRUE.equals(value);
            }
        }
        ,
        BYTE{

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getByte(instance, offset);
            }

            @Override
            public Class<?> getTargetType() {
                return Byte.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new ByteValueCommand((Byte)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readByte();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putByte(instance, offset, ((Number)value).byteValue());
            }
        }
        ,
        CHAR{

            @Override
            public Object get(Object instance, long offset) {
                return Character.valueOf(theUnsafe.getChar(instance, offset));
            }

            @Override
            public Class<?> getTargetType() {
                return Character.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new CharValueCommand((Character)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return Character.valueOf(reader.readChar());
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                char c = value instanceof Number ? (char)((Number)value).intValue() : ((Character)value).charValue();
                theUnsafe.putChar(instance, offset, c);
            }
        }
        ,
        DOUBLE{

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getDouble(instance, offset);
            }

            @Override
            public Class<?> getTargetType() {
                return Double.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new DoubleValueCommand((Double)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readDouble();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putDouble(instance, offset, ((Number)value).doubleValue());
            }
        }
        ,
        FLOAT{

            @Override
            public Object get(Object instance, long offset) {
                return Float.valueOf(theUnsafe.getFloat(instance, offset));
            }

            @Override
            public Class<?> getTargetType() {
                return Float.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new FloatValueCommand((Float)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return Float.valueOf(reader.readFloat());
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putFloat(instance, offset, ((Number)value).floatValue());
            }
        }
        ,
        INT{

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getInt(instance, offset);
            }

            @Override
            public Class<?> getTargetType() {
                return Integer.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new IntValueCommand(((Number)value).intValue());
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readInt();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putInt(instance, offset, ((Number)value).intValue());
            }
        }
        ,
        LONG{

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getLong(instance, offset);
            }

            @Override
            public Class<?> getTargetType() {
                return Long.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new LongValueCommand((Long)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readLong();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putLong(instance, offset, ((Number)value).longValue());
            }
        }
        ,
        OBJECT{

            @Override
            public boolean canMakeValueCommand() {
                return false;
            }

            @Override
            public boolean canSet(Class<?> clazz) {
                return Object.class.isAssignableFrom(clazz);
            }

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getObject(instance, offset);
            }

            @Override
            public Object getDefaultValue() {
                return null;
            }

            @Override
            public Class<?> getTargetType() {
                return Object.class;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                throw new RuntimeException("Cannot call makeValueCommand for Objects");
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readObject();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putObject(instance, offset, value);
            }
        }
        ,
        SHORT{

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getShort(instance, offset);
            }

            @Override
            public Class<?> getTargetType() {
                return Short.TYPE;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new ShortValueCommand((Short)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readShort();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putShort(instance, offset, ((Number)value).shortValue());
            }
        }
        ,
        STRING{

            @Override
            public boolean canSet(Class<?> clazz) {
                return true;
            }

            @Override
            public Object get(Object instance, long offset) {
                return theUnsafe.getObject(instance, offset);
            }

            @Override
            public Object getDefaultValue() {
                return null;
            }

            @Override
            public Class<?> getTargetType() {
                return String.class;
            }

            @Override
            public ValueCommand makeValueCommand(Object value) {
                return new StringValueCommand((String)value);
            }

            @Override
            public Object readNext(SerializationStreamReader reader) throws SerializationException {
                return reader.readObject();
            }

            @Override
            public void set(Object instance, long offset, Object value) {
                theUnsafe.putObject(instance, offset, value == null ? null : value.toString());
            }
        };

        private final Class<?> arrayType = Array.newInstance(this.getTargetType(), 0).getClass();
        private final long arrayBase = CommandSerializationUtil.access$100().arrayBaseOffset(this.arrayType);
        private final long arrayIndexScale = CommandSerializationUtil.access$100().arrayIndexScale(this.arrayType);

        @Override
        public boolean canMakeValueCommand() {
            return true;
        }

        @Override
        public boolean canSet(Class<?> clazz) {
            return Number.class.isAssignableFrom(clazz);
        }

        @Override
        public Object get(Object instance, Field f) {
            long offset = CommandSerializationUtil.objectFieldOffset(f);
            return this.get(instance, offset);
        }

        public abstract Object get(Object var1, long var2);

        public Object getDefaultValue() {
            return 0;
        }

        @Override
        public abstract Class<?> getTargetType();

        @Override
        public abstract ValueCommand makeValueCommand(Object var1);

        @Override
        public abstract Object readNext(SerializationStreamReader var1) throws SerializationException;

        @Override
        public void set(Object instance, Field f, Object value) {
            long offset = CommandSerializationUtil.objectFieldOffset(f);
            this.set(instance, offset, value == null ? this.getDefaultValue() : value);
        }

        @Override
        public void set(Object array, int index, Object value) {
            this.set(array, this.arrayBase + this.arrayIndexScale * (long)index, value);
        }

        public abstract void set(Object var1, long var2, Object var4);
    }
}

