/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.server.CastableTypeData;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.Pair;
import com.google.gwt.rpc.server.WebModePayloadSink;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebModeClientOracle
extends ClientOracle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, ClassData> classData = new HashMap<String, ClassData>();
    private final Set<String> idents = new HashSet<String>();
    private final Map<String, ClassData> seedNamesToClassData = new HashMap<String, ClassData>();
    private transient Map<Class<?>, Field[]> operableFieldMap = new IdentityHashMap();

    public static WebModeClientOracle load(InputStream stream) throws IOException {
        try {
            stream = new GZIPInputStream(stream);
            return WebModeClientOracle.readStreamAsObject(stream, WebModeClientOracle.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Should never reach this", e);
        }
    }

    static String jsniName(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (clazz.equals(Byte.TYPE)) {
                return "B";
            }
            if (clazz.equals(Character.TYPE)) {
                return "C";
            }
            if (clazz.equals(Short.TYPE)) {
                return "S";
            }
            if (clazz.equals(Integer.TYPE)) {
                return "I";
            }
            if (clazz.equals(Long.TYPE)) {
                return "J";
            }
            if (clazz.equals(Float.TYPE)) {
                return "F";
            }
            if (clazz.equals(Double.TYPE)) {
                return "D";
            }
            throw new RuntimeException("Unhandled primitive type " + clazz.getName());
        }
        if (clazz.isArray()) {
            return "[" + WebModeClientOracle.jsniName(clazz.getComponentType());
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T readStreamAsObject(InputStream inputStream, Class<T> type) throws ClassNotFoundException {
        T t;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            t = type.cast(objectInputStream.readObject());
        }
        catch (IOException e) {
            T t2 = null;
            return t2;
        }
        finally {
            try {
                objectInputStream.close();
            }
            catch (IOException e) {}
        }
        return t;
    }

    private static void writeObjectToStream(OutputStream stream, Object ... objects) throws IOException {
        ObjectOutputStream objectStream = new ObjectOutputStream(stream);
        for (Object object : objects) {
            objectStream.writeObject(object);
        }
        objectStream.flush();
    }

    protected WebModeClientOracle() {
    }

    @Override
    public CommandSink createCommandSink(OutputStream out) throws IOException {
        return new WebModePayloadSink(this, out);
    }

    @Override
    public String createUnusedIdent(String ident) {
        while (this.idents.contains(ident)) {
            ident = ident + "$";
        }
        return ident;
    }

    @Override
    public CastableTypeData getCastableTypeData(Class<?> clazz) {
        while (clazz != null) {
            CastableTypeData toReturn = this.getCastableTypeData(this.canonicalName(clazz));
            if (toReturn != null) {
                return toReturn;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Override
    public String getFieldId(Class<?> clazz, String fieldName) {
        while (clazz != null) {
            String className = clazz.getName();
            ClassData data = this.getClassData(className);
            if (data.fieldNamesToIdents.containsKey(fieldName)) {
                return data.fieldNamesToIdents.get(fieldName);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Override
    public String getFieldId(Enum<?> value) {
        return this.getFieldId(value.getDeclaringClass(), value.name());
    }

    @Override
    public String getFieldId(String className, String fieldName) {
        ClassData data = this.getClassData(className);
        return data.fieldNamesToIdents.get(fieldName);
    }

    @Override
    public Pair<Class<?>, String> getFieldName(Class<?> clazz, String fieldId) {
        while (clazz != null) {
            ClassData data = this.getClassData(clazz.getName());
            String fieldName = data.fieldIdentsToNames.get(fieldId);
            if (fieldName == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return new Pair(clazz, fieldName);
        }
        return null;
    }

    @Override
    public String getMethodId(Class<?> clazz, String methodName, Class<?> ... args) {
        while (clazz != null) {
            String toReturn = this.getMethodId(clazz.getName(), methodName, args);
            if (toReturn != null) {
                return toReturn;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @Override
    public String getMethodId(String className, String methodName, String ... jsniArgTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append("(");
        for (String jsniArg : jsniArgTypes) {
            sb.append(jsniArg);
        }
        sb.append(")");
        ClassData data = this.getClassData(className);
        String jsIdent = data.methodJsniNamesToIdents.get(sb.toString());
        return jsIdent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field[] getOperableFields(Class<?> clazz) {
        Field[] toReturn;
        Map<Class<?>, Field[]> map = this.operableFieldMap;
        synchronized (map) {
            toReturn = this.operableFieldMap.get(clazz);
        }
        if (toReturn != null) {
            return toReturn;
        }
        ClassData data = this.getClassData(clazz.getName());
        toReturn = new Field[data.serializableFields.size()];
        for (int i = 0; i < toReturn.length; ++i) {
            String fieldName = data.serializableFields.get(i);
            try {
                toReturn[i] = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (SecurityException e) {
                throw new IncompatibleRemoteServiceException("Cannot access field " + fieldName, e);
            }
            catch (NoSuchFieldException e) {
                throw new IncompatibleRemoteServiceException("No field " + fieldName, e);
            }
        }
        Map<Class<?>, Field[]> map2 = this.operableFieldMap;
        synchronized (map2) {
            this.operableFieldMap.put(clazz, toReturn);
        }
        return toReturn;
    }

    @Override
    public int getQueryId(Class<?> clazz) {
        while (clazz != null) {
            int toReturn = this.getQueryId(this.canonicalName(clazz));
            if (toReturn != 0) {
                return toReturn;
            }
            clazz = clazz.getSuperclass();
        }
        return 0;
    }

    @Override
    public String getSeedName(Class<?> clazz) {
        ClassData data = this.getClassData(clazz.getName());
        return data.seedName;
    }

    @Override
    public String getTypeName(String seedName) {
        ClassData data;
        if (seedName.startsWith("Class$")) {
            seedName = seedName.substring(6);
        }
        return (data = this.seedNamesToClassData.get(seedName)) == null ? null : data.typeName;
    }

    @Override
    public boolean isScript() {
        return true;
    }

    public void store(OutputStream stream) throws IOException {
        stream = new GZIPOutputStream(stream);
        WebModeClientOracle.writeObjectToStream(stream, this);
        stream.close();
    }

    private String canonicalName(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> leafType = clazz;
            while ((leafType = leafType.getComponentType()).isArray()) {
            }
            Class<?> enclosing = leafType.getEnclosingClass();
            if (enclosing != null) {
                return this.canonicalName(enclosing) + "$" + clazz.getSimpleName();
            }
            if (leafType.getPackage() == null) {
                return clazz.getSimpleName();
            }
            return leafType.getPackage().getName() + "." + clazz.getSimpleName();
        }
        return clazz.getName();
    }

    private CastableTypeData getCastableTypeData(String className) {
        ClassData data = this.getClassData(className);
        return data.castableTypeData;
    }

    private ClassData getClassData(String className) {
        ClassData toReturn = this.classData.get(className);
        if (toReturn == null) {
            toReturn = new ClassData();
            this.classData.put(className, toReturn);
        }
        return toReturn;
    }

    private String getMethodId(String className, String methodName, Class<?> ... args) {
        String[] jsniArgTypes = new String[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            jsniArgTypes[i] = WebModeClientOracle.jsniName(args[i]);
        }
        return this.getMethodId(className, methodName, jsniArgTypes);
    }

    private int getQueryId(String className) {
        ClassData data = this.getClassData(className);
        return data.queryId;
    }

    private Object readResolve() {
        this.operableFieldMap = new HashMap();
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private WebModeClientOracle oracle = new WebModeClientOracle();

        public void add(String jsIdent, String jsniIdent, String className, String memberName, int queryId, CastableTypeData castableTypeData) {
            this.oracle.idents.add(jsIdent);
            ClassData data = this.oracle.getClassData(className);
            if (data.castableTypeData == null) {
                data.queryId = queryId;
                data.castableTypeData = castableTypeData;
            }
            if (jsniIdent == null || jsniIdent.length() == 0) {
                data.typeName = className;
                data.seedName = jsIdent;
                this.oracle.seedNamesToClassData.put(jsIdent, data);
            } else if (jsniIdent.contains("(")) {
                jsniIdent = jsniIdent.substring(jsniIdent.indexOf("::") + 2, jsniIdent.indexOf(41) + 1);
                data.methodJsniNamesToIdents.put(jsniIdent, jsIdent);
            } else {
                data.fieldIdentsToNames.put(jsIdent, memberName);
                data.fieldNamesToIdents.put(memberName, jsIdent);
            }
        }

        public WebModeClientOracle getOracle() {
            WebModeClientOracle toReturn = this.oracle;
            this.oracle = null;
            return toReturn;
        }

        public void setSerializableFields(String className, List<String> fieldNames) {
            ClassData data = this.oracle.getClassData(className);
            assert (data.serializableFields == null || fieldNames.containsAll(data.serializableFields));
            if (fieldNames.size() == 1) {
                data.serializableFields = Collections.singletonList(fieldNames.get(0));
            } else {
                data.serializableFields = new ArrayList<String>(fieldNames);
                Collections.sort(data.serializableFields);
            }
        }
    }

    private static class ClassData
    implements Serializable {
        private static final long serialVersionUID = 5L;
        public CastableTypeData castableTypeData;
        public final Map<String, String> fieldIdentsToNames = new HashMap<String, String>();
        public final Map<String, String> fieldNamesToIdents = new HashMap<String, String>();
        public final Map<String, String> methodJsniNamesToIdents = new HashMap<String, String>();
        public int queryId;
        public String seedName;
        public List<String> serializableFields = Collections.emptyList();
        public String typeName;

        private ClassData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Triple<A, B, C>
    extends Pair<A, B> {
        private final C[] c;

        public Triple(A a, B b, C ... c) {
            super(a, b);
            this.c = c;
        }

        public C[] getC() {
            return this.c;
        }
    }
}

