/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.HasDataPresenter;
import com.google.gwt.user.client.Event;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellList<T>
extends AbstractHasData<T> {
    private static final int DEFAULT_PAGE_SIZE = 25;
    private static Resources DEFAULT_RESOURCES;
    private static final Template TEMPLATE;
    private final Cell<T> cell;
    private boolean cellIsEditing;
    private final Element childContainer;
    private SafeHtml emptyListMessage = SafeHtmlUtils.fromSafeConstant("");
    private final Element emptyMessageElem;
    private final Style style;
    private ValueUpdater<T> valueUpdater;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public CellList(Cell<T> cell) {
        this(cell, CellList.getDefaultResources(), null);
    }

    public CellList(Cell<T> cell, Resources resources) {
        this(cell, resources, null);
    }

    public CellList(Cell<T> cell, ProvidesKey<T> keyProvider) {
        this(cell, CellList.getDefaultResources(), keyProvider);
    }

    public CellList(Cell<T> cell, Resources resources, ProvidesKey<T> keyProvider) {
        super(Document.get().createDivElement(), 25, keyProvider);
        this.cell = cell;
        this.style = resources.cellListStyle();
        this.style.ensureInjected();
        String widgetStyle = this.style.cellListWidget();
        if (widgetStyle != null) {
            this.addStyleName(widgetStyle);
        }
        this.childContainer = Document.get().createDivElement();
        this.emptyMessageElem = Document.get().createDivElement();
        this.showOrHide(this.emptyMessageElem, false);
        DivElement outerDiv = (DivElement)this.getElement().cast();
        outerDiv.appendChild(this.childContainer);
        outerDiv.appendChild(this.emptyMessageElem);
        CellBasedWidgetImpl.get().sinkEvents(this, cell.getConsumedEvents());
    }

    public SafeHtml getEmptyListMessage() {
        return this.emptyListMessage;
    }

    public Element getRowElement(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        if (this.childContainer.getChildCount() > indexOnPage) {
            return (Element)this.childContainer.getChild(indexOnPage).cast();
        }
        return null;
    }

    public void setEmptyListMessage(SafeHtml html) {
        this.emptyListMessage = html;
        this.emptyMessageElem.setInnerHTML(html.asString());
    }

    public void setValueUpdater(ValueUpdater<T> valueUpdater) {
        this.valueUpdater = valueUpdater;
    }

    @Override
    protected boolean dependsOnSelection() {
        return this.cell.dependsOnSelection();
    }

    protected void doSelection(Event event, T value, int indexOnPage) {
        SelectionModel<T> selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.setSelected(value, true);
        }
    }

    protected void fireEventToCell(Event event, Element parent, T value) {
        Set<String> consumedEvents = this.cell.getConsumedEvents();
        if (consumedEvents != null && consumedEvents.contains(event.getType())) {
            Object key = this.getValueKey(value);
            boolean cellWasEditing = this.cell.isEditing(parent, value, key);
            this.cell.onBrowserEvent(parent, value, key, event, this.valueUpdater);
            this.cellIsEditing = this.cell.isEditing(parent, value, key);
            if (cellWasEditing && !this.cellIsEditing) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        CellList.this.setFocus(true);
                    }
                });
            }
        }
    }

    protected Cell<T> getCell() {
        return this.cell;
    }

    protected Element getCellParent(Element item) {
        return item;
    }

    @Override
    protected Element getChildContainer() {
        return this.childContainer;
    }

    @Override
    protected Element getKeyboardSelectedElement() {
        int rowIndex = this.getKeyboardSelectedRow();
        return this.isRowWithinBounds(rowIndex) ? this.getRowElement(rowIndex) : null;
    }

    @Override
    protected boolean isKeyboardNavigationSuppressed() {
        return this.cellIsEditing;
    }

    @Override
    protected void onBlur() {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            elem.removeClassName(this.style.cellListKeyboardSelectedItem());
        }
    }

    @Override
    protected void onBrowserEvent2(Event event) {
        Element target;
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return;
        }
        String idxString = "";
        for (target = (Element)event.getEventTarget().cast(); target != null && (idxString = target.getAttribute("__idx")).length() == 0; target = target.getParentElement()) {
        }
        if (idxString.length() > 0) {
            String eventType = event.getType();
            boolean isMouseDown = "mousedown".equals(eventType);
            int idx = Integer.parseInt(idxString);
            int indexOnPage = idx - this.getPageStart();
            if (!this.isRowWithinBounds(indexOnPage)) {
                return;
            }
            Element cellParent = this.getCellParent(target);
            Object value = this.getDisplayedItem(indexOnPage);
            if (isMouseDown && !this.cell.handlesSelection()) {
                this.doSelection(event, value, indexOnPage);
            }
            if ("focus".equals(eventType) || isMouseDown) {
                this.isFocused = true;
                this.doKeyboardSelection(event, value, indexOnPage);
            }
            this.fireEventToCell(event, cellParent, value);
        }
    }

    @Override
    protected void onFocus() {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            elem.addClassName(this.style.cellListKeyboardSelectedItem());
        }
    }

    @Override
    protected void renderRowValues(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
        String keyboardSelectedItem = " " + this.style.cellListKeyboardSelectedItem();
        String selectedItem = " " + this.style.cellListSelectedItem();
        String evenItem = this.style.cellListEvenItem();
        String oddItem = this.style.cellListOddItem();
        int keyboardSelectedRow = this.getKeyboardSelectedRow() + this.getPageStart();
        int length = values.size();
        int end = start + length;
        for (int i = start; i < end; ++i) {
            T value = values.get(i - start);
            boolean isSelected = selectionModel == null ? false : selectionModel.isSelected(value);
            StringBuilder classesBuilder = new StringBuilder();
            classesBuilder.append(i % 2 == 0 ? evenItem : oddItem);
            if (isSelected) {
                classesBuilder.append(selectedItem);
            }
            SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
            this.cell.render(value, null, cellBuilder);
            if (i == keyboardSelectedRow) {
                char accessKey;
                if (this.isFocused) {
                    classesBuilder.append(keyboardSelectedItem);
                }
                if ((accessKey = this.getAccessKey()) != '\u0000') {
                    sb.append(TEMPLATE.divFocusableWithKey(i, classesBuilder.toString(), this.getTabIndex(), accessKey, cellBuilder.toSafeHtml()));
                    continue;
                }
                sb.append(TEMPLATE.divFocusable(i, classesBuilder.toString(), this.getTabIndex(), cellBuilder.toSafeHtml()));
                continue;
            }
            sb.append(TEMPLATE.div(i, classesBuilder.toString(), cellBuilder.toSafeHtml()));
        }
    }

    @Override
    protected boolean resetFocusOnCell() {
        int row = this.getKeyboardSelectedRow();
        if (this.isRowWithinBounds(row)) {
            Element rowElem = this.getKeyboardSelectedElement();
            Element cellParent = this.getCellParent(rowElem);
            Object value = this.getDisplayedItem(row);
            Object key = this.getValueKey(value);
            return this.cell.resetFocus(cellParent, value, key);
        }
        return false;
    }

    @Override
    protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
        if (!this.isRowWithinBounds(index)) {
            return;
        }
        Element elem = this.getRowElement(index);
        if (!selected || this.isFocused || stealFocus) {
            CellList.setStyleName(elem, this.style.cellListKeyboardSelectedItem(), selected);
        }
        this.setFocusable(elem, selected);
        if (selected && stealFocus) {
            elem.focus();
            this.onFocus();
        }
    }

    @Override
    protected void setSelected(Element elem, boolean selected) {
        CellList.setStyleName(elem, this.style.cellListSelectedItem(), selected);
    }

    void doKeyboardSelection(Event event, T value, int indexOnPage) {
        if (this.getPresenter().getKeyboardSelectedRow() != indexOnPage) {
            this.getPresenter().setKeyboardSelectedRow(indexOnPage, false);
        }
    }

    @Override
    void setLoadingState(HasDataPresenter.LoadingState state) {
        this.showOrHide(this.emptyMessageElem, state == HasDataPresenter.LoadingState.EMPTY);
    }

    private void showOrHide(Element element, boolean show) {
        if (show) {
            element.getStyle().clearDisplay();
        } else {
            element.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    static {
        TEMPLATE = (Template)GWT.create(Template.class);
    }

    public static interface Resources
    extends ClientBundle {
        @ImageResource.ImageOptions(repeatStyle=ImageResource.RepeatStyle.Horizontal, flipRtl=true)
        public ImageResource cellListSelectedBackground();

        @ClientBundle.Source(value={"com/google/gwt/user/cellview/client/CellList.css"})
        public Style cellListStyle();
    }

    @CssResource.ImportedWithPrefix(value="gwt-CellList")
    public static interface Style
    extends CssResource {
        public static final String DEFAULT_CSS = "com/google/gwt/user/cellview/client/CellList.css";

        public String cellListEvenItem();

        public String cellListKeyboardSelectedItem();

        public String cellListOddItem();

        public String cellListSelectedItem();

        public String cellListWidget();
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div onclick=\"\" __idx=\"{0}\" class=\"{1}\" style=\"outline:none;\" >{2}</div>")
        public SafeHtml div(int var1, String var2, SafeHtml var3);

        @SafeHtmlTemplates.Template(value="<div onclick=\"\" __idx=\"{0}\" class=\"{1}\" style=\"outline:none;\" tabindex=\"{2}\">{3}</div>")
        public SafeHtml divFocusable(int var1, String var2, int var3, SafeHtml var4);

        @SafeHtmlTemplates.Template(value="<div onclick=\"\" __idx=\"{0}\" class=\"{1}\" style=\"outline:none;\" tabindex=\"{2}\" accesskey=\"{3}\">{4}</div>")
        public SafeHtml divFocusableWithKey(int var1, String var2, int var3, char var4, SafeHtml var5);
    }
}

