/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.safehtml.client.HasSafeHtml;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeItem
extends UIObject
implements HasHTML,
HasSafeHtml {
    private static final double CHILD_MARGIN = 16.0;
    static final int IMAGE_PAD = 7;
    private static final int ANIMATION_DURATION = 200;
    private static final int ANIMATION_DURATION_PER_ITEM = 75;
    private static TreeItemAnimation itemAnimation = new TreeItemAnimation();
    private static Element BASE_INTERNAL_ELEM;
    private static Element BASE_BARE_ELEM;
    private static TreeItemImpl impl;
    private ArrayList<TreeItem> children;
    private Element contentElem;
    private Element childSpanElem;
    private Element imageHolder;
    private boolean isRoot;
    private boolean open;
    private TreeItem parent;
    private boolean selected;
    private Object userObject;
    private Tree tree;
    private Widget widget;

    public TreeItem() {
        this(false);
    }

    public TreeItem(String html) {
        this();
        this.setHTML(html);
    }

    public TreeItem(SafeHtml html) {
        this(html.asString());
    }

    public TreeItem(Widget widget) {
        this();
        this.setWidget(widget);
    }

    TreeItem(boolean isRoot) {
        this.isRoot = isRoot;
        Element elem = DOM.clone(BASE_BARE_ELEM, true);
        this.setElement(elem);
        this.contentElem = DOM.getFirstChild(elem);
        DOM.setElementAttribute(this.contentElem, "id", DOM.createUniqueId());
        if (isRoot) {
            this.initChildren();
        }
    }

    public TreeItem addItem(String itemText) {
        TreeItem ret = new TreeItem(itemText);
        this.addItem(ret);
        return ret;
    }

    public TreeItem addItem(SafeHtml itemHtml) {
        TreeItem ret = new TreeItem(itemHtml);
        this.addItem(ret);
        return ret;
    }

    public void addItem(TreeItem item) {
        this.maybeRemoveItemFromParent(item);
        this.insertItem(this.getChildCount(), item);
    }

    public TreeItem addItem(Widget widget) {
        TreeItem ret = new TreeItem(widget);
        this.addItem(ret);
        return ret;
    }

    public TreeItem getChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            return null;
        }
        return this.children.get(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getChildIndex(TreeItem child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    @Override
    public String getHTML() {
        return DOM.getInnerHTML(this.contentElem);
    }

    public TreeItem getParentItem() {
        return this.parent;
    }

    public boolean getState() {
        return this.open;
    }

    @Override
    public String getText() {
        return DOM.getInnerText(this.contentElem);
    }

    public final Tree getTree() {
        return this.tree;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public TreeItem insertItem(int beforeIndex, String itemText) throws IndexOutOfBoundsException {
        TreeItem ret = new TreeItem(itemText);
        this.insertItem(beforeIndex, ret);
        return ret;
    }

    public TreeItem insertItem(int beforeIndex, SafeHtml itemHtml) throws IndexOutOfBoundsException {
        TreeItem ret = new TreeItem(itemHtml);
        this.insertItem(beforeIndex, ret);
        return ret;
    }

    public void insertItem(int beforeIndex, TreeItem item) throws IndexOutOfBoundsException {
        Element childContainer;
        double margin;
        this.maybeRemoveItemFromParent(item);
        int childCount = this.getChildCount();
        if (beforeIndex < 0 || beforeIndex > childCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.children == null) {
            this.initChildren();
        }
        double d = margin = this.isRoot ? 0.0 : 16.0;
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            item.getElement().getStyle().setMarginRight(margin, Style.Unit.PX);
        } else {
            item.getElement().getStyle().setMarginLeft(margin, Style.Unit.PX);
        }
        Element element = childContainer = this.isRoot ? this.tree.getElement() : this.childSpanElem;
        if (beforeIndex == childCount) {
            childContainer.appendChild(item.getElement());
        } else {
            Element beforeElem = this.getChild(beforeIndex).getElement();
            childContainer.insertBefore(item.getElement(), beforeElem);
        }
        item.setParentItem(this.isRoot ? null : this);
        this.children.add(beforeIndex, item);
        item.setTree(this.tree);
        if (!this.isRoot && this.children.size() == 1) {
            this.updateState(false, false);
        }
    }

    public TreeItem insertItem(int beforeIndex, Widget widget) throws IndexOutOfBoundsException {
        TreeItem ret = new TreeItem(widget);
        this.insertItem(beforeIndex, ret);
        return ret;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeItem(this);
        } else if (this.tree != null) {
            this.tree.removeItem(this);
        }
    }

    public void removeItem(TreeItem item) {
        if (this.children == null || !this.children.contains(item)) {
            return;
        }
        Tree oldTree = this.tree;
        item.setTree(null);
        if (this.isRoot) {
            oldTree.getElement().removeChild(item.getElement());
        } else {
            this.childSpanElem.removeChild(item.getElement());
        }
        item.setParentItem(null);
        this.children.remove(item);
        if (!this.isRoot && this.children.size() == 0) {
            this.updateState(false, false);
        }
    }

    public void removeItems() {
        while (this.getChildCount() > 0) {
            this.removeItem(this.getChild(0));
        }
    }

    @Override
    public void setHTML(String html) {
        this.setWidget(null);
        DOM.setInnerHTML(this.contentElem, html);
    }

    @Override
    public void setHTML(SafeHtml html) {
        this.setHTML(html.asString());
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        TreeItem.setStyleName(this.getContentElem(), "gwt-TreeItem-selected", selected);
    }

    public void setState(boolean open) {
        this.setState(open, true);
    }

    public void setState(boolean open, boolean fireEvents) {
        if (open && this.getChildCount() == 0) {
            return;
        }
        if (this.open != open) {
            this.open = open;
            this.updateState(true, true);
            if (fireEvents && this.tree != null) {
                this.tree.fireStateChanged(this, open);
            }
        }
    }

    @Override
    public void setText(String text) {
        this.setWidget(null);
        DOM.setInnerText(this.contentElem, text);
    }

    public void setUserObject(Object userObj) {
        this.userObject = userObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWidget(Widget newWidget) {
        if (newWidget != null) {
            newWidget.removeFromParent();
        }
        if (this.widget != null) {
            try {
                if (this.tree != null) {
                    this.tree.orphan(this.widget);
                }
            }
            finally {
                this.contentElem.removeChild(this.widget.getElement());
                this.widget = null;
            }
        }
        DOM.setInnerHTML(this.contentElem, "");
        this.widget = newWidget;
        if (newWidget != null) {
            DOM.appendChild(this.contentElem, newWidget.getElement());
            if (this.tree != null) {
                this.tree.adopt(this.widget, this);
            }
            if (Tree.shouldTreeDelegateFocusToElement(this.widget.getElement())) {
                DOM.setElementAttribute(this.widget.getElement(), "tabIndex", "-1");
            }
        }
    }

    protected Focusable getFocusable() {
        Widget w;
        Focusable focus = this.getFocusableWidget();
        if (focus == null && (w = this.getWidget()) instanceof Focusable) {
            focus = (Focusable)((Object)w);
        }
        return focus;
    }

    @Deprecated
    protected HasFocus getFocusableWidget() {
        Widget w = this.getWidget();
        if (w instanceof HasFocus) {
            return (HasFocus)((Object)w);
        }
        return null;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        TreeItem.ensureDebugId(this.contentElem, baseID, "content");
        if (this.imageHolder != null) {
            TreeItem.ensureDebugId(this.imageHolder, baseID, "image");
        }
        if (this.children != null) {
            int childCount = 0;
            for (TreeItem child : this.children) {
                child.ensureDebugId(baseID + "-child" + childCount);
                ++childCount;
            }
        }
    }

    void addTreeItems(List<TreeItem> accum) {
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            TreeItem item = this.children.get(i);
            accum.add(item);
            item.addTreeItems(accum);
        }
    }

    ArrayList<TreeItem> getChildren() {
        return this.children;
    }

    Element getContentElem() {
        return this.contentElem;
    }

    Element getImageElement() {
        return DOM.getFirstChild(this.getImageHolderElement());
    }

    Element getImageHolderElement() {
        if (!this.isFullNode()) {
            this.convertToFullNode();
        }
        return this.imageHolder;
    }

    void initChildren() {
        this.convertToFullNode();
        this.childSpanElem = DOM.createDiv();
        DOM.appendChild(this.getElement(), this.childSpanElem);
        DOM.setStyleAttribute(this.childSpanElem, "whiteSpace", "nowrap");
        this.children = new ArrayList();
    }

    boolean isFullNode() {
        return this.imageHolder != null;
    }

    void maybeRemoveItemFromParent(TreeItem item) {
        if (item.getParentItem() != null || item.getTree() != null) {
            item.remove();
        }
    }

    void setParentItem(TreeItem parent) {
        this.parent = parent;
    }

    void setTree(Tree newTree) {
        if (this.tree == newTree) {
            return;
        }
        if (this.tree != null) {
            if (this.tree.getSelectedItem() == this) {
                this.tree.setSelectedItem(null);
            }
            if (this.widget != null) {
                this.tree.orphan(this.widget);
            }
        }
        this.tree = newTree;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.children.get(i).setTree(newTree);
        }
        this.updateState(false, true);
        if (newTree != null && this.widget != null) {
            newTree.adopt(this.widget, this);
        }
    }

    void updateState(boolean animate, boolean updateTreeSelection) {
        if (this.tree == null || !this.tree.isAttached()) {
            return;
        }
        if (this.getChildCount() == 0) {
            if (this.childSpanElem != null) {
                UIObject.setVisible(this.childSpanElem, false);
            }
            this.tree.showLeafImage(this);
            return;
        }
        if (animate && this.tree != null && this.tree.isAttached()) {
            itemAnimation.setItemState(this, this.tree.isAnimationEnabled());
        } else {
            itemAnimation.setItemState(this, false);
        }
        if (this.open) {
            this.tree.showOpenImage(this);
        } else {
            this.tree.showClosedImage(this);
        }
        if (updateTreeSelection) {
            this.tree.maybeUpdateSelection(this, this.open);
        }
    }

    void updateStateRecursive() {
        this.updateStateRecursiveHelper();
        this.tree.maybeUpdateSelection(this, this.open);
    }

    private void convertToFullNode() {
        impl.convertToFullNode(this);
    }

    private void updateStateRecursiveHelper() {
        this.updateState(false, false);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.children.get(i).updateStateRecursiveHelper();
        }
    }

    static {
        impl = (TreeItemImpl)GWT.create(TreeItemImpl.class);
    }

    private static class TreeItemAnimation
    extends Animation {
        private TreeItem curItem = null;
        private boolean opening = true;
        private int scrollHeight = 0;

        private TreeItemAnimation() {
        }

        public void setItemState(TreeItem item, boolean animate) {
            this.cancel();
            if (animate) {
                this.curItem = item;
                this.opening = item.open;
                this.run(Math.min(200, 75 * this.curItem.getChildCount()));
            } else {
                UIObject.setVisible(item.childSpanElem, item.open);
            }
        }

        protected void onComplete() {
            if (this.curItem != null) {
                if (this.opening) {
                    UIObject.setVisible(this.curItem.childSpanElem, true);
                    this.onUpdate(1.0);
                    DOM.setStyleAttribute(this.curItem.childSpanElem, "height", "auto");
                } else {
                    UIObject.setVisible(this.curItem.childSpanElem, false);
                }
                DOM.setStyleAttribute(this.curItem.childSpanElem, "overflow", "visible");
                DOM.setStyleAttribute(this.curItem.childSpanElem, "width", "auto");
                this.curItem = null;
            }
        }

        protected void onStart() {
            this.scrollHeight = 0;
            if (!this.opening) {
                this.scrollHeight = this.curItem.childSpanElem.getScrollHeight();
            }
            DOM.setStyleAttribute(this.curItem.childSpanElem, "overflow", "hidden");
            super.onStart();
            if (this.opening) {
                UIObject.setVisible(this.curItem.childSpanElem, true);
                this.scrollHeight = this.curItem.childSpanElem.getScrollHeight();
            }
        }

        protected void onUpdate(double progress) {
            int height = (int)(progress * (double)this.scrollHeight);
            if (!this.opening) {
                height = this.scrollHeight - height;
            }
            height = Math.max(height, 1);
            DOM.setStyleAttribute(this.curItem.childSpanElem, "height", height + "px");
            int scrollWidth = DOM.getElementPropertyInt(this.curItem.childSpanElem, "scrollWidth");
            DOM.setStyleAttribute(this.curItem.childSpanElem, "width", scrollWidth + "px");
        }
    }

    public static class TreeItemImpl {
        public TreeItemImpl() {
            this.initializeClonableElements();
        }

        void convertToFullNode(TreeItem item) {
            if (item.imageHolder == null) {
                Element itemTable = DOM.clone(BASE_INTERNAL_ELEM, true);
                DOM.appendChild(item.getElement(), itemTable);
                Element tr = DOM.getFirstChild(DOM.getFirstChild(itemTable));
                Element tdImg = DOM.getFirstChild(tr);
                Element tdContent = DOM.getNextSibling(tdImg);
                DOM.setStyleAttribute(item.getElement(), "padding", "0px");
                DOM.appendChild(tdContent, item.contentElem);
                item.imageHolder = tdImg;
            }
        }

        void initializeClonableElements() {
            if (GWT.isClient()) {
                BASE_INTERNAL_ELEM = DOM.createTable();
                Element contentElem = DOM.createDiv();
                Element tbody = DOM.createTBody();
                Element tr = DOM.createTR();
                Element tdImg = DOM.createTD();
                Element tdContent = DOM.createTD();
                DOM.appendChild(BASE_INTERNAL_ELEM, tbody);
                DOM.appendChild(tbody, tr);
                DOM.appendChild(tr, tdImg);
                DOM.appendChild(tr, tdContent);
                DOM.setStyleAttribute(tdImg, "verticalAlign", "middle");
                DOM.setStyleAttribute(tdContent, "verticalAlign", "middle");
                DOM.appendChild(tdContent, contentElem);
                DOM.setStyleAttribute(contentElem, "display", "inline");
                UIObject.setStyleName(contentElem, "gwt-TreeItem");
                DOM.setStyleAttribute(BASE_INTERNAL_ELEM, "whiteSpace", "nowrap");
                BASE_BARE_ELEM = DOM.createDiv();
                DOM.setStyleAttribute(BASE_BARE_ELEM, "padding", "3px");
                DOM.appendChild(BASE_BARE_ELEM, contentElem);
                Accessibility.setRole(contentElem, "treeitem");
            }
        }
    }

    public static class TreeItemImplIE6
    extends TreeItemImpl {
        void convertToFullNode(TreeItem item) {
            super.convertToFullNode(item);
            DOM.setStyleAttribute(item.getElement(), "marginBottom", "0px");
        }
    }
}

