/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public abstract class UIObject {
    private static JavaScriptObject numberRegex;
    public static final String DEBUG_ID_PREFIX = "gwt-debug-";
    static final String MISSING_ELEMENT_ERROR = "This UIObject's element is not set; you may be missing a call to either Composite.initWidget() or UIObject.setElement()";
    static final String SETELEMENT_TWICE_ERROR = "Element may only be set once";
    private static DebugIdImpl debugIdImpl;
    private static final String EMPTY_STYLENAME_MSG = "Style names cannot be empty";
    private static final String NULL_HANDLE_MSG = "Null widget handle. If you are creating a composite, ensure that initWidget() has been called.";
    private com.google.gwt.dom.client.Element element;

    public static void ensureDebugId(com.google.gwt.dom.client.Element elem, String id) {
        UIObject.ensureDebugId(elem, "", id);
    }

    public static native boolean isVisible(com.google.gwt.dom.client.Element var0);

    public static native void setVisible(com.google.gwt.dom.client.Element var0, boolean var1);

    protected static void ensureDebugId(com.google.gwt.dom.client.Element elem, String baseID, String id) {
        debugIdImpl.ensureDebugId(elem, baseID, id);
    }

    protected static String getStyleName(com.google.gwt.dom.client.Element elem) {
        return DOM.getElementProperty((Element)elem.cast(), "className");
    }

    protected static String getStylePrimaryName(com.google.gwt.dom.client.Element elem) {
        String fullClassName = UIObject.getStyleName(elem);
        int spaceIdx = fullClassName.indexOf(32);
        if (spaceIdx >= 0) {
            return fullClassName.substring(0, spaceIdx);
        }
        return fullClassName;
    }

    protected static void setStyleName(com.google.gwt.dom.client.Element elem, String styleName) {
        DOM.setElementProperty((Element)elem.cast(), "className", styleName);
    }

    protected static void setStyleName(com.google.gwt.dom.client.Element elem, String style, boolean add) {
        if (elem == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        if ((style = style.trim()).length() == 0) {
            throw new IllegalArgumentException(EMPTY_STYLENAME_MSG);
        }
        if (add) {
            elem.addClassName(style);
        } else {
            elem.removeClassName(style);
        }
    }

    protected static void setStylePrimaryName(com.google.gwt.dom.client.Element elem, String style) {
        if (elem == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        if ((style = style.trim()).length() == 0) {
            throw new IllegalArgumentException(EMPTY_STYLENAME_MSG);
        }
        UIObject.updatePrimaryAndDependentStyleNames(elem, style);
    }

    private static native void updatePrimaryAndDependentStyleNames(com.google.gwt.dom.client.Element var0, String var1);

    public void addStyleDependentName(String styleSuffix) {
        this.setStyleDependentName(styleSuffix, true);
    }

    public void addStyleName(String style) {
        this.setStyleName(style, true);
    }

    public final void ensureDebugId(String id) {
        debugIdImpl.ensureDebugId(this, id);
    }

    public int getAbsoluteLeft() {
        return DOM.getAbsoluteLeft(this.getElement());
    }

    public int getAbsoluteTop() {
        return DOM.getAbsoluteTop(this.getElement());
    }

    public Element getElement() {
        assert (this.element != null) : "This UIObject's element is not set; you may be missing a call to either Composite.initWidget() or UIObject.setElement()";
        return (Element)this.element;
    }

    public int getOffsetHeight() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetHeight");
    }

    public int getOffsetWidth() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetWidth");
    }

    public String getStyleName() {
        return UIObject.getStyleName(this.getStyleElement());
    }

    public String getStylePrimaryName() {
        return UIObject.getStylePrimaryName(this.getStyleElement());
    }

    public String getTitle() {
        return DOM.getElementProperty(this.getElement(), "title");
    }

    public boolean isVisible() {
        return UIObject.isVisible(this.getElement());
    }

    public void removeStyleDependentName(String styleSuffix) {
        this.setStyleDependentName(styleSuffix, false);
    }

    public void removeStyleName(String style) {
        this.setStyleName(style, false);
    }

    public void setHeight(String height) {
        assert (this.extractLengthValue(height.trim().toLowerCase()) >= 0.0) : "CSS heights should not be negative";
        DOM.setStyleAttribute(this.getElement(), "height", height);
    }

    public void setPixelSize(int width, int height) {
        if (width >= 0) {
            this.setWidth(width + "px");
        }
        if (height >= 0) {
            this.setHeight(height + "px");
        }
    }

    public void setSize(String width, String height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setStyleDependentName(String styleSuffix, boolean add) {
        this.setStyleName(this.getStylePrimaryName() + '-' + styleSuffix, add);
    }

    public void setStyleName(String style, boolean add) {
        UIObject.setStyleName(this.getStyleElement(), style, add);
    }

    public void setStyleName(String style) {
        UIObject.setStyleName(this.getStyleElement(), style);
    }

    public void setStylePrimaryName(String style) {
        UIObject.setStylePrimaryName(this.getStyleElement(), style);
    }

    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            DOM.removeElementAttribute(this.getElement(), "title");
        } else {
            DOM.setElementAttribute(this.getElement(), "title", title);
        }
    }

    public void setVisible(boolean visible) {
        UIObject.setVisible(this.getElement(), visible);
    }

    public void setWidth(String width) {
        assert (this.extractLengthValue(width.trim().toLowerCase()) >= 0.0) : "CSS widths should not be negative";
        DOM.setStyleAttribute(this.getElement(), "width", width);
    }

    public void sinkEvents(int eventBitsToAdd) {
        DOM.sinkEvents(this.getElement(), eventBitsToAdd | DOM.getEventsSunk(this.getElement()));
    }

    public String toString() {
        if (this.element == null) {
            return "(null handle)";
        }
        return DOM.toString(this.getElement());
    }

    public void unsinkEvents(int eventBitsToRemove) {
        DOM.sinkEvents(this.getElement(), DOM.getEventsSunk(this.getElement()) & ~eventBitsToRemove);
    }

    protected Element getStyleElement() {
        return this.getElement();
    }

    protected void onEnsureDebugId(String baseID) {
        UIObject.ensureDebugId(this.getElement(), "", baseID);
    }

    protected final void setElement(com.google.gwt.dom.client.Element elem) {
        this.setElement((Element)elem);
    }

    protected void setElement(Element elem) {
        assert (this.element == null) : "Element may only be set once";
        this.element = elem;
    }

    void replaceElement(com.google.gwt.dom.client.Element elem) {
        if (this.element != null) {
            this.replaceNode(this.element, elem);
        }
        this.element = elem;
    }

    private native double extractLengthValue(String var1);

    private native void replaceNode(com.google.gwt.dom.client.Element var1, com.google.gwt.dom.client.Element var2);

    static {
        debugIdImpl = (DebugIdImpl)GWT.create(DebugIdImpl.class);
    }

    public static class DebugIdImpl {
        public void ensureDebugId(UIObject uiObject, String id) {
        }

        public void ensureDebugId(com.google.gwt.dom.client.Element elem, String baseID, String id) {
        }
    }

    public static class DebugIdImplEnabled
    extends DebugIdImpl {
        public void ensureDebugId(UIObject uiObject, String id) {
            uiObject.onEnsureDebugId(id);
        }

        public void ensureDebugId(com.google.gwt.dom.client.Element elem, String baseID, String id) {
            assert (baseID != null);
            baseID = baseID.length() > 0 ? baseID + "-" : "";
            DOM.setElementProperty((Element)elem.cast(), "id", UIObject.DEBUG_ID_PREFIX + baseID + id);
        }
    }
}

