/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.CurrencyList;
import com.google.gwt.i18n.client.impl.CurrencyDataImpl;
import com.google.gwt.i18n.rebind.CachedGeneratorContext;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.tapestry.util.text.LocalizedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyListGenerator
extends Generator {
    private static final String CURRENCY_DATA = CurrencyDataImpl.class.getCanonicalName();
    private static final String CURRENCY_DATA_PREFIX = "com/google/gwt/i18n/client/impl/cldr/CurrencyData";
    private static final String CURRENCY_EXTRA_PREFIX = "com/google/gwt/i18n/client/constants/CurrencyExtra";
    private static final String CURRENCY_LIST = CurrencyList.class.getCanonicalName();
    private static final String NUMBER_CONSTANTS_PREFIX = "com/google/gwt/i18n/client/constants/NumberConstantsImpl";

    private static String quote(String str) {
        return str.replace("\"", "\\\"");
    }

    public final String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        JClassType targetClass;
        assert (CURRENCY_LIST.equals(typeName));
        TypeOracle typeOracle = context.getTypeOracle();
        PropertyOracle propertyOracle = context.getPropertyOracle();
        LocaleUtils localeUtils = LocaleUtils.getInstance(logger, propertyOracle);
        GwtLocale locale = localeUtils.getCompileLocale();
        Set<GwtLocale> runtimeLocales = localeUtils.getRuntimeLocales();
        try {
            targetClass = typeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "No such type", (Throwable)e);
            throw new UnableToCompleteException();
        }
        if (runtimeLocales.isEmpty()) {
            return this.generateLocaleTree(logger, context, targetClass, locale);
        }
        CachedGeneratorContext cachedContext = new CachedGeneratorContext(context);
        return this.generateRuntimeSelection(logger, cachedContext, targetClass, locale, runtimeLocales);
    }

    private String generateLocaleTree(TreeLogger logger, GeneratorContext context, JClassType targetClass, GwtLocale locale) {
        String superClassName = CURRENCY_LIST;
        List<GwtLocale> searchList = locale.getCompleteSearchList();
        HashMap<String, CurrencyInfo> allCurrencyData = new HashMap<String, CurrencyInfo>();
        LocalizedProperties currencyExtra = null;
        String lastDefaultCurrencyCode = null;
        int i = searchList.size();
        while (i-- > 0) {
            String newClass;
            GwtLocale search = searchList.get(i);
            LocalizedProperties newExtra = this.getProperties(CURRENCY_EXTRA_PREFIX, search);
            if (newExtra != null) {
                currencyExtra = newExtra;
            }
            Map<String, String> currencyData = this.getCurrencyData(search);
            Set<String> keySet = currencyData.keySet();
            Object[] currencies = new String[keySet.size()];
            keySet.toArray(currencies);
            Arrays.sort(currencies);
            for (Object currencyCode : currencies) {
                String extraData = currencyExtra == null ? null : currencyExtra.getProperty((String)currencyCode);
                allCurrencyData.put((String)currencyCode, new CurrencyInfo((String)currencyCode, currencyData.get(currencyCode), extraData));
            }
            String defCurrencyCode = this.getDefaultCurrency(search);
            if (defCurrencyCode == null && keySet.contains(lastDefaultCurrencyCode)) {
                defCurrencyCode = lastDefaultCurrencyCode;
            }
            if (currencyData.isEmpty() && defCurrencyCode == null) continue;
            superClassName = newClass = this.generateOneLocale(logger, context, targetClass, search, superClassName, (String[])currencies, allCurrencyData, defCurrencyCode);
            lastDefaultCurrencyCode = defCurrencyCode;
        }
        return superClassName;
    }

    private String generateOneLocale(TreeLogger logger, GeneratorContext context, JClassType targetClass, GwtLocale locale, String superClassName, String[] currencies, Map<String, CurrencyInfo> allCurrencyData, String defCurrencyCode) {
        String className;
        String packageName = targetClass.getPackage().getName();
        PrintWriter pw = context.tryCreate(logger, packageName, className = targetClass.getName().replace('.', '_') + "_" + locale.getAsString());
        if (pw != null) {
            ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, className);
            factory.setSuperclass(superClassName);
            factory.addImport(CURRENCY_LIST);
            factory.addImport(CURRENCY_DATA);
            SourceWriter writer = factory.createSourceWriter(context, pw);
            if (currencies.length > 0) {
                this.writeCurrencyMethod(className, writer, currencies, allCurrencyData);
                this.writeNamesMethod(className, writer, currencies, allCurrencyData);
            }
            if (defCurrencyCode != null) {
                CurrencyInfo currencyInfo = allCurrencyData.get(defCurrencyCode);
                if (currencyInfo == null) {
                    currencyInfo = new CurrencyInfo(defCurrencyCode, null, null);
                    allCurrencyData.put(defCurrencyCode, currencyInfo);
                }
                writer.println();
                writer.println("@Override");
                writer.println("public native CurrencyData getDefault() /*-{");
                writer.println("  return " + currencyInfo.getJson() + ";");
                writer.println("}-*/;");
            }
            writer.commit(logger);
        }
        return packageName + "." + className;
    }

    private String generateRuntimeSelection(TreeLogger logger, GeneratorContext context, JClassType targetClass, GwtLocale compileLocale, Set<GwtLocale> locales) {
        String className;
        String packageName = targetClass.getPackage().getName();
        PrintWriter pw = context.tryCreate(logger, packageName, className = targetClass.getName().replace('.', '_') + "_" + compileLocale.getAsString() + "_runtimeSelection");
        if (pw != null) {
            ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, className);
            factory.setSuperclass(targetClass.getQualifiedSourceName());
            factory.addImport(CURRENCY_LIST);
            factory.addImport(CURRENCY_DATA);
            factory.addImport("com.google.gwt.i18n.client.LocaleInfo");
            SourceWriter writer = factory.createSourceWriter(context, pw);
            writer.println("private CurrencyList instance;");
            writer.println();
            writer.println("@Override");
            writer.println("public CurrencyData getDefault() {");
            writer.println("  ensureInstance();");
            writer.println("  return instance.getDefault();");
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("protected void loadCurrencyMap() {");
            writer.println("  ensureInstance();");
            writer.println("  instance.loadCurrencyMap();");
            writer.println("  dataMap = instance.dataMap;");
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("protected void loadNamesMap() {");
            writer.println("  ensureInstance();");
            writer.println("  instance.loadNamesMap();");
            writer.println("  namesMap = instance.namesMap;");
            writer.println("}");
            writer.println();
            writer.println("private void ensureInstance() {");
            writer.indent();
            writer.println("if (instance != null) {");
            writer.println("  return;");
            writer.println("}");
            boolean fetchedLocale = false;
            TreeMap<String, Set<GwtLocale>> localeMap = new TreeMap<String, Set<GwtLocale>>();
            String compileLocaleClass = this.processChildLocale(logger, context, targetClass, localeMap, compileLocale);
            if (compileLocaleClass == null) {
                return null;
            }
            for (GwtLocale gwtLocale : locales) {
                this.processChildLocale(logger, context, targetClass, localeMap, gwtLocale);
            }
            for (Map.Entry entry : localeMap.entrySet()) {
                if (!fetchedLocale) {
                    writer.println("String runtimeLocale = LocaleInfo.getCurrentLocale().getLocaleName();");
                    fetchedLocale = true;
                }
                boolean firstLocale = true;
                String generatedClass = (String)entry.getKey();
                if (compileLocaleClass.equals(generatedClass)) continue;
                writer.print("if (");
                for (GwtLocale locale : (Set)entry.getValue()) {
                    if (firstLocale) {
                        firstLocale = false;
                    } else {
                        writer.println();
                        writer.print("    || ");
                    }
                    writer.print("\"" + ((Object)locale).toString() + "\".equals(runtimeLocale)");
                }
                writer.println(") {");
                writer.println("  instance = new " + generatedClass + "();");
                writer.println("  return;");
                writer.println("}");
            }
            writer.println("instance = new " + compileLocaleClass + "();");
            writer.outdent();
            writer.println("}");
            writer.commit(logger);
        }
        return packageName + "." + className;
    }

    private Map<String, String> getCurrencyData(GwtLocale locale) {
        LocalizedProperties currencyData = this.getProperties(CURRENCY_DATA_PREFIX, locale);
        if (currencyData == null) {
            return Collections.emptyMap();
        }
        return currencyData.getPropertyMap();
    }

    private String getDefaultCurrency(GwtLocale locale) {
        String defCurrencyCode = null;
        LocalizedProperties numberConstants = this.getProperties(NUMBER_CONSTANTS_PREFIX, locale);
        if (numberConstants != null) {
            defCurrencyCode = numberConstants.getProperty("defCurrencyCode");
        }
        if (defCurrencyCode == null && locale.isDefault()) {
            defCurrencyCode = "USD";
        }
        return defCurrencyCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalizedProperties getProperties(String prefix, GwtLocale locale) {
        String propFile = prefix;
        if (!locale.isDefault()) {
            propFile = propFile + "_" + locale.getAsString();
        }
        propFile = propFile + ".properties";
        InputStream str = null;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        LocalizedProperties props = new LocalizedProperties();
        try {
            str = classLoader.getResourceAsStream(propFile);
            if (str != null) {
                props.load(str, "UTF-8");
                LocalizedProperties localizedProperties = props;
                return localizedProperties;
            }
        }
        catch (UnsupportedEncodingException e) {
            LocalizedProperties localizedProperties = null;
            return localizedProperties;
        }
        catch (IOException e) {
            LocalizedProperties localizedProperties = null;
            return localizedProperties;
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private String processChildLocale(TreeLogger logger, GeneratorContext context, JClassType targetClass, Map<String, Set<GwtLocale>> localeMap, GwtLocale locale) {
        String generatedClass = this.generateLocaleTree(logger, context, targetClass, locale);
        if (generatedClass == null) {
            logger.log(TreeLogger.ERROR, "Failed to generate " + targetClass.getQualifiedSourceName() + " in locale " + ((Object)locale).toString());
            return null;
        }
        Set<GwtLocale> locales = localeMap.get(generatedClass);
        if (locales == null) {
            locales = new HashSet<GwtLocale>();
            localeMap.put(generatedClass, locales);
        }
        locales.add(locale);
        return generatedClass;
    }

    private void writeCurrencyMethod(String className, SourceWriter writer, String[] currencies, Map<String, CurrencyInfo> allCurrencyData) {
        boolean needHeader = true;
        for (String currencyCode : currencies) {
            CurrencyInfo currencyInfo = allCurrencyData.get(currencyCode);
            if (needHeader) {
                needHeader = false;
                writer.println();
                writer.println("private void loadSuperCurrencyMap() {");
                writer.println("  super.loadCurrencyMap();");
                writer.println("}");
                writer.println();
                writer.println("@Override");
                writer.println("protected native void loadCurrencyMap() /*-{");
                writer.indent();
                writer.println("this.@com.google.gwt.i18n.client." + className + "::loadSuperCurrencyMap()();");
                writer.println("this.@com.google.gwt.i18n.client." + className + "::overrideCurrencyMap(Lcom/google/gwt/core/client/" + "JavaScriptObject;)({");
                writer.indent();
            }
            writer.println("// " + currencyInfo.getDisplayName());
            writer.println("\"" + CurrencyListGenerator.quote(currencyCode) + "\": " + currencyInfo.getJson() + ",");
        }
        if (!needHeader) {
            writer.outdent();
            writer.println("});");
            writer.outdent();
            writer.println("}-*/;");
        }
    }

    private void writeNamesMethod(String className, SourceWriter writer, String[] currencies, Map<String, CurrencyInfo> allCurrencyData) {
        boolean needHeader = true;
        for (String currencyCode : currencies) {
            CurrencyInfo currencyInfo = allCurrencyData.get(currencyCode);
            String displayName = currencyInfo.getDisplayName();
            if (displayName == null || currencyCode.equals(displayName)) continue;
            if (needHeader) {
                needHeader = false;
                writer.println();
                writer.println("private void loadSuperNamesMap() {");
                writer.println("  super.loadNamesMap();");
                writer.println("}");
                writer.println();
                writer.println("@Override");
                writer.println("protected native void loadNamesMap() /*-{");
                writer.indent();
                writer.println("this.@com.google.gwt.i18n.client." + className + "::loadSuperNamesMap()();");
                writer.println("this.@com.google.gwt.i18n.client." + className + "::overrideNamesMap(Lcom/google/gwt/core/" + "client/JavaScriptObject;)({");
                writer.indent();
            }
            writer.println("\"" + CurrencyListGenerator.quote(currencyCode) + "\": \"" + CurrencyListGenerator.quote(displayName) + "\",");
        }
        if (!needHeader) {
            writer.outdent();
            writer.println("});");
            writer.outdent();
            writer.println("}-*/;");
        }
    }

    private static class CurrencyInfo {
        private static final Pattern SPLIT_VERTICALBAR = Pattern.compile("\\|");
        private final String code;
        private final String displayName;
        private final int flags;
        private final boolean obsolete;
        private final String portableSymbol;
        private final String symbol;

        public CurrencyInfo(String currencyCode, String currencyData, String extraData) throws NumberFormatException {
            this.code = currencyCode;
            if (currencyData == null) {
                currencyData = currencyCode;
            }
            String[] currencySplit = SPLIT_VERTICALBAR.split(currencyData);
            String currencyDisplay = currencySplit[0];
            String currencySymbol = null;
            if (currencySplit.length > 1 && currencySplit[1].length() > 0) {
                currencySymbol = currencySplit[1];
            }
            int currencyFractionDigits = 2;
            if (currencySplit.length > 2 && currencySplit[2].length() > 0) {
                currencyFractionDigits = Integer.valueOf(currencySplit[2]);
            }
            boolean currencyObsolete = false;
            if (currencySplit.length > 3 && currencySplit[3].length() > 0) {
                currencyObsolete = Integer.valueOf(currencySplit[3]) != 0;
            }
            int currencyFlags = currencyFractionDigits;
            if (currencyObsolete) {
                currencyFlags |= 0x80;
            }
            String currencyPortableSymbol = "";
            if (extraData != null) {
                String[] extraSplit = SPLIT_VERTICALBAR.split(extraData);
                currencyPortableSymbol = extraSplit[0];
                if (extraSplit.length > 1) {
                    if (extraSplit[1].contains("SymPrefix")) {
                        currencyFlags |= 0x10;
                    } else if (extraSplit[1].contains("SymSuffix")) {
                        currencyFlags |= 0x18;
                    }
                    if (extraSplit[1].contains("ForceSpace")) {
                        currencyFlags |= 0x60;
                    } else if (extraSplit[1].contains("ForceNoSpace")) {
                        currencyFlags |= 0x40;
                    }
                }
                if (extraSplit.length > 2 && extraSplit[2].length() > 0) {
                    currencySymbol = extraSplit[2];
                }
                if (currencySymbol == null && currencyPortableSymbol.length() > 0) {
                    currencySymbol = currencyPortableSymbol;
                }
            }
            if (currencySymbol == null) {
                currencySymbol = currencyCode;
            }
            this.displayName = currencyDisplay;
            this.symbol = currencySymbol;
            this.flags = currencyFlags;
            this.portableSymbol = currencyPortableSymbol;
            this.obsolete = currencyObsolete;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getJson() {
            StringBuilder buf = new StringBuilder();
            buf.append("[ \"").append(CurrencyListGenerator.quote(this.code)).append("\", \"");
            buf.append(CurrencyListGenerator.quote(this.symbol)).append("\", ").append(this.flags);
            if (this.portableSymbol.length() > 0) {
                buf.append(", \"").append(CurrencyListGenerator.quote(this.portableSymbol)).append('\"');
            }
            return buf.append(']').toString();
        }

        public String getSymbol() {
            return this.symbol;
        }

        public boolean isObsolete() {
            return this.obsolete;
        }
    }
}

