/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormatParser {
    private static final Pattern argPattern = Pattern.compile("\\{(\\d+)(,(\\w+)(,([^\\}]+))?)?\\}");

    public static String assemble(Iterable<TemplateChunk> parts) {
        StringBuilder buf = new StringBuilder();
        for (TemplateChunk part : parts) {
            String str = part.getString();
            if (part.isLiteral()) {
                str = str.replace("'", "''");
                str = str.replace("{", "'{'").replace("}", "'}'");
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static List<TemplateChunk> parse(String template) throws ParseException {
        Matcher match = argPattern.matcher(template);
        int curPos = 0;
        boolean inQuote = false;
        int templateLen = template.length();
        ArrayList<TemplateChunk> chunks = new ArrayList<TemplateChunk>();
        TemplateChunk curChunk = null;
        block8: while (curPos < templateLen) {
            char ch = template.charAt(curPos++);
            switch (ch) {
                case '\'': {
                    if (curPos < templateLen && template.charAt(curPos) == '\'') {
                        curChunk = MessageFormatParser.appendString(chunks, curChunk, "'");
                        ++curPos;
                        continue block8;
                    }
                    inQuote = !inQuote;
                    continue block8;
                }
                case '{': {
                    if (inQuote) {
                        curChunk = MessageFormatParser.appendString(chunks, curChunk, "{");
                        continue block8;
                    }
                    if (match.find(curPos - 1) && match.start() == curPos - 1) {
                        int argNumber = Integer.valueOf(match.group(1));
                        curPos = match.end();
                        String format = match.group(3);
                        String subformat = match.group(5);
                        if (curChunk != null) {
                            chunks.add(curChunk);
                        }
                        chunks.add(new ArgumentChunk(argNumber, format, subformat));
                        curChunk = null;
                        continue block8;
                    }
                    throw new ParseException("Invalid message format - { not start of valid argument" + template, curPos);
                }
                case '\n': {
                    curChunk = MessageFormatParser.appendString(chunks, curChunk, "\\n");
                    continue block8;
                }
                case '\r': {
                    curChunk = MessageFormatParser.appendString(chunks, curChunk, "\\r");
                    continue block8;
                }
                case '\\': {
                    curChunk = MessageFormatParser.appendString(chunks, curChunk, "\\\\");
                    continue block8;
                }
                case '\"': {
                    curChunk = MessageFormatParser.appendString(chunks, curChunk, "\\\"");
                    continue block8;
                }
            }
            curChunk = MessageFormatParser.appendString(chunks, curChunk, String.valueOf(ch));
        }
        if (inQuote) {
            throw new ParseException("Unterminated single quote: " + template, template.length());
        }
        if (curChunk != null) {
            chunks.add(curChunk);
        }
        return chunks;
    }

    private static TemplateChunk appendString(ArrayList<TemplateChunk> chunks, TemplateChunk curChunk, String string) {
        if (curChunk != null && !curChunk.isLiteral()) {
            chunks.add(curChunk);
            curChunk = null;
        }
        if (curChunk == null) {
            curChunk = new StringChunk(string);
        } else {
            ((StringChunk)curChunk).append(string);
        }
        return curChunk;
    }

    public static class ArgumentChunk
    extends TemplateChunk {
        private int argNumber;
        private String format;
        private String subFormat;

        public ArgumentChunk(int argNumber, String format, String subformat) {
            this.argNumber = argNumber;
            this.format = format;
            this.subFormat = subformat;
        }

        public int getArgumentNumber() {
            return this.argNumber;
        }

        public String getFormat() {
            return this.format;
        }

        public String getString() {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            buf.append(this.argNumber);
            if (this.format != null || this.subFormat != null) {
                buf.append(',');
            }
            if (this.format != null) {
                buf.append(this.format);
            }
            if (this.subFormat != null) {
                buf.append(',');
                buf.append(this.subFormat);
            }
            buf.append('}');
            return buf.toString();
        }

        public String getSubFormat() {
            return this.subFormat;
        }

        public String toString() {
            return "Argument: #=" + this.argNumber + ", format=" + this.format + ", subformat=" + this.subFormat;
        }
    }

    public static class StringChunk
    extends TemplateChunk {
        private StringBuilder buf = new StringBuilder();

        public StringChunk() {
        }

        public StringChunk(String str) {
            this.buf.append(str);
        }

        public void append(String str) {
            this.buf.append(str);
        }

        public String getString() {
            return this.buf.toString();
        }

        public boolean isLiteral() {
            return true;
        }

        public String toString() {
            return "StringLiteral: \"" + this.buf.toString() + "\"";
        }
    }

    public static class TemplateChunk {
        public String getString() {
            return this.toString();
        }

        public boolean isLiteral() {
            return false;
        }
    }
}

