/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.cfg.ConfigurationProperty;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.junit.BatchingStrategy;
import com.google.gwt.junit.JUnitMessageQueue;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.client.impl.GWTRunner;
import com.google.gwt.junit.client.impl.JUnitHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class CompileStrategy {
    private Set<String> compiledModuleNames = new HashSet();
    private final JUnitShell junitShell;

    public CompileStrategy(JUnitShell junitShell) {
        this.junitShell = junitShell;
    }

    public void maybeAddTestBlockForCurrentTest(GWTTestCase testCase, BatchingStrategy batchingStrategy) {
        if (batchingStrategy.isSingleTestOnly()) {
            JUnitHost.TestInfo testInfo = new JUnitHost.TestInfo(testCase.getSyntheticModuleName(), ((Object)((Object)testCase)).getClass().getName(), testCase.getName());
            ArrayList<JUnitHost.TestInfo[]> testBlocks = new ArrayList<JUnitHost.TestInfo[]>(1);
            testBlocks.add(new JUnitHost.TestInfo[]{testInfo});
            this.getMessageQueue().addTestBlocks(testBlocks, false);
        }
    }

    public void maybeCompileAhead() throws UnableToCompleteException {
    }

    public abstract ModuleDef maybeCompileModule(String var1, String var2, JUnitShell.Strategy var3, BatchingStrategy var4, TreeLogger var5) throws UnableToCompleteException;

    protected ModuleDef maybeCompileModuleImpl(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy, BatchingStrategy batchingStrategy, TreeLogger treeLogger) throws UnableToCompleteException {
        ModuleDef moduleDef = this.maybeCompileModuleImpl2(moduleName, syntheticModuleName, strategy, treeLogger);
        if (!this.compiledModuleNames.contains(syntheticModuleName)) {
            this.compiledModuleNames.add(syntheticModuleName);
            if (!batchingStrategy.isSingleTestOnly()) {
                boolean isFinalModule = this.compiledModuleNames.size() >= this.getModuleCount();
                List<JUnitHost.TestInfo[]> testBlocks = batchingStrategy.getTestBlocks(syntheticModuleName);
                this.getMessageQueue().addTestBlocks(testBlocks, isFinalModule);
            }
        }
        return moduleDef;
    }

    JUnitMessageQueue getMessageQueue() {
        return JUnitShell.getMessageQueue();
    }

    int getModuleCount() {
        return GWTTestCase.getModuleCount();
    }

    ModuleDef maybeCompileModuleImpl2(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy, TreeLogger treeLogger) throws UnableToCompleteException {
        ModuleDef moduleDef = ModuleDefLoader.createSyntheticModule((TreeLogger)treeLogger, (String)syntheticModuleName, (String[])new String[]{moduleName, strategy.getModuleInherit()}, (boolean)false);
        moduleDef.clearEntryPoints();
        moduleDef.addEntryPointTypeName(GWTRunner.class.getName());
        ConfigurationProperty moduleNameProp = moduleDef.getProperties().createConfiguration("junit.moduleName", false);
        moduleNameProp.setValue(syntheticModuleName);
        strategy.processModule(moduleDef);
        this.junitShell.maybeCompileForWebMode(syntheticModuleName, JUnitShell.getRemoteUserAgents());
        return moduleDef;
    }
}

