/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MonitoredLogger;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFieldWriter
implements FieldWriter {
    private static final String NO_DEFAULT_CTOR_ERROR = "%1$s has no default (zero args) constructor. To fix this, you can define a @UiFactory method on the UiBinder's owner, or annotate a constructor of %2$s with @UiConstructor.";
    private final String name;
    private final Set<FieldWriter> needs = new LinkedHashSet<FieldWriter>();
    private String initializer;
    private boolean written;
    private MortalLogger logger;

    public AbstractFieldWriter(String name, MortalLogger logger) {
        if (name == null) {
            throw new RuntimeException("name cannot be null");
        }
        this.name = name;
        this.logger = logger;
    }

    @Override
    public String getInitializer() {
        return this.initializer;
    }

    @Override
    public JType getReturnType(String[] path, MonitoredLogger logger) {
        if (!this.name.equals(path[0])) {
            throw new RuntimeException(this + " asked to evaluate another field's path: " + path[0]);
        }
        List<String> pathList = Arrays.asList(path).subList(1, path.length);
        return this.getReturnType((JType)this.getAssignableType(), pathList, logger);
    }

    @Override
    public void needs(FieldWriter f) {
        this.needs.add(f);
    }

    @Override
    public void setInitializer(String initializer) {
        if (this.initializer != null) {
            throw new IllegalStateException(String.format("Second attempt to set initializer for field \"%s\", from \"%s\" to \"%s\"", this.name, this.initializer, initializer));
        }
        this.setInitializerMaybe(initializer);
    }

    @Override
    @Deprecated
    public void setInitializerMaybe(String initializer) {
        if (this.initializer != null && !this.initializer.equals(initializer)) {
            throw new IllegalStateException(String.format("Attempt to change initializer for field \"%s\", from \"%s\" to \"%s\"", this.name, this.initializer, initializer));
        }
        this.initializer = initializer;
    }

    public String toString() {
        return String.format("[%s %s = %s]", this.getClass().getName(), this.name, this.initializer);
    }

    @Override
    public void write(IndentedWriter w) throws UnableToCompleteException {
        JClassType type;
        if (this.written) {
            return;
        }
        for (FieldWriter f : this.needs) {
            f.write(w);
        }
        if (this.initializer == null && (type = this.getInstantiableType()) != null && type.isInterface() == null && type.findConstructor(new JType[0]) == null) {
            this.logger.die(NO_DEFAULT_CTOR_ERROR, type.getQualifiedSourceName(), type.getName());
        }
        if (null == this.initializer) {
            this.initializer = String.format("(%1$s) GWT.create(%1$s.class)", this.getQualifiedSourceName());
        }
        w.write("%s %s = %s;", this.getQualifiedSourceName(), this.name, this.initializer);
        this.written = true;
    }

    private JMethod findMethod(JClassType type, String methodName) {
        for (JClassType nextType : UiBinderWriter.getClassHierarchyBreadthFirst(type)) {
            try {
                return nextType.getMethod(methodName, new JType[0]);
            }
            catch (NotFoundException e) {
            }
        }
        return null;
    }

    private JType getReturnType(JType type, List<String> path, MonitoredLogger logger) {
        for (String pathElement : path) {
            JClassType referenceType = type.isClassOrInterface();
            if (referenceType == null) {
                logger.error("Cannot resolve member " + pathElement + " on non-reference type " + type.getQualifiedSourceName(), new Object[0]);
                return null;
            }
            JMethod m = this.findMethod(referenceType, pathElement);
            if (m == null) {
                logger.error("Could not find no-arg method named " + pathElement + " in type " + type.getQualifiedSourceName(), new Object[0]);
                return null;
            }
            type = m.getReturnType();
        }
        return type;
    }
}

