/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.messages;

import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.messages.PlaceholderWriter;
import java.util.ArrayList;
import java.util.List;

public class MessageWriter {
    private String defaultMessage;
    private final String description;
    private final String key;
    private final String name;
    private final List<PlaceholderWriter> placeholders = new ArrayList<PlaceholderWriter>();
    private final String meaning;

    public static String escapeMessageFormat(String messageFormatStyleText) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < messageFormatStyleText.length(); ++i) {
            char c = messageFormatStyleText.charAt(i);
            if (c == '\'') {
                b.append("''");
                continue;
            }
            if (c == '{') {
                b.append("'{'");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    MessageWriter(String description, String key, String meaning, String name) {
        this.description = description;
        this.key = key;
        this.meaning = meaning;
        this.name = name;
    }

    public void addPlaceholder(PlaceholderWriter placeholder) {
        this.placeholders.add(placeholder);
    }

    public String getInvocation() {
        StringBuilder b = new StringBuilder(String.format("%s(", this.name));
        int countdown = this.placeholders.size();
        for (PlaceholderWriter ph : this.placeholders) {
            b.append(ph.getValue());
            if (--countdown <= 0) continue;
            b.append(",");
        }
        b.append(")");
        return b.toString();
    }

    public int getPlaceholderCount() {
        return this.placeholders.size();
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public void writeDeclaration(IndentedWriter pw) {
        pw.write("@DefaultMessage(\"%s\")", this.defaultMessage);
        if (this.description.length() > 0) {
            pw.write("@Description(\"%s\")", this.description);
        }
        if (this.key.length() > 0) {
            pw.write("@Key(\"%s\")", this.key);
        }
        if (this.meaning.length() > 0) {
            pw.write("@Meaning(\"%s\")", this.meaning);
        }
        if (this.placeholders.isEmpty()) {
            pw.write("String %s();", this.name);
        } else {
            pw.write("String %s(", this.name);
            pw.indent();
            int countdown = this.placeholders.size();
            for (PlaceholderWriter ph : this.placeholders) {
                String comma = --countdown > 0 ? "," : "";
                pw.write(ph.getDeclaration() + comma);
            }
            pw.write(");");
            pw.outdent();
        }
        pw.newline();
    }
}

