/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.messages;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.Tokenator;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.uibinder.rebind.messages.PlaceholderWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlaceholderInterpreter
implements XMLElement.PostProcessingInterpreter<String> {
    protected final UiBinderWriter uiWriter;
    protected final MessageWriter message;
    protected final Tokenator tokenator = new Tokenator();

    public PlaceholderInterpreter(UiBinderWriter writer, MessageWriter message) {
        this.uiWriter = writer;
        this.message = message;
    }

    @Override
    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (this.isPlaceholderElement(elem)) {
            MessagesWriter mw = this.getMessagesWriter();
            String name = mw.consumeRequiredMessageElementAttribute("name", elem);
            String example = mw.consumeMessageElementAttribute("example", elem);
            String value = this.consumePlaceholderInnards(elem);
            if ("".equals(example)) {
                example = this.stripTokens(value);
            }
            value = this.uiWriter.detokenate(value);
            return this.nextPlaceholder(name, example, value);
        }
        if (this.uiWriter.isWidgetElement(elem)) {
            this.uiWriter.die("Found %s in a message that cannot contain widgets", elem);
        }
        return null;
    }

    @Override
    public String postProcess(String consumed) throws UnableToCompleteException {
        return this.tokenator.detokenate(MessageWriter.escapeMessageFormat(consumed));
    }

    protected abstract String consumePlaceholderInnards(XMLElement var1) throws UnableToCompleteException;

    protected String nextPlaceholder(String name, String example, String value) {
        this.message.addPlaceholder(new PlaceholderWriter(name, example, value));
        String placeholder = String.format("{%d}", this.message.getPlaceholderCount() - 1);
        return this.tokenator.nextToken(placeholder);
    }

    protected String stripTokens(String value) {
        String rtn = Tokenator.detokenate(value, new Tokenator.Resolver(){

            public String resolveToken(String token) {
                return "";
            }
        });
        return rtn;
    }

    private MessagesWriter getMessagesWriter() {
        return this.uiWriter.getMessages();
    }

    private boolean isPlaceholderElement(XMLElement elem) {
        return this.getMessagesWriter().isMessagePrefixed(elem) && "ph".equals(elem.getLocalName());
    }
}

