/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.model;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.resources.css.ExtractClassNamesVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.uibinder.attributeparsers.CssNameConverter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitCssResource {
    private static final CssNameConverter nameConverter = new CssNameConverter();
    private final String packageName;
    private final String className;
    private final String name;
    private final List<String> sources;
    private final JClassType extendedInterface;
    private final String body;
    private final MortalLogger logger;
    private final Set<JClassType> imports;
    private File generatedFile;
    private Set<String> cssClassNames;
    private Set<String> normalizedCssClassNames;

    public ImplicitCssResource(String packageName, String className, String name, String[] source, JClassType extendedInterface, String body, MortalLogger logger, Set<JClassType> importTypes) {
        this.packageName = packageName;
        this.className = className;
        this.name = name;
        this.extendedInterface = extendedInterface;
        this.body = body;
        this.logger = logger;
        this.imports = Collections.unmodifiableSet(importTypes);
        this.sources = Arrays.asList(source);
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getCssClassNames() throws UnableToCompleteException {
        List<URL> urls = this.getExternalCss();
        if (this.cssClassNames == null) {
            File bodyFile = this.getGeneratedFile();
            if (bodyFile != null) {
                try {
                    urls.add(bodyFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            assert (urls.size() > 0);
            CssStylesheet sheet = GenerateCssAst.exec(this.logger.getTreeLogger(), urls.toArray(new URL[urls.size()]));
            this.cssClassNames = ExtractClassNamesVisitor.exec(sheet, this.imports.toArray(new JClassType[this.imports.size()]));
        }
        return this.cssClassNames;
    }

    public JClassType getExtendedInterface() {
        return this.extendedInterface;
    }

    public Set<JClassType> getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getNormalizedCssClassNames() throws UnableToCompleteException {
        if (this.normalizedCssClassNames == null) {
            Set<String> rawNames = this.getCssClassNames();
            this.normalizedCssClassNames = new HashSet<String>();
            for (String rawName : rawNames) {
                this.normalizedCssClassNames.add(nameConverter.convertName(rawName));
            }
        }
        return this.normalizedCssClassNames;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedSourceName() {
        if (this.packageName.length() == 0) {
            return this.name;
        }
        return String.format("%s.%s", this.packageName, this.className);
    }

    public Collection<String> getSource() {
        if (this.body.length() == 0) {
            return Collections.unmodifiableCollection(this.sources);
        }
        ArrayList<String> rtn = new ArrayList<String>(this.sources);
        rtn.add(this.getBodyFileName());
        return rtn;
    }

    private String getBodyFileName() {
        return String.format("uibinder:%s.%s.css", this.packageName, this.className);
    }

    private List<URL> getExternalCss() throws UnableToCompleteException {
        ClassLoader classLoader = ImplicitCssResource.class.getClassLoader();
        String path = this.packageName.replace(".", "/");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : this.sources) {
            String resourcePath = path + '/' + s;
            URL found = classLoader.getResource(resourcePath);
            if (null == found) {
                this.logger.die("Unable to find resource: " + resourcePath, new Object[0]);
            }
            urls.add(found);
        }
        return urls;
    }

    private File getGeneratedFile() {
        if (this.body.length() == 0) {
            return null;
        }
        if (this.generatedFile == null) {
            try {
                File f = File.createTempFile(String.format("uiBinder_%s_%s", this.packageName, this.className), ".css");
                f.deleteOnExit();
                BufferedWriter out = new BufferedWriter(new FileWriter(f));
                out.write(this.body);
                out.close();
                this.generatedFile = f;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ResourceGeneratorUtil.addNamedFile(this.getBodyFileName(), this.generatedFile);
        }
        return this.generatedFile;
    }
}

