/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractMethodCreator;
import com.google.gwt.user.rebind.AbstractSourceCreator;
import com.google.gwt.user.rebind.SourceWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratorClassCreator
extends AbstractSourceCreator {
    protected Map<JType, AbstractMethodCreator> methodFactories = new HashMap<JType, AbstractMethodCreator>();
    JClassType targetClass;
    private final SourceWriter writer;

    public static JMethod[] getAllInterfaceMethods(JClassType type) {
        HashMap<String, JMethod> methods = new HashMap<String, JMethod>();
        AbstractGeneratorClassCreator.getAllInterfaceMethodsAux(type, methods);
        return methods.values().toArray(new JMethod[methods.size()]);
    }

    private static void getAllInterfaceMethodsAux(JClassType type, Map<String, JMethod> m) {
        if (type.isInterface() != null) {
            JMethod[] methods = type.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String s = AbstractGeneratorClassCreator.uniqueMethodKey(methods[i]);
                if (m.get(s) != null) continue;
                m.put(s, methods[i]);
            }
            JClassType[] supers = type.getImplementedInterfaces();
            for (int i = 0; i < supers.length; ++i) {
                AbstractGeneratorClassCreator.getAllInterfaceMethodsAux(supers[i], m);
            }
        }
    }

    private static String uniqueMethodKey(JMethod method) {
        String name = method.getName();
        name = name + "(";
        JParameter[] m = method.getParameters();
        for (int i = 0; i < m.length; ++i) {
            name = name + m[i].getType() + " ";
        }
        name = name + ")";
        return name;
    }

    public AbstractGeneratorClassCreator(SourceWriter writer, JClassType targetClass) {
        this.targetClass = targetClass;
        this.writer = writer;
    }

    public void emitClass(TreeLogger logger, GwtLocale locale) throws UnableToCompleteException {
        logger = AbstractGeneratorClassCreator.branch(logger, this.branchMessage());
        this.classPrologue();
        this.emitMethods(logger, this.targetClass, locale);
        this.classEpilog();
        this.getWriter().println("}");
    }

    public JClassType getTarget() {
        return this.targetClass;
    }

    public UnableToCompleteException logMissingResource(TreeLogger logger, String during, AbstractResource.MissingResourceException e) {
        String msg = "No resource found for key '" + e.getKey() + "'";
        if (during != null) {
            msg = msg + " while " + during;
        }
        logger.log(TreeLogger.ERROR, msg, (Throwable)e);
        TreeLogger searchedBranch = logger.branch(TreeLogger.WARN, "Searched the following resources:", null);
        for (AbstractResource resource : e.getSearchedResources()) {
            TreeLogger resBranch = searchedBranch.branch(TreeLogger.WARN, resource.toString(), null);
            Set<String> keys = resource.keySet();
            TreeLogger keyBranch = resBranch.branch(TreeLogger.INFO, "List of keys found", null);
            for (String key : keys) {
                keyBranch.log(TreeLogger.INFO, key, null);
            }
        }
        return new UnableToCompleteException();
    }

    public void register(JType returnType, AbstractMethodCreator creator) {
        this.methodFactories.put(returnType.getErasedType(), creator);
    }

    protected String branchMessage() {
        return "Constructing " + this.targetClass;
    }

    protected void classEpilog() {
    }

    protected void classPrologue() {
    }

    protected abstract void emitMethodBody(TreeLogger var1, JMethod var2, GwtLocale var3) throws UnableToCompleteException;

    protected AbstractMethodCreator getMethodCreator(TreeLogger logger, JMethod method) throws UnableToCompleteException {
        JType type = method.getReturnType();
        AbstractMethodCreator methodCreator = this.methodFactories.get(type = type.getErasedType());
        if (methodCreator == null) {
            String msg = "No current method creator exists for " + method + " only methods with return types of ";
            Iterator<JType> iter = this.methodFactories.keySet().iterator();
            while (iter.hasNext()) {
                msg = msg + iter.next().getSimpleSourceName();
                if (!iter.hasNext()) continue;
                msg = msg + ", ";
            }
            msg = msg + " can be created";
            throw AbstractGeneratorClassCreator.error(logger, msg);
        }
        return methodCreator;
    }

    protected SourceWriter getWriter() {
        return this.writer;
    }

    private void emitMethods(TreeLogger logger, JClassType cur, GwtLocale locale) throws UnableToCompleteException {
        JMethod[] x = AbstractGeneratorClassCreator.getAllInterfaceMethods(cur);
        for (int i = 0; i < x.length; ++i) {
            this.genMethod(logger, x[i], locale);
            this.getWriter().println();
        }
    }

    private void genMethod(TreeLogger logger, JMethod method, GwtLocale locale) throws UnableToCompleteException {
        String name = method.getName();
        String returnType = method.getReturnType().getParameterizedQualifiedSourceName();
        this.getWriter().print("public " + returnType + " " + name + "(");
        JParameter[] params = method.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                this.getWriter().print(",");
            }
            this.getWriter().print(params[i].getType().getParameterizedQualifiedSourceName() + " " + params[i].getName());
        }
        this.getWriter().println(") {");
        this.getWriter().indent();
        String methodName = method.getName();
        TreeLogger branch = AbstractGeneratorClassCreator.branch(logger, "Generating method body for " + methodName + "()");
        try {
            this.emitMethodBody(branch, method, locale);
        }
        catch (AbstractResource.MissingResourceException e) {
            throw this.logMissingResource(branch, null, e);
        }
        this.getWriter().outdent();
        this.getWriter().println("}");
    }
}

