/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;

class TypePaths {
    TypePaths() {
    }

    static TypePath createArrayComponentPath(final JArrayType arrayType, final TypePath parent) {
        assert (arrayType != null);
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                return "Type '" + arrayType.getComponentType().getParameterizedQualifiedSourceName() + "' is reachable from array type '" + arrayType.getParameterizedQualifiedSourceName() + "'";
            }
        };
    }

    static TypePath createFieldPath(final TypePath parent, final JField field) {
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                JType type = field.getType();
                JClassType enclosingType = field.getEnclosingType();
                return "'" + type.getParameterizedQualifiedSourceName() + "' is reachable from field '" + field.getName() + "' of type '" + enclosingType.getParameterizedQualifiedSourceName() + "'";
            }
        };
    }

    static TypePath createRootPath(final JType type) {
        assert (type != null);
        return new TypePath(){

            public TypePath getParent() {
                return null;
            }

            public String toString() {
                return "Started from '" + type.getParameterizedQualifiedSourceName() + "'";
            }
        };
    }

    static TypePath createSubtypePath(final TypePath parent, final JType type, final JClassType supertype) {
        assert (type != null);
        assert (supertype != null);
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                return "'" + type.getParameterizedQualifiedSourceName() + "' is reachable as a subtype of type '" + supertype + "'";
            }
        };
    }

    static TypePath createSupertypePath(final TypePath parent, final JType type, final JClassType subtype) {
        assert (type != null);
        assert (subtype != null);
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                return "'" + type.getParameterizedQualifiedSourceName() + "' is reachable as a supertype of type '" + subtype + "'";
            }
        };
    }

    static TypePath createTypeArgumentPath(final TypePath parent, final JGenericType baseType, final int typeArgIndex, final JClassType typeArg) {
        assert (baseType != null);
        assert (typeArg != null);
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                return "'" + typeArg.getParameterizedQualifiedSourceName() + "' is reachable from type argument " + typeArgIndex + " of type '" + baseType.getParameterizedQualifiedSourceName() + "'";
            }
        };
    }

    static TypePath createTypeParameterInRootPath(final TypePath parent, final JTypeParameter typeParameter) {
        assert (typeParameter != null);
        return new TypePath(){

            public TypePath getParent() {
                return parent;
            }

            public String toString() {
                String parameterString = typeParameter.getName();
                if (typeParameter.getDeclaringClass() != null) {
                    parameterString = parameterString + " of class " + typeParameter.getDeclaringClass().getQualifiedSourceName();
                }
                return "'" + typeParameter.getFirstBound().getParameterizedQualifiedSourceName() + "' is reachable as an upper bound of type parameter " + parameterString + ", which appears in a root type";
            }
        };
    }

    static interface TypePath {
        public TypePath getParent();

        public String toString();
    }
}

