/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.cassandra.avro.AuthenticationException;
import org.apache.cassandra.avro.AuthenticationRequest;
import org.apache.cassandra.avro.AuthorizationException;
import org.apache.cassandra.avro.CfDef;
import org.apache.cassandra.avro.Column;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnParent;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.ConsistencyLevel;
import org.apache.cassandra.avro.CoscsMapEntry;
import org.apache.cassandra.avro.IndexClause;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.KeyCountMapEntry;
import org.apache.cassandra.avro.KeyRange;
import org.apache.cassandra.avro.KeySlice;
import org.apache.cassandra.avro.KsDef;
import org.apache.cassandra.avro.MutationsMapEntry;
import org.apache.cassandra.avro.NotFoundException;
import org.apache.cassandra.avro.SlicePredicate;
import org.apache.cassandra.avro.TimedOutException;
import org.apache.cassandra.avro.TokenRange;
import org.apache.cassandra.avro.UnavailableException;

public interface Cassandra {
    public static final Protocol PROTOCOL = Protocol.parse((String)"{\"protocol\":\"Cassandra\",\"namespace\":\"org.apache.cassandra.avro\",\"types\":[{\"type\":\"record\",\"name\":\"ColumnPath\",\"fields\":[{\"name\":\"column_family\",\"type\":\"string\"},{\"name\":\"super_column\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"column\",\"type\":[\"bytes\",\"null\"]}]},{\"type\":\"record\",\"name\":\"ColumnParent\",\"fields\":[{\"name\":\"column_family\",\"type\":\"string\"},{\"name\":\"super_column\",\"type\":[\"bytes\",\"null\"]}]},{\"type\":\"record\",\"name\":\"Column\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"ttl\",\"type\":[\"int\",\"null\"]}]},{\"type\":\"record\",\"name\":\"SuperColumn\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":{\"type\":\"array\",\"items\":\"Column\"}}]},{\"type\":\"record\",\"name\":\"ColumnOrSuperColumn\",\"fields\":[{\"name\":\"column\",\"type\":[\"Column\",\"null\"]},{\"name\":\"super_column\",\"type\":[\"SuperColumn\",\"null\"]}]},{\"type\":\"record\",\"name\":\"SliceRange\",\"fields\":[{\"name\":\"start\",\"type\":\"bytes\"},{\"name\":\"finish\",\"type\":\"bytes\"},{\"name\":\"reversed\",\"type\":\"boolean\"},{\"name\":\"count\",\"type\":\"int\"},{\"name\":\"bitmasks\",\"type\":[{\"type\":\"array\",\"items\":\"bytes\"},\"null\"]}]},{\"type\":\"record\",\"name\":\"SlicePredicate\",\"fields\":[{\"name\":\"column_names\",\"type\":[{\"type\":\"array\",\"items\":\"bytes\"},\"null\"]},{\"name\":\"slice_range\",\"type\":[\"SliceRange\",\"null\"]}]},{\"type\":\"record\",\"name\":\"TokenRange\",\"fields\":[{\"name\":\"start_token\",\"type\":\"string\"},{\"name\":\"end_token\",\"type\":\"string\"},{\"name\":\"endpoints\",\"type\":{\"type\":\"array\",\"items\":\"string\"}}]},{\"type\":\"enum\",\"name\":\"IndexOperator\",\"symbols\":[\"EQ\",\"GTE\",\"GT\",\"LTE\",\"LT\"]},{\"type\":\"record\",\"name\":\"IndexExpression\",\"fields\":[{\"name\":\"column_name\",\"type\":\"bytes\"},{\"name\":\"op\",\"type\":\"IndexOperator\"},{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"IndexClause\",\"fields\":[{\"name\":\"expressions\",\"type\":{\"type\":\"array\",\"items\":\"IndexExpression\"}},{\"name\":\"start_key\",\"type\":\"bytes\"},{\"name\":\"count\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"KeyRange\",\"fields\":[{\"name\":\"start_key\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"end_key\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"start_token\",\"type\":[\"string\",\"null\"]},{\"name\":\"end_token\",\"type\":[\"string\",\"null\"]},{\"name\":\"count\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"KeySlice\",\"fields\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":{\"type\":\"array\",\"items\":\"ColumnOrSuperColumn\"}}]},{\"type\":\"record\",\"name\":\"Deletion\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"super_column\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"predicate\",\"type\":[\"SlicePredicate\",\"null\"]}]},{\"type\":\"record\",\"name\":\"Mutation\",\"fields\":[{\"name\":\"column_or_supercolumn\",\"type\":[\"ColumnOrSuperColumn\",\"null\"]},{\"name\":\"deletion\",\"type\":[\"Deletion\",\"null\"]}]},{\"type\":\"enum\",\"name\":\"IndexType\",\"symbols\":[\"KEYS\"],\"aliases\":[\"org.apache.cassandra.config.avro.IndexType\"]},{\"type\":\"record\",\"name\":\"ColumnDef\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"validation_class\",\"type\":\"string\"},{\"name\":\"index_type\",\"type\":[\"IndexType\",\"null\"]},{\"name\":\"index_name\",\"type\":[\"string\",\"null\"]}],\"aliases\":[\"org.apache.cassandra.config.avro.ColumnDef\"]},{\"type\":\"record\",\"name\":\"CfDef\",\"fields\":[{\"name\":\"keyspace\",\"type\":\"string\"},{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"column_type\",\"type\":[\"string\",\"null\"]},{\"name\":\"comparator_type\",\"type\":[\"string\",\"null\"]},{\"name\":\"subcomparator_type\",\"type\":[\"string\",\"null\"]},{\"name\":\"comment\",\"type\":[\"string\",\"null\"]},{\"name\":\"row_cache_size\",\"type\":[\"double\",\"null\"]},{\"name\":\"key_cache_size\",\"type\":[\"double\",\"null\"]},{\"name\":\"read_repair_chance\",\"type\":[\"double\",\"null\"]},{\"name\":\"gc_grace_seconds\",\"type\":[\"int\",\"null\"]},{\"name\":\"default_validation_class\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"min_compaction_threshold\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"max_compaction_threshold\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"row_cache_save_period_in_seconds\",\"type\":[\"int\",\"null\"],\"default\":0},{\"name\":\"key_cache_save_period_in_seconds\",\"type\":[\"int\",\"null\"],\"default\":3600},{\"name\":\"memtable_flush_after_mins\",\"type\":[\"int\",\"null\"],\"default\":60},{\"name\":\"memtable_throughput_in_mb\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"memtable_operations_in_millions\",\"type\":[\"null\",\"double\"],\"default\":null},{\"name\":\"id\",\"type\":[\"int\",\"null\"]},{\"name\":\"column_metadata\",\"type\":[{\"type\":\"array\",\"items\":\"ColumnDef\"},\"null\"]}],\"aliases\":[\"org.apache.cassandra.config.avro.CfDef\"]},{\"type\":\"record\",\"name\":\"KsDef\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"strategy_class\",\"type\":\"string\"},{\"name\":\"strategy_options\",\"type\":[{\"type\":\"map\",\"values\":\"string\"},\"null\"]},{\"name\":\"replication_factor\",\"type\":\"int\"},{\"name\":\"cf_defs\",\"type\":{\"type\":\"array\",\"items\":\"CfDef\"}}],\"aliases\":[\"org.apache.cassandra.config.avro.KsDef\"]},{\"type\":\"record\",\"name\":\"StreamingMutation\",\"fields\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"mutation\",\"type\":\"Mutation\"}]},{\"type\":\"record\",\"name\":\"MutationsMapEntry\",\"fields\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"mutations\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"array\",\"items\":\"Mutation\"}}}]},{\"type\":\"record\",\"name\":\"CoscsMapEntry\",\"fields\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":{\"type\":\"array\",\"items\":\"ColumnOrSuperColumn\"}}]},{\"type\":\"record\",\"name\":\"KeyCountMapEntry\",\"fields\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"count\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"AuthenticationRequest\",\"fields\":[{\"name\":\"credentials\",\"type\":{\"type\":\"map\",\"values\":\"string\"}}]},{\"type\":\"enum\",\"name\":\"ConsistencyLevel\",\"symbols\":[\"ONE\",\"QUORUM\",\"LOCAL_QUORUM\",\"EACH_QUORUM\",\"ALL\"]},{\"type\":\"error\",\"name\":\"InvalidRequestException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"NotFoundException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"UnavailableException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"TimedOutException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"AuthenticationException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"AuthorizationException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]}],\"messages\":{\"login\":{\"request\":[{\"name\":\"auth_request\",\"type\":\"AuthenticationRequest\"}],\"response\":\"null\",\"errors\":[\"AuthenticationException\",\"AuthorizationException\"]},\"set_keyspace\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\"]},\"get\":{\"request\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"column_path\",\"type\":\"ColumnPath\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"ColumnOrSuperColumn\",\"errors\":[\"InvalidRequestException\",\"NotFoundException\",\"UnavailableException\",\"TimedOutException\"]},\"get_slice\":{\"request\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":{\"type\":\"array\",\"items\":\"ColumnOrSuperColumn\"},\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"multiget_slice\":{\"request\":[{\"name\":\"keys\",\"type\":{\"type\":\"array\",\"items\":\"bytes\"}},{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":{\"type\":\"array\",\"items\":\"CoscsMapEntry\"},\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"multiget_count\":{\"request\":[{\"name\":\"keys\",\"type\":{\"type\":\"array\",\"items\":\"bytes\"}},{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":{\"type\":\"array\",\"items\":\"KeyCountMapEntry\"},\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"get_indexed_slices\":{\"request\":[{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"index_clause\",\"type\":\"IndexClause\"},{\"name\":\"column_predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":{\"type\":\"array\",\"items\":\"KeySlice\"},\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"get_count\":{\"request\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"int\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"insert\":{\"request\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"column\",\"type\":\"Column\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"remove\":{\"request\":[{\"name\":\"key\",\"type\":\"bytes\"},{\"name\":\"column_path\",\"type\":\"ColumnPath\"},{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"batch_mutate\":{\"request\":[{\"name\":\"mutation_map\",\"type\":{\"type\":\"array\",\"items\":\"MutationsMapEntry\"}},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"truncate\":{\"request\":[{\"name\":\"column_family\",\"type\":\"string\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\"]},\"check_schema_agreement\":{\"request\":[],\"response\":{\"type\":\"map\",\"values\":{\"type\":\"array\",\"items\":\"string\"}},\"errors\":[\"InvalidRequestException\"]},\"system_add_column_family\":{\"request\":[{\"name\":\"cf_def\",\"type\":\"CfDef\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"system_add_keyspace\":{\"request\":[{\"name\":\"ks_def\",\"type\":\"KsDef\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"system_drop_column_family\":{\"request\":[{\"name\":\"column_family\",\"type\":\"string\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"system_drop_keyspace\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"system_update_column_family\":{\"request\":[{\"name\":\"cf_def\",\"type\":\"CfDef\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"system_update_keyspace\":{\"request\":[{\"name\":\"ks_def\",\"type\":\"KsDef\"}],\"response\":\"string\",\"errors\":[\"InvalidRequestException\"]},\"describe_keyspaces\":{\"request\":[],\"response\":{\"type\":\"array\",\"items\":\"string\"}},\"describe_keyspace\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"}],\"response\":\"KsDef\",\"errors\":[\"NotFoundException\"]},\"describe_cluster_name\":{\"request\":[],\"response\":\"string\"},\"describe_version\":{\"request\":[],\"response\":\"string\"},\"describe_partitioner\":{\"request\":[],\"response\":\"string\"},\"describe_splits\":{\"request\":[{\"name\":\"cfName\",\"type\":\"string\"},{\"name\":\"start_token\",\"type\":\"string\"},{\"name\":\"end_token\",\"type\":\"string\"},{\"name\":\"keys_per_split\",\"type\":\"int\"}],\"response\":{\"type\":\"array\",\"items\":\"string\"}},\"describe_ring\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"}],\"response\":{\"type\":\"array\",\"items\":\"TokenRange\"},\"errors\":[\"InvalidRequestException\"]},\"get_range_slices\":{\"request\":[{\"name\":\"column_parent\",\"type\":\"ColumnParent\"},{\"name\":\"predicate\",\"type\":\"SlicePredicate\"},{\"name\":\"range\",\"type\":\"KeyRange\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":{\"type\":\"array\",\"items\":\"KeySlice\"},\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]}}}");

    public Void login(AuthenticationRequest var1) throws AvroRemoteException, AuthenticationException, AuthorizationException;

    public Void set_keyspace(CharSequence var1) throws AvroRemoteException, InvalidRequestException;

    public ColumnOrSuperColumn get(ByteBuffer var1, ColumnPath var2, ConsistencyLevel var3) throws AvroRemoteException, InvalidRequestException, NotFoundException, UnavailableException, TimedOutException;

    public List<ColumnOrSuperColumn> get_slice(ByteBuffer var1, ColumnParent var2, SlicePredicate var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public List<CoscsMapEntry> multiget_slice(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public List<KeyCountMapEntry> multiget_count(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public List<KeySlice> get_indexed_slices(ColumnParent var1, IndexClause var2, SlicePredicate var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public int get_count(ByteBuffer var1, ColumnParent var2, SlicePredicate var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Void insert(ByteBuffer var1, ColumnParent var2, Column var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Void remove(ByteBuffer var1, ColumnPath var2, long var3, ConsistencyLevel var5) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Void batch_mutate(List<MutationsMapEntry> var1, ConsistencyLevel var2) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Void truncate(CharSequence var1) throws AvroRemoteException, InvalidRequestException, UnavailableException;

    public Map<CharSequence, List<CharSequence>> check_schema_agreement() throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_add_column_family(CfDef var1) throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_add_keyspace(KsDef var1) throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_drop_column_family(CharSequence var1) throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_drop_keyspace(CharSequence var1) throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_update_column_family(CfDef var1) throws AvroRemoteException, InvalidRequestException;

    public CharSequence system_update_keyspace(KsDef var1) throws AvroRemoteException, InvalidRequestException;

    public List<CharSequence> describe_keyspaces() throws AvroRemoteException;

    public KsDef describe_keyspace(CharSequence var1) throws AvroRemoteException, NotFoundException;

    public CharSequence describe_cluster_name() throws AvroRemoteException;

    public CharSequence describe_version() throws AvroRemoteException;

    public CharSequence describe_partitioner() throws AvroRemoteException;

    public List<CharSequence> describe_splits(CharSequence var1, CharSequence var2, CharSequence var3, int var4) throws AvroRemoteException;

    public List<TokenRange> describe_ring(CharSequence var1) throws AvroRemoteException, InvalidRequestException;

    public List<KeySlice> get_range_slices(ColumnParent var1, SlicePredicate var2, KeyRange var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;
}

