/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSerializer
implements ICompactSerializer2<IColumn> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnSerializer.class);
    public static final int DELETION_MASK = 1;
    public static final int EXPIRATION_MASK = 2;

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        assert (column.name().remaining() > 0);
        FBUtilities.writeShortByteArray(column.name(), dos);
        try {
            if (column instanceof ExpiringColumn) {
                dos.writeByte(2);
                dos.writeInt(((ExpiringColumn)column).getTimeToLive());
                dos.writeInt(column.getLocalDeletionTime());
            } else {
                dos.writeByte(column.isMarkedForDelete() ? 1 : 0);
            }
            dos.writeLong(column.timestamp());
            FBUtilities.writeByteArray(column.value(), dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Column deserialize(DataInput dis) throws IOException {
        ByteBuffer name = FBUtilities.readShortByteArray(dis);
        if (name.remaining() <= 0) {
            throw new CorruptColumnException("invalid column name length " + name.remaining());
        }
        int b = dis.readUnsignedByte();
        if ((b & 2) != 0) {
            int ttl = dis.readInt();
            int expiration = dis.readInt();
            long ts = dis.readLong();
            ByteBuffer value = FBUtilities.readByteArray(dis);
            if ((int)(System.currentTimeMillis() / 1000L) > expiration) {
                ByteBuffer bytes = ByteBuffer.allocate(4);
                bytes.putInt(expiration);
                bytes.rewind();
                return new DeletedColumn(name, bytes, ts);
            }
            return new ExpiringColumn(name, value, ts, ttl, expiration);
        }
        long ts = dis.readLong();
        ByteBuffer value = FBUtilities.readByteArray(dis);
        return (b & 1) == 0 ? new Column(name, value, ts) : new DeletedColumn(name, value, ts);
    }

    private static class CorruptColumnException
    extends IOException {
        public CorruptColumnException(String s) {
            super(s);
        }
    }
}

