/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.AbstractCompactedRow;
import org.apache.cassandra.io.CompactionIterator;
import org.apache.cassandra.io.ICompactionInfo;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    private final ReentrantLock compactionLock = new ReentrantLock();
    private CompactionExecutor executor = new CompactionExecutor();
    private Map<ColumnFamilyStore, Integer> estimatedCompactions = new NonBlockingHashMap();

    public Lock getCompactionLock() {
        return this.compactionLock;
    }

    public Future<Integer> submitMinorIfNeeded(final ColumnFamilyStore cfs) {
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws IOException {
                CompactionManager.this.compactionLock.lock();
                try {
                    if (cfs.isInvalid()) {
                        Integer n = 0;
                        return n;
                    }
                    Integer minThreshold = cfs.getMinimumCompactionThreshold();
                    Integer maxThreshold = cfs.getMaximumCompactionThreshold();
                    if (minThreshold == 0 || maxThreshold == 0) {
                        logger.debug("Compaction is currently disabled.");
                        Integer n = 0;
                        return n;
                    }
                    logger.debug("Checking to see if compaction of " + cfs.columnFamily + " would be useful");
                    Set buckets = CompactionManager.getBuckets(CompactionManager.convertSSTablesToPairs(cfs.getSSTables()), 0x3200000L);
                    CompactionManager.this.updateEstimateFor(cfs, buckets);
                    for (List sstables : buckets) {
                        if (sstables.size() < minThreshold) continue;
                        Collections.sort(sstables);
                        int gcBefore = cfs.isIndex() ? Integer.MAX_VALUE : (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
                        Integer n = CompactionManager.this.doCompaction(cfs, sstables.subList(0, Math.min(sstables.size(), maxThreshold)), gcBefore);
                        return n;
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
                return 0;
            }
        };
        return this.executor.submit(callable);
    }

    private void updateEstimateFor(ColumnFamilyStore cfs, Set<List<SSTableReader>> buckets) {
        Integer minThreshold = cfs.getMinimumCompactionThreshold();
        Integer maxThreshold = cfs.getMaximumCompactionThreshold();
        if (minThreshold > 0 && maxThreshold > 0) {
            int n = 0;
            for (List<SSTableReader> sstables : buckets) {
                if (sstables.size() < minThreshold) continue;
                n = (int)((double)n + Math.ceil((double)sstables.size() / (double)maxThreshold.intValue()));
            }
            this.estimatedCompactions.put(cfs, n);
        } else {
            logger.debug("Compaction is currently disabled.");
        }
    }

    public void performCleanup(final ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.lock();
                try {
                    if (!cfStore.isInvalid()) {
                        CompactionManager.this.doCleanupCompaction(cfStore);
                    }
                    2 var1_1 = this;
                    return var1_1;
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performMajor(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.submitMajor(cfStore, 0L, (int)(System.currentTimeMillis() / 1000L) - cfStore.metadata.getGcGraceSeconds()).get();
    }

    public Future<Object> submitMajor(final ColumnFamilyStore cfStore, final long skip, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.lock();
                try {
                    ArrayList<SSTableReader> sstables;
                    if (cfStore.isInvalid()) {
                        3 var1_1 = this;
                        return var1_1;
                    }
                    if (skip > 0L) {
                        sstables = new ArrayList();
                        for (SSTableReader sstable : cfStore.getSSTables()) {
                            if (sstable.length() >= skip * 1024L * 1024L * 1024L) continue;
                            sstables.add(sstable);
                        }
                    } else {
                        sstables = cfStore.getSSTables();
                    }
                    CompactionManager.this.doCompaction(cfStore, sstables, gcBefore);
                    3 var2_3 = this;
                    return var2_3;
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final AntiEntropyService.Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.lock();
                try {
                    if (!cfStore.isInvalid()) {
                        CompactionManager.this.doValidationCompaction(cfStore, validator);
                    }
                    4 var1_1 = this;
                    return var1_1;
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : DatabaseDescriptor.getNonSystemTables()) {
            Table ks = Table.open(ksname);
            for (ColumnFamilyStore cfs : ks.columnFamilyStores.values()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) throws IOException {
        SSTableWriter writer;
        Table table = cfs.table;
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            table.snapshot("compact-" + cfs.columnFamily);
        }
        logger.info("Compacting [" + StringUtils.join(sstables, (String)",") + "]");
        String compactionFileLocation = table.getDataFileLocation(cfs.getExpectedCompactedFileSize(sstables));
        ArrayList<SSTableReader> smallerSSTables = new ArrayList<SSTableReader>(sstables);
        while (compactionFileLocation == null && smallerSSTables.size() > 1) {
            logger.warn("insufficient space to compact all requested files " + StringUtils.join(smallerSSTables, (String)", "));
            smallerSSTables.remove(cfs.getMaxSizeFile(smallerSSTables));
            compactionFileLocation = table.getDataFileLocation(cfs.getExpectedCompactedFileSize(smallerSSTables));
        }
        if (compactionFileLocation == null) {
            logger.error("insufficient space to compact even the two smallest files, aborting");
            return 0;
        }
        sstables = smallerSSTables;
        boolean major = cfs.isCompleteSSTables(sstables);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(sstables));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
        }
        CompactionIterator ci = new CompactionIterator(cfs, sstables, gcBefore, major);
        FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
        this.executor.beginCompaction(cfs, ci);
        HashMap<DecoratedKey, Long> cachedKeys = new HashMap<DecoratedKey, Long>();
        try {
            if (!nni.hasNext()) {
                cfs.markCompacted(sstables);
                int n = 0;
                return n;
            }
            String newFilename = new File(cfs.getTempSSTablePath(compactionFileLocation)).getAbsolutePath();
            writer = new SSTableWriter(newFilename, expectedBloomFilterSize, cfs.metadata, cfs.partitioner);
            block5: while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                long position = writer.append(row);
                ++totalkeysWritten;
                for (SSTableReader sstable : sstables) {
                    if (sstable.getCachedPosition(row.key) == null) continue;
                    cachedKeys.put(row.key, position);
                    continue block5;
                }
            }
        }
        finally {
            ci.close();
        }
        SSTableReader ssTable = writer.closeAndOpenReader(CompactionManager.getMaxDataAge(sstables));
        cfs.replaceCompactedSSTables(sstables, Arrays.asList(ssTable));
        for (Map.Entry entry : cachedKeys.entrySet()) {
            ssTable.cacheKey((DecoratedKey)entry.getKey(), (Long)entry.getValue());
        }
        this.submitMinorIfNeeded(cfs);
        long dTime = System.currentTimeMillis() - startTime;
        long startsize = SSTable.getTotalBytes(sstables);
        long endsize = ssTable.length();
        double ratio = (double)endsize / (double)startsize;
        logger.info(String.format("Compacted to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.", writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
        return sstables.size();
    }

    private static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanupCompaction(ColumnFamilyStore cfs) throws IOException {
        assert (!cfs.isIndex());
        Table table = cfs.table;
        Collection<Range> ranges = StorageService.instance.getLocalRanges(table.name);
        for (SSTableReader sstable : cfs.getSSTables()) {
            logger.info("Cleaning up " + sstable);
            long expectedRangeFileSize = cfs.getExpectedCompactedFileSize(Arrays.asList(sstable)) / 2L;
            String compactionFileLocation = table.getDataFileLocation(expectedRangeFileSize);
            if (compactionFileLocation == null) {
                throw new UnsupportedOperationException("disk full");
            }
            long startTime = System.currentTimeMillis();
            long totalkeysWritten = 0L;
            int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)(SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)) / 2L));
            if (logger.isDebugEnabled()) {
                logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
            }
            SSTableWriter writer = null;
            SSTableScanner scanner = sstable.getScanner(0x100000);
            SortedSet<ByteBuffer> indexedColumns = cfs.getIndexedColumns();
            this.executor.beginCompaction(cfs, new CleanupInfo(sstable, scanner));
            try {
                while (scanner.hasNext()) {
                    SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                    if (Range.isTokenInRanges(row.getKey().token, ranges)) {
                        writer = this.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, writer);
                        writer.append(new EchoedRow(row));
                        ++totalkeysWritten;
                        continue;
                    }
                    while (row.hasNext()) {
                        IColumn column = row.next();
                        if (!indexedColumns.contains(column.name())) continue;
                        Table.cleanupIndexEntry(cfs, row.getKey().key, column);
                    }
                }
            }
            finally {
                scanner.close();
            }
            ArrayList<SSTableReader> results = new ArrayList<SSTableReader>();
            if (writer != null) {
                SSTableReader newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                results.add(newSstable);
                String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
                long dTime = System.currentTimeMillis() - startTime;
                long startsize = sstable.length();
                long endsize = newSstable.length();
                double ratio = (double)endsize / (double)startsize;
                logger.info(String.format(format, writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
            }
            for (ByteBuffer columnName : cfs.getIndexedColumns()) {
                try {
                    cfs.getIndexedColumnFamilyStore(columnName).forceBlockingFlush();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            cfs.replaceCompactedSSTables(Arrays.asList(sstable), results);
        }
    }

    private SSTableWriter maybeCreateWriter(ColumnFamilyStore cfs, String compactionFileLocation, int expectedBloomFilterSize, SSTableWriter writer) throws IOException {
        if (writer == null) {
            FileUtils.createDirectory(compactionFileLocation);
            String newFilename = new File(cfs.getTempSSTablePath(compactionFileLocation)).getAbsolutePath();
            writer = new SSTableWriter(newFilename, expectedBloomFilterSize, cfs.metadata, cfs.partitioner);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, AntiEntropyService.Validator validator) throws IOException {
        try {
            StorageService.instance.forceTableFlush(cfs.table.name, cfs.getColumnFamilyName());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        ValidationCompactionIterator ci = new ValidationCompactionIterator(cfs);
        this.executor.beginCompaction(cfs, ci);
        try {
            FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
            validator.prepare(cfs);
            while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            ci.close();
        }
    }

    static <T> Set<List<T>> getBuckets(Collection<Pair<T, Long>> files, long min) {
        ArrayList<Pair<T, Long>> sortedFiles = new ArrayList<Pair<T, Long>>(files);
        Collections.sort(sortedFiles, new Comparator<Pair<T, Long>>(){

            @Override
            public int compare(Pair<T, Long> p1, Pair<T, Long> p2) {
                return ((Long)p1.right).compareTo((Long)p2.right);
            }
        });
        HashMap<List, Long> buckets = new HashMap<List, Long>();
        for (Pair pair : sortedFiles) {
            long size = (Long)pair.right;
            boolean bFound = false;
            for (Map.Entry entry : buckets.entrySet()) {
                List bucket = (List)entry.getKey();
                long averageSize = (Long)entry.getValue();
                if ((size <= averageSize / 2L || size >= 3L * averageSize / 2L) && (size >= min || averageSize >= min)) continue;
                buckets.remove(bucket);
                long totalSize = (long)bucket.size() * averageSize;
                averageSize = (totalSize + size) / (long)(bucket.size() + 1);
                bucket.add(pair.left);
                buckets.put(bucket, averageSize);
                bFound = true;
                break;
            }
            if (bFound) continue;
            ArrayList bucket = new ArrayList();
            bucket.add(pair.left);
            buckets.put(bucket, size);
        }
        return buckets.keySet();
    }

    private static Collection<Pair<SSTableReader, Long>> convertSSTablesToPairs(Collection<SSTableReader> collection) {
        ArrayList<Pair<SSTableReader, Long>> tablePairs = new ArrayList<Pair<SSTableReader, Long>>();
        for (SSTableReader table : collection) {
            tablePairs.add(new Pair<SSTableReader, Long>(table, table.length()));
        }
        return tablePairs;
    }

    public Future submitIndexBuild(final ColumnFamilyStore cfs, final Table.IndexBuilder builder) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompactionManager.this.compactionLock.lock();
                try {
                    if (cfs.isInvalid()) {
                        return;
                    }
                    CompactionManager.this.executor.beginCompaction(cfs, builder);
                    builder.build();
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
            }
        };
        if (this.compactionLock.isHeldByCurrentThread()) {
            return new SimpleFuture(runnable);
        }
        return this.executor.submit(runnable);
    }

    public Future<SSTableReader> submitSSTableBuild(Descriptor desc) {
        final SSTableWriter.Builder builder = SSTableWriter.createBuilder(desc);
        Callable<SSTableReader> callable = new Callable<SSTableReader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SSTableReader call() throws IOException {
                CompactionManager.this.compactionLock.lock();
                try {
                    CompactionManager.this.executor.beginCompaction(builder.cfs, builder);
                    SSTableReader sSTableReader = builder.build();
                    return sSTableReader;
                }
                finally {
                    CompactionManager.this.compactionLock.unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    public void checkAllColumnFamilies() throws IOException {
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    logger.debug("Estimating compactions for " + cfs.columnFamily);
                    Set buckets = CompactionManager.getBuckets(CompactionManager.convertSSTablesToPairs(cfs.getSSTables()), 0x3200000L);
                    CompactionManager.this.updateEstimateFor(cfs, buckets);
                }
            };
            this.executor.submit(runnable);
        }
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            this.submitMinorIfNeeded(cfs);
        }
    }

    @Override
    public String getColumnFamilyInProgress() {
        return this.executor.getColumnFamilyName();
    }

    @Override
    public Long getBytesTotalInProgress() {
        return this.executor.getBytesTotal();
    }

    @Override
    public Long getBytesCompacted() {
        return this.executor.getBytesCompleted();
    }

    @Override
    public String getCompactionType() {
        return this.executor.getType();
    }

    @Override
    public int getPendingTasks() {
        int n = 0;
        for (Integer i : this.estimatedCompactions.values()) {
            n += i.intValue();
        }
        return (int)(this.executor.getTaskCount() - this.executor.getCompletedTaskCount()) + n;
    }

    @Override
    public long getCompletedTasks() {
        return this.executor.getCompletedTaskCount();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class CleanupInfo
    implements ICompactionInfo {
        private final SSTableReader sstable;
        private final SSTableScanner scanner;

        public CleanupInfo(SSTableReader sstable, SSTableScanner scanner) {
            this.sstable = sstable;
            this.scanner = scanner;
        }

        @Override
        public long getTotalBytes() {
            return this.scanner.getFileLength();
        }

        @Override
        public long getBytesRead() {
            return this.scanner.getFilePointer();
        }

        @Override
        public String getTaskType() {
            return "Cleanup of " + this.sstable.getColumnFamilyName();
        }
    }

    private static class CompactionExecutor
    extends DebuggableThreadPoolExecutor {
        private volatile ColumnFamilyStore cfs;
        private volatile ICompactionInfo ci;

        public CompactionExecutor() {
            super("CompactionExecutor", DatabaseDescriptor.getCompactionThreadPriority());
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.cfs = null;
            this.ci = null;
        }

        void beginCompaction(ColumnFamilyStore cfs, ICompactionInfo ci) {
            this.cfs = cfs;
            this.ci = ci;
        }

        public String getColumnFamilyName() {
            return this.cfs == null ? null : this.cfs.getColumnFamilyName();
        }

        public Long getBytesTotal() {
            return this.ci == null ? null : Long.valueOf(this.ci.getTotalBytes());
        }

        public Long getBytesCompleted() {
            return this.ci == null ? null : Long.valueOf(this.ci.getBytesRead());
        }

        public String getType() {
            return this.ci == null ? null : this.ci.getTaskType();
        }
    }

    private static class EchoedRow
    extends AbstractCompactedRow {
        private final SSTableIdentityIterator row;

        public EchoedRow(SSTableIdentityIterator row) {
            super(row.getKey());
            this.row = row;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.row.dataSize);
            this.row.echoData(out);
        }

        @Override
        public void update(MessageDigest digest) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return !this.row.hasNext();
        }

        @Override
        public int columnCount() {
            return this.row.columnCount;
        }
    }

    private static class SimpleFuture
    implements Future {
        private Runnable runnable;

        private SimpleFuture(Runnable r) {
            this.runnable = r;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new IllegalStateException("May not call SimpleFuture.cancel()");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.runnable == null;
        }

        public Object get() throws InterruptedException, ExecutionException {
            this.runnable.run();
            this.runnable = null;
            return this.runnable;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException("May not call SimpleFuture.get(long, TimeUnit)");
        }
    }

    private static class ValidationCompactionIterator
    extends CompactionIterator {
        public ValidationCompactionIterator(ColumnFamilyStore cfs) throws IOException {
            super(cfs, cfs.getSSTables(), (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds(), true);
        }

        @Override
        public String getTaskType() {
            return "Validation";
        }
    }
}

