/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.utils.FBUtilities;

public class SliceByNamesReadCommand
extends ReadCommand {
    public final SortedSet<ByteBuffer> columnNames = new TreeSet<ByteBuffer>(this.getComparator());

    public SliceByNamesReadCommand(String table, ByteBuffer key, ColumnParent column_parent, Collection<ByteBuffer> columnNames) {
        this(table, key, new QueryPath(column_parent), columnNames);
    }

    public SliceByNamesReadCommand(String table, ByteBuffer key, QueryPath path, Collection<ByteBuffer> columnNames) {
        super(table, key, path, (byte)1);
        this.columnNames.addAll(columnNames);
    }

    @Override
    public ReadCommand copy() {
        SliceByNamesReadCommand readCommand = new SliceByNamesReadCommand(this.table, this.key, this.queryPath, this.columnNames);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Table table) throws IOException {
        DecoratedKey dk = StorageService.getPartitioner().decorateKey(this.key);
        return table.getRow(QueryFilter.getNamesFilter(dk, this.queryPath, this.columnNames));
    }

    public String toString() {
        return "SliceByNamesReadCommand(table='" + this.table + '\'' + ", key=" + FBUtilities.bytesToHex(this.key) + ", columnParent='" + this.queryPath + '\'' + ", columns=[" + this.getComparator().getString(this.columnNames) + "]" + ')';
    }
}

