/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;

class IndexedSliceReader
extends AbstractIterator<IColumn>
implements IColumnIterator {
    private final ColumnFamily emptyColumnFamily;
    private final List<IndexHelper.IndexInfo> indexes;
    private final FileDataInput file;
    private final ByteBuffer startColumn;
    private final ByteBuffer finishColumn;
    private final boolean reversed;
    private BlockFetcher fetcher;
    private Deque<IColumn> blockColumns = new ArrayDeque<IColumn>();
    private AbstractType comparator;

    public IndexedSliceReader(CFMetaData metadata, FileDataInput input, ByteBuffer startColumn, ByteBuffer finishColumn, boolean reversed) {
        this.file = input;
        this.startColumn = startColumn;
        this.finishColumn = finishColumn;
        this.reversed = reversed;
        this.comparator = metadata.comparator;
        try {
            IndexHelper.skipBloomFilter(this.file);
            this.indexes = IndexHelper.deserializeIndex(this.file);
            this.emptyColumnFamily = ColumnFamily.serializer().deserializeFromSSTableNoColumns(ColumnFamily.create(metadata), this.file);
            this.fetcher = this.indexes == null ? new SimpleBlockFetcher() : new IndexedBlockFetcher();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.emptyColumnFamily;
    }

    @Override
    public DecoratedKey getKey() {
        throw new UnsupportedOperationException();
    }

    private boolean isColumnNeeded(IColumn column) {
        if (this.startColumn.remaining() == 0 && this.finishColumn.remaining() == 0) {
            return true;
        }
        if (this.startColumn.remaining() == 0 && !this.reversed) {
            return this.comparator.compare(column.name(), this.finishColumn) <= 0;
        }
        if (this.startColumn.remaining() == 0 && this.reversed) {
            return this.comparator.compare(column.name(), this.finishColumn) >= 0;
        }
        if (this.finishColumn.remaining() == 0 && !this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) >= 0;
        }
        if (this.finishColumn.remaining() == 0 && this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) <= 0;
        }
        if (!this.reversed) {
            return this.comparator.compare(column.name(), this.startColumn) >= 0 && this.comparator.compare(column.name(), this.finishColumn) <= 0;
        }
        return this.comparator.compare(column.name(), this.startColumn) <= 0 && this.comparator.compare(column.name(), this.finishColumn) >= 0;
    }

    /*
     * Exception decompiling
     */
    protected IColumn computeNext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
    }

    static interface BlockFetcher {
        public boolean getNextBlock() throws IOException;
    }

    private class IndexedBlockFetcher
    implements BlockFetcher {
        private final FileMark mark;
        private int curRangeIndex;

        IndexedBlockFetcher() throws IOException {
            IndexedSliceReader.this.file.readInt();
            this.mark = IndexedSliceReader.this.file.mark();
            this.curRangeIndex = IndexHelper.indexFor(IndexedSliceReader.this.startColumn, IndexedSliceReader.this.indexes, IndexedSliceReader.this.comparator, IndexedSliceReader.this.reversed);
            if (IndexedSliceReader.this.reversed && this.curRangeIndex == IndexedSliceReader.this.indexes.size()) {
                --this.curRangeIndex;
            }
        }

        @Override
        public boolean getNextBlock() throws IOException {
            if (this.curRangeIndex < 0 || this.curRangeIndex >= IndexedSliceReader.this.indexes.size()) {
                return false;
            }
            IndexHelper.IndexInfo curColPosition = (IndexHelper.IndexInfo)IndexedSliceReader.this.indexes.get(this.curRangeIndex);
            if (IndexedSliceReader.this.reversed ? IndexedSliceReader.this.finishColumn.remaining() > 0 && IndexedSliceReader.this.comparator.compare(IndexedSliceReader.this.finishColumn, curColPosition.lastName) > 0 || IndexedSliceReader.this.startColumn.remaining() > 0 && IndexedSliceReader.this.comparator.compare(IndexedSliceReader.this.startColumn, curColPosition.firstName) < 0 : IndexedSliceReader.this.startColumn.remaining() > 0 && IndexedSliceReader.this.comparator.compare(IndexedSliceReader.this.startColumn, curColPosition.lastName) > 0 || IndexedSliceReader.this.finishColumn.remaining() > 0 && IndexedSliceReader.this.comparator.compare(IndexedSliceReader.this.finishColumn, curColPosition.firstName) < 0) {
                return false;
            }
            boolean outOfBounds = false;
            IndexedSliceReader.this.file.reset(this.mark);
            long curOffset = IndexedSliceReader.this.file.skipBytes((int)curColPosition.offset);
            assert (curOffset == curColPosition.offset);
            while ((long)IndexedSliceReader.this.file.bytesPastMark(this.mark) < curColPosition.offset + curColPosition.width && !outOfBounds) {
                IColumn column = IndexedSliceReader.this.emptyColumnFamily.getColumnSerializer().deserialize(IndexedSliceReader.this.file);
                if (IndexedSliceReader.this.reversed) {
                    IndexedSliceReader.this.blockColumns.addFirst(column);
                } else {
                    IndexedSliceReader.this.blockColumns.addLast(column);
                }
                if (!IndexedSliceReader.this.reversed && IndexedSliceReader.this.finishColumn.remaining() > 0) {
                    outOfBounds = IndexedSliceReader.this.comparator.compare(column.name(), IndexedSliceReader.this.finishColumn) >= 0;
                    continue;
                }
                if (!IndexedSliceReader.this.reversed || IndexedSliceReader.this.startColumn.remaining() <= 0) continue;
                outOfBounds = IndexedSliceReader.this.comparator.compare(column.name(), IndexedSliceReader.this.startColumn) >= 0;
            }
            this.curRangeIndex = IndexedSliceReader.this.reversed ? --this.curRangeIndex : ++this.curRangeIndex;
            return true;
        }
    }

    private class SimpleBlockFetcher
    implements BlockFetcher {
        private SimpleBlockFetcher() throws IOException {
            int columns = IndexedSliceReader.this.file.readInt();
            for (int i = 0; i < columns; ++i) {
                IColumn column = IndexedSliceReader.this.emptyColumnFamily.getColumnSerializer().deserialize(IndexedSliceReader.this.file);
                if (IndexedSliceReader.this.reversed) {
                    IndexedSliceReader.this.blockColumns.addFirst(column);
                } else {
                    IndexedSliceReader.this.blockColumns.addLast(column);
                }
                boolean outOfBounds = false;
                if (!IndexedSliceReader.this.reversed && IndexedSliceReader.this.finishColumn.remaining() > 0) {
                    outOfBounds = IndexedSliceReader.this.comparator.compare(column.name(), IndexedSliceReader.this.finishColumn) >= 0;
                } else if (IndexedSliceReader.this.reversed && IndexedSliceReader.this.startColumn.remaining() > 0) {
                    boolean bl = outOfBounds = IndexedSliceReader.this.comparator.compare(column.name(), IndexedSliceReader.this.startColumn) >= 0;
                }
                if (outOfBounds) break;
            }
        }

        @Override
        public boolean getNextBlock() throws IOException {
            return false;
        }
    }
}

