/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.EndpointStatesSerializationHelper;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.io.ICompactSerializer;

class GossipDigestAckMessageSerializer
implements ICompactSerializer<GossipDigestAckMessage> {
    GossipDigestAckMessageSerializer() {
    }

    @Override
    public void serialize(GossipDigestAckMessage gDigestAckMessage, DataOutputStream dos) throws IOException {
        GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList_, dos);
        dos.writeBoolean(true);
        EndpointStatesSerializationHelper.serialize(gDigestAckMessage.epStateMap_, dos);
    }

    @Override
    public GossipDigestAckMessage deserialize(DataInputStream dis) throws IOException {
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(dis);
        dis.readBoolean();
        Map<InetAddress, EndpointState> epStateMap = EndpointStatesSerializationHelper.deserialize(dis);
        return new GossipDigestAckMessage(gDigestList, epStateMap);
    }
}

