/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableScanner
implements Iterator<IColumnIterator>,
Closeable {
    private static Logger logger = LoggerFactory.getLogger(SSTableScanner.class);
    private final BufferedRandomAccessFile file;
    private final SSTableReader sstable;
    private IColumnIterator row;
    private boolean exhausted = false;
    private Iterator<IColumnIterator> iterator;
    private QueryFilter filter;

    SSTableScanner(SSTableReader sstable, int bufferSize) {
        try {
            this.file = new BufferedRandomAccessFile(sstable.getFilename(), "r", bufferSize);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.sstable = sstable;
    }

    SSTableScanner(SSTableReader sstable, QueryFilter filter, int bufferSize) {
        try {
            this.file = new BufferedRandomAccessFile(sstable.getFilename(), "r", bufferSize);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.sstable = sstable;
        this.filter = filter;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public void seekTo(DecoratedKey seekKey) {
        try {
            long position = this.sstable.getPosition(seekKey, SSTableReader.Operator.GE);
            if (position < 0L) {
                this.exhausted = true;
                return;
            }
            this.file.seek(position);
            this.row = null;
        }
        catch (IOException e) {
            throw new RuntimeException("corrupt sstable", e);
        }
    }

    public long getFileLength() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public long getFilePointer() {
        return this.file.getFilePointer();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public IColumnIterator next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class KeyScanningIterator
    implements Iterator<IColumnIterator> {
        private long finishedAt;

        private KeyScanningIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (SSTableScanner.this.row == null) {
                    return !SSTableScanner.this.file.isEOF();
                }
                return this.finishedAt < SSTableScanner.this.file.length();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IColumnIterator next() {
            try {
                if (SSTableScanner.this.row != null) {
                    SSTableScanner.this.file.seek(this.finishedAt);
                }
                assert (!SSTableScanner.this.file.isEOF());
                DecoratedKey key = SSTableReader.decodeKey(((SSTableScanner)SSTableScanner.this).sstable.partitioner, ((SSTableScanner)SSTableScanner.this).sstable.descriptor, FBUtilities.readShortByteArray(SSTableScanner.this.file));
                long dataSize = SSTableReader.readRowSize(SSTableScanner.this.file, ((SSTableScanner)SSTableScanner.this).sstable.descriptor);
                long dataStart = SSTableScanner.this.file.getFilePointer();
                this.finishedAt = dataStart + dataSize;
                if (SSTableScanner.this.filter == null) {
                    SSTableScanner.this.row = new SSTableIdentityIterator(SSTableScanner.this.sstable, SSTableScanner.this.file, key, dataStart, dataSize);
                    return SSTableScanner.this.row;
                }
                return SSTableScanner.this.row = SSTableScanner.this.filter.getSSTableColumnIterator(SSTableScanner.this.sstable, SSTableScanner.this.file, key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

