/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOError;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.io.util.BufferedSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.utils.Pair;

public abstract class SegmentedFile {
    public final String path;
    public final long length;

    SegmentedFile(String path, long length) {
        this.path = path;
        this.length = length;
    }

    public static Builder getBuilder(Config.DiskAccessMode mode) {
        return mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedSegmentedFile.Builder();
    }

    public abstract FileDataInput getSegment(long var1, int var3);

    public Iterator<FileDataInput> iterator(long position, int bufferSize) {
        return new SegmentIterator(position, bufferSize);
    }

    public static abstract class Builder {
        public abstract void addPotentialBoundary(long var1);

        public abstract SegmentedFile complete(String var1);
    }

    static final class Segment
    extends Pair<Long, MappedByteBuffer>
    implements Comparable<Segment> {
        public Segment(long offset, MappedByteBuffer segment) {
            super(offset, segment);
        }

        @Override
        public final int compareTo(Segment that) {
            return (int)Math.signum((Long)this.left - (Long)that.left);
        }
    }

    final class SegmentIterator
    implements Iterator<FileDataInput> {
        private long nextpos;
        private final int bufferSize;

        public SegmentIterator(long position, int bufferSize) {
            this.nextpos = position;
            this.bufferSize = bufferSize;
        }

        @Override
        public boolean hasNext() {
            return this.nextpos < SegmentedFile.this.length;
        }

        @Override
        public FileDataInput next() {
            long position = this.nextpos;
            if (position >= SegmentedFile.this.length) {
                throw new NoSuchElementException();
            }
            FileDataInput segment = SegmentedFile.this.getSegment(this.nextpos, this.bufferSize);
            try {
                this.nextpos += segment.bytesRemaining();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            return segment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

