/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class SSTableImport {
    private static final String KEYSPACE_OPTION = "K";
    private static final String COLFAM_OPTION = "c";
    private static Options options = new Options();
    private static CommandLine cmd;

    private static void addToStandardCF(JSONArray row, ColumnFamily cfamily) {
        CFMetaData cfm = cfamily.metadata();
        assert (cfm != null);
        for (Object c : row) {
            JsonColumn col = new JsonColumn(c);
            QueryPath path = new QueryPath(cfm.cfName, null, ByteBuffer.wrap(FBUtilities.hexToBytes(col.name)));
            if (col.ttl > 0) {
                cfamily.addColumn(null, new ExpiringColumn(ByteBuffer.wrap(FBUtilities.hexToBytes(col.name)), ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp, col.ttl, col.localExpirationTime));
                continue;
            }
            if (col.isDeleted) {
                cfamily.addTombstone(path, ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp);
                continue;
            }
            cfamily.addColumn(path, ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp);
        }
    }

    private static void addToSuperCF(JSONObject row, ColumnFamily cfamily) {
        CFMetaData cfm = cfamily.metadata();
        assert (cfm != null);
        for (Map.Entry entry : row.entrySet()) {
            ByteBuffer superName = ByteBuffer.wrap(FBUtilities.hexToBytes((String)entry.getKey()));
            long deletedAt = (Long)((JSONObject)entry.getValue()).get((Object)"deletedAt");
            JSONArray subColumns = (JSONArray)((JSONObject)entry.getValue()).get((Object)"subColumns");
            for (Object c : subColumns) {
                JsonColumn col = new JsonColumn(c);
                QueryPath path = new QueryPath(cfm.cfName, superName, ByteBuffer.wrap(FBUtilities.hexToBytes(col.name)));
                if (col.ttl > 0) {
                    cfamily.addColumn(superName, new ExpiringColumn(ByteBuffer.wrap(FBUtilities.hexToBytes(col.name)), ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp, col.ttl, col.localExpirationTime));
                    continue;
                }
                if (col.isDeleted) {
                    cfamily.addTombstone(path, ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp);
                    continue;
                }
                cfamily.addColumn(path, ByteBuffer.wrap(FBUtilities.hexToBytes(col.value)), col.timestamp);
            }
            SuperColumn superColumn = (SuperColumn)cfamily.getColumn(superName);
            superColumn.markForDeleteAt((int)(System.currentTimeMillis() / 1000L), deletedAt);
        }
    }

    public static void importJson(String jsonFile, String keyspace, String cf, String ssTablePath) throws IOException, org.json.simple.parser.ParseException {
        ColumnFamily cfamily = ColumnFamily.create(keyspace, cf);
        ColumnFamilyType cfType = cfamily.getColumnFamilyType();
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        try {
            JSONObject json = (JSONObject)JSONValue.parseWithException((Reader)new FileReader(jsonFile));
            SSTableWriter writer = new SSTableWriter(ssTablePath, json.size());
            TreeMap decoratedKeys = new TreeMap();
            for (String string : json.keySet()) {
                decoratedKeys.put(partitioner.decorateKey(ByteBuffer.wrap(FBUtilities.hexToBytes(string))), string);
            }
            for (Map.Entry entry : decoratedKeys.entrySet()) {
                if (cfType == ColumnFamilyType.Super) {
                    SSTableImport.addToSuperCF((JSONObject)json.get(entry.getValue()), cfamily);
                } else {
                    SSTableImport.addToStandardCF((JSONArray)json.get(entry.getValue()), cfamily);
                }
                writer.append((DecoratedKey)entry.getKey(), cfamily);
                cfamily.clear();
            }
            writer.closeAndOpenReader();
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Invalid JSON input, or incorrect column family.", cce);
        }
    }

    public static void main(String[] args) throws IOException, org.json.simple.parser.ParseException, ConfigurationException {
        String usage = String.format("Usage: %s -K keyspace -c column_family <json> <sstable>%n", SSTableImport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 2) {
            System.err.println(usage);
            System.exit(1);
        }
        String json = cmd.getArgs()[0];
        String ssTable = cmd.getArgs()[1];
        String keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
        String cfamily = cmd.getOptionValue(COLFAM_OPTION);
        DatabaseDescriptor.loadSchemas();
        if (DatabaseDescriptor.getNonSystemTables().size() < 1) {
            String msg = "no non-system tables are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        SSTableImport.importJson(json, keyspace, cfamily, ssTable);
        System.exit(0);
    }

    static {
        Option optKeyspace = new Option(KEYSPACE_OPTION, true, "Keyspace name");
        optKeyspace.setRequired(true);
        options.addOption(optKeyspace);
        Option optColfamily = new Option(COLFAM_OPTION, true, "Column family");
        optColfamily.setRequired(true);
        options.addOption(optColfamily);
    }

    private static class JsonColumn {
        private String name;
        private String value;
        private long timestamp;
        private boolean isDeleted;
        private int ttl;
        private int localExpirationTime;

        private JsonColumn(Object obj) throws ClassCastException {
            JSONArray colSpec = (JSONArray)obj;
            assert (colSpec.size() == 4 || colSpec.size() == 6);
            this.name = (String)colSpec.get(0);
            this.value = (String)colSpec.get(1);
            this.timestamp = (Long)colSpec.get(2);
            this.isDeleted = (Boolean)colSpec.get(3);
            if (colSpec.size() == 6) {
                this.ttl = (int)((Long)colSpec.get(4)).longValue();
                this.localExpirationTime = (int)((Long)colSpec.get(5)).longValue();
            }
        }
    }
}

