/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.MurmurHash;

public abstract class Filter {
    int hashCount;
    private static MurmurHash hasher = new MurmurHash();

    int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(ByteBuffer key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    abstract int buckets();

    public abstract void add(ByteBuffer var1);

    public abstract boolean isPresent(ByteBuffer var1);

    abstract int emptyBuckets();

    ICompactSerializer<Filter> getSerializer() {
        Method method = null;
        try {
            method = this.getClass().getMethod("serializer", new Class[0]);
            return (ICompactSerializer)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int[] getHashBuckets(ByteBuffer b, int hashCount, int max) {
        int[] result = new int[hashCount];
        int hash1 = hasher.hash(b.array(), b.position() + b.arrayOffset(), b.remaining(), 0);
        int hash2 = hasher.hash(b.array(), b.position() + b.arrayOffset(), b.remaining(), hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }
}

