/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import javax.transaction.xa.Xid;
import org.apache.derby.client.net.NetXAResource;

public class ClientXid
implements Xid {
    private int formatID_;
    private int gtrid_length_;
    private int bqual_length_;
    private byte[] data_;
    private static final int XidDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab_ = "0123456789ABCDEF";

    public ClientXid() {
        this.data_ = new byte[128];
        this.gtrid_length_ = 0;
        this.bqual_length_ = 0;
        this.formatID_ = -1;
    }

    public ClientXid(int formatID, byte[] gtrid, byte[] bqual) {
        this.formatID_ = formatID;
        this.gtrid_length_ = gtrid.length;
        this.bqual_length_ = bqual.length;
        this.data_ = new byte[128];
        System.arraycopy(gtrid, 0, this.data_, 0, this.gtrid_length_);
        System.arraycopy(bqual, 0, this.data_, this.gtrid_length_, this.bqual_length_);
    }

    public String toString() {
        int L = this.gtrid_length_ + this.bqual_length_;
        StringBuffer d = new StringBuffer(L + L);
        for (int i = 0; i < L; ++i) {
            int v = this.data_[i] & 0xFF;
            d.append(hextab_.charAt(v / 16));
            d.append(hextab_.charAt(v & 0xF));
            if ((i + 1) % 4 != 0 || i + 1 >= L) continue;
            d.append(" ");
        }
        String s = "{ClientXid: formatID(" + this.formatID_ + "), " + "gtrid_length(" + this.gtrid_length_ + "), " + "bqual_length(" + this.bqual_length_ + "), " + "data(" + d.toString() + ")" + "}";
        return s;
    }

    public byte[] getBranchQualifier() {
        byte[] bqual = new byte[this.bqual_length_];
        System.arraycopy(this.data_, this.gtrid_length_, bqual, 0, this.bqual_length_);
        return bqual;
    }

    public void setBranchQualifier(byte[] qual) {
        this.bqual_length_ = qual.length > 64 ? 64 : qual.length;
        System.arraycopy(qual, 0, this.data_, this.gtrid_length_, this.bqual_length_);
    }

    public int getFormatId() {
        return this.formatID_;
    }

    public void setFormatID(int formatID) {
        this.formatID_ = formatID;
    }

    public byte[] getGlobalTransactionId() {
        byte[] gtrid = new byte[this.gtrid_length_];
        System.arraycopy(this.data_, 0, gtrid, 0, this.gtrid_length_);
        return gtrid;
    }

    public byte[] getData() {
        return this.data_;
    }

    public int getGtridLength() {
        return this.gtrid_length_;
    }

    public int getBqualLength() {
        return this.bqual_length_;
    }

    public int hashCode() {
        if (this.formatID_ == -1) {
            return -1;
        }
        return this.formatID_ + this.gtrid_length_ - this.bqual_length_;
    }

    public boolean equals(Object obj) {
        return NetXAResource.xidsEqual(this, (Xid)obj);
    }
}

