/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.JarStorageFactory;
import org.apache.derby.io.StorageFile;

class JarDBFile
extends InputStreamFile {
    private final JarStorageFactory storageFactory;

    JarDBFile(JarStorageFactory storageFactory, String path) {
        super(storageFactory, path);
        this.storageFactory = storageFactory;
    }

    JarDBFile(JarStorageFactory storageFactory, String parent, String name) {
        super((BaseStorageFactory)storageFactory, parent, name);
        this.storageFactory = storageFactory;
    }

    JarDBFile(JarDBFile dir, String name) {
        super(dir, name);
        this.storageFactory = dir.storageFactory;
    }

    private JarDBFile(JarStorageFactory storageFactory, String child, int pathLen) {
        super((BaseStorageFactory)storageFactory, child, pathLen);
        this.storageFactory = storageFactory;
    }

    public boolean exists() {
        return this.getEntry() != null;
    }

    private ZipEntry getEntry() {
        return this.storageFactory.zipData.getEntry(this.path);
    }

    public long length() {
        ZipEntry entry = this.getEntry();
        if (entry == null) {
            return 0L;
        }
        return entry.getSize();
    }

    StorageFile getParentDir(int pathLen) {
        return new JarDBFile(this.storageFactory, this.path, pathLen);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return this.storageFactory.zipData.getInputStream(zipEntry);
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
    }

    public String toString() {
        return this.path;
    }

    public URL getURL() throws MalformedURLException {
        File pathFile = new File(this.storageFactory.zipData.getName());
        String pathFileURL = pathFile.toURL().toString();
        return new URL("jar:" + pathFileURL + "!/" + this.path);
    }
}

