/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class BetweenOperatorNode
extends BinaryListOperatorNode {
    public void init(Object leftOperand, Object betweenValues) {
        ValueNodeList betweenVals = (ValueNodeList)betweenValues;
        SanityManager.ASSERT(betweenVals.size() == 2, "betweenValues.size() (" + betweenVals.size() + ") is expected to be 2");
        super.init(leftOperand, betweenValues, "BETWEEN", null);
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        SanityManager.ASSERT(this.rightOperandList.size() == 2, "rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2");
        if (!underNotNode) {
            return this;
        }
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(45, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        leftBCO.bindComparisonOperator();
        BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(43, this.leftOperand, this.rightOperandList.elementAt(1), cm);
        rightBCO.bindComparisonOperator();
        OrNode newOr = (OrNode)nodeFactory.getNode(52, leftBCO, rightBCO, cm);
        newOr.postBindFixup();
        leftBCO.setBetweenSelectivity();
        rightBCO.setBetweenSelectivity();
        return newOr;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (!(this.leftOperand instanceof ColumnReference)) {
            return this;
        }
        ValueNode leftClone1 = this.leftOperand.getClone();
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        QueryTreeNode trueNode = nodeFactory.getNode(38, Boolean.TRUE, cm);
        BinaryComparisonOperatorNode lessEqual = (BinaryComparisonOperatorNode)nodeFactory.getNode(44, leftClone1, this.rightOperandList.elementAt(1), cm);
        lessEqual.bindComparisonOperator();
        AndNode newAnd = (AndNode)nodeFactory.getNode(39, lessEqual, trueNode, cm);
        newAnd.postBindFixup();
        BinaryComparisonOperatorNode greaterEqual = (BinaryComparisonOperatorNode)nodeFactory.getNode(42, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        greaterEqual.bindComparisonOperator();
        newAnd = (AndNode)nodeFactory.getNode(39, greaterEqual, newAnd, cm);
        newAnd.postBindFixup();
        lessEqual.setBetweenSelectivity();
        greaterEqual.setBetweenSelectivity();
        return newAnd;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.rightOperandList.size() == 2, "rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2");
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(42, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        leftBCO.bindComparisonOperator();
        BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(44, this.leftOperand, this.rightOperandList.elementAt(1), cm);
        rightBCO.bindComparisonOperator();
        AndNode newAnd = (AndNode)nodeFactory.getNode(39, leftBCO, rightBCO, cm);
        newAnd.postBindFixup();
        newAnd.generateExpression(acb, mb);
    }
}

