/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

public class DistinctNode
extends SingleChildResultSetNode {
    boolean inSortedOrder;

    public void init(Object childResult, Object inSortedOrder, Object tableProperties) throws StandardException {
        super.init(childResult, tableProperties);
        if (!(childResult instanceof Optimizable)) {
            SanityManager.THROWASSERT("childResult, " + childResult.getClass().getName() + ", expected to be instanceof Optimizable");
        }
        if (!(childResult instanceof FromTable)) {
            SanityManager.THROWASSERT("childResult, " + childResult.getClass().getName() + ", expected to be instanceof FromTable");
        }
        ResultColumnList prRCList = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(prRCList);
        this.resultColumns.genVirtualColumnNodes(this, prRCList);
        this.resultColumns.verifyAllOrderable();
        this.inSortedOrder = (Boolean)inSortedOrder;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, predList, outerCost, rowOrdering);
        return super.optimizeIt(optimizer, predList, outerCost, rowOrdering);
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).estimateCost(predList, cd, outerCost, optimizer, rowOrdering);
        this.costEstimate = this.getCostEstimate(optimizer);
        this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        return this.costEstimate;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    public String toString() {
        return this.childResult.toString() + "\n" + super.toString();
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = (ProjectRestrictNode)this.childResult.optimize(dataDictionary, predicates, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) {
        return false;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int orderItem = acb.addItem(acb.getColumnOrdering(this.resultColumns));
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(true);
        mb.push(this.inSortedOrder);
        mb.push(orderItem);
        this.resultColumns.generateHolder(acb, mb);
        mb.push(this.resultColumns.getTotalColumnSize());
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }
}

