/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class JavaToSQLValueNode
extends ValueNode {
    JavaValueNode javaNode;

    public void init(Object value) {
        this.javaNode = (JavaValueNode)value;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.javaNode.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.javaNode.returnValueToSQLDomain();
        boolean hasReceiver = this.javaNode.generateReceiver(acb, mb);
        if (hasReceiver) {
            String nullValueClass = this.getTypeCompiler().interfaceName();
            LocalField nullValueField = acb.newFieldDeclaration(2, nullValueClass);
            mb.conditionalIfNull();
            mb.getField(nullValueField);
            acb.generateNullWithExpress(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
            mb.startElseCode();
        }
        TypeId resultType = this.getTypeId();
        TypeCompiler tc = this.getTypeCompiler();
        String resultTypeName = tc.interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        this.javaNode.generateExpression(acb, mb);
        acb.generateDataValue(mb, tc, this.getTypeServices().getCollationType(), field);
        if (hasReceiver) {
            mb.completeConditional();
        }
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "javaNode: ");
        this.javaNode.treePrint(depth + 1);
    }

    public JavaValueNode getJavaValueNode() {
        return this.javaNode;
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.javaNode != null) {
            this.javaNode.disablePrivilegeCollection();
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.javaNode.checkReliability(this);
        this.javaNode = this.javaNode.bindExpression(fromList, subqueryList, aggregateVector);
        DataTypeDescriptor dts = DataTypeDescriptor.getSQLDataTypeDescriptor(this.javaNode.getJavaTypeName());
        if (dts == null) {
            throw StandardException.newException("X0X57.S", this.javaNode.getJavaTypeName());
        }
        this.setType(dts);
        if (dts.getTypeId().isStringTypeId()) {
            this.setCollationInfo(this.javaNode.getCollationType(), 1);
        }
        return this;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.javaNode = this.javaNode.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.javaNode.categorize(referencedTabs, simplePredsOnly);
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.javaNode.getOrderableVariantType();
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.javaNode != null && !v.stopTraversal()) {
            this.javaNode = (JavaValueNode)this.javaNode.accept(v);
        }
        return returnNode;
    }

    protected boolean isEquivalent(ValueNode o) {
        return false;
    }
}

