/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class StaticMethodCallNode
extends MethodCallNode {
    private TableName procedureName;
    private LocalField[] outParamArrays;
    private int[] applicationParameterNumbers;
    private boolean isSystemCode;
    private boolean alreadyBound;
    private LocalField returnsNullOnNullState;
    AliasDescriptor ad;

    public void init(Object methodName, Object javaClassName) {
        if (methodName instanceof String) {
            this.init(methodName);
        } else {
            this.procedureName = (TableName)methodName;
            this.init(this.procedureName.getTableName());
        }
        this.javaClassName = (String)javaClassName;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.alreadyBound) {
            return this;
        }
        this.bindParameters(fromList, subqueryList, aggregateVector);
        if (this.javaClassName == null) {
            CompilerContext cc = this.getCompilerContext();
            String schemaName = this.procedureName.getSchemaName();
            boolean noSchema = schemaName == null;
            SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, schemaName != null);
            this.resolveRoutine(fromList, subqueryList, aggregateVector, sd);
            if (this.ad == null && noSchema && !this.forCallStatement) {
                sd = this.getSchemaDescriptor("SYSFUN", true);
                this.resolveRoutine(fromList, subqueryList, aggregateVector, sd);
            }
            if (this.ad == null) {
                throw StandardException.newException("42Y03", this.procedureName);
            }
            if (!this.routineInfo.isDeterministic()) {
                this.checkReliability(this.getMethodName(), 4096);
            }
            if (this.permitsSQL(this.routineInfo)) {
                this.checkReliability(this.getMethodName(), 8192);
            }
            cc.createDependency(this.ad);
            this.methodName = this.ad.getAliasInfo().getMethodName();
            this.javaClassName = this.ad.getJavaClassName();
            if (this.javaClassName.startsWith("org.apache.derby.") && !sd.isSystemSchema()) {
                throw StandardException.newException("42X51", null, (Object)this.javaClassName);
            }
        }
        this.verifyClassExist(this.javaClassName);
        this.resolveMethodCall(this.javaClassName, true);
        this.alreadyBound = true;
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredRoutinePriv(this.ad);
        }
        if (this.routineInfo != null) {
            TypeId returnTypeId;
            TypeDescriptor returnType;
            if (this.methodParms != null) {
                this.optimizeDomainValueConversion();
            }
            if ((returnType = this.routineInfo.getReturnType()) != null && !returnType.isRowMultiSet() && (returnTypeId = TypeId.getBuiltInTypeId(returnType.getJDBCTypeId())).variableLength()) {
                DataTypeDescriptor returnValueDtd = new DataTypeDescriptor(returnTypeId, returnType.getPrecision(), returnType.getScale(), returnType.isNullable(), returnType.getMaximumWidth());
                ValueNode returnValueToSQL = (ValueNode)this.getNodeFactory().getNode(36, this, this.getContextManager());
                ValueNode returnValueCastNode = (ValueNode)this.getNodeFactory().getNode(60, returnValueToSQL, returnValueDtd, this.getContextManager());
                returnValueCastNode.setCollationInfo(returnType.getCollationType(), 1);
                JavaValueNode returnValueToJava = (JavaValueNode)this.getNodeFactory().getNode(28, returnValueCastNode, this.getContextManager());
                returnValueToJava.setCollationType(returnType.getCollationType());
                return returnValueToJava.bindExpression(fromList, subqueryList, aggregateVector);
            }
        }
        return this;
    }

    private boolean permitsSQL(RoutineAliasInfo rai) {
        short sqlAllowed = rai.getSQLAllowed();
        switch (sqlAllowed) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void optimizeDomainValueConversion() throws StandardException {
        int count = this.methodParms.length;
        for (int parm = 0; parm < count; ++parm) {
            JavaValueNode paramIsJavaValueNode;
            if (!(this.methodParms[parm] instanceof SQLToJavaValueNode) || !(((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode() instanceof JavaToSQLValueNode) || !((paramIsJavaValueNode = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode()).getJavaValueNode()) instanceof StaticMethodCallNode)) continue;
            StaticMethodCallNode paramIsMethodCallNode = (StaticMethodCallNode)paramIsJavaValueNode;
            if (paramIsMethodCallNode.routineInfo == null || !paramIsMethodCallNode.routineInfo.calledOnNullInput()) continue;
            this.methodParms[parm] = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[parm]).getSQLValueNode()).getJavaValueNode();
        }
    }

    private void resolveRoutine(FromList fromList, SubqueryList subqueryList, Vector aggregateVector, SchemaDescriptor sd) throws StandardException {
        if (sd.getUUID() != null) {
            List list = this.getDataDictionary().getRoutineList(sd.getUUID().toString(), this.methodName, this.forCallStatement ? (char)'P' : 'F');
            for (int i = list.size() - 1; i >= 0; --i) {
                AliasDescriptor proc = (AliasDescriptor)list.get(i);
                RoutineAliasInfo routineInfo = (RoutineAliasInfo)proc.getAliasInfo();
                int parameterCount = routineInfo.getParameterCount();
                if (parameterCount != this.methodParms.length) continue;
                TypeDescriptor[] parameterTypes = routineInfo.getParameterTypes();
                int sigParameterCount = parameterCount;
                if (routineInfo.getMaxDynamicResultSets() > 0) {
                    ++sigParameterCount;
                }
                this.signature = new JSQLType[sigParameterCount];
                for (int p = 0; p < parameterCount; ++p) {
                    TypeId typeId;
                    TypeDescriptor td = parameterTypes[p];
                    TypeId parameterTypeId = typeId = TypeId.getBuiltInTypeId(td.getJDBCTypeId());
                    int parameterMode = routineInfo.getParameterModes()[p];
                    if (parameterMode != 1) {
                        String arrayType;
                        switch (typeId.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: {
                                arrayType = this.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName().concat("[]");
                                break;
                            }
                            default: {
                                arrayType = typeId.getCorrespondingJavaTypeName().concat("[]");
                            }
                        }
                        typeId = TypeId.getUserDefinedTypeId(arrayType, false);
                    }
                    DataTypeDescriptor methoddtd = new DataTypeDescriptor(typeId, td.getPrecision(), td.getScale(), td.isNullable(), td.getMaximumWidth());
                    this.signature[p] = new JSQLType(methoddtd);
                    ValueNode sqlParamNode = null;
                    if (this.methodParms[p] instanceof SQLToJavaValueNode) {
                        SQLToJavaValueNode sql2j = (SQLToJavaValueNode)this.methodParms[p];
                        sqlParamNode = sql2j.getSQLValueNode();
                    }
                    boolean isParameterMarker = true;
                    if (sqlParamNode == null || !sqlParamNode.requiresTypeFromContext()) {
                        if (parameterMode != 1) {
                            throw StandardException.newException("42886", (Object)RoutineAliasInfo.parameterMode(parameterMode), (Object)routineInfo.getParameterNames()[p]);
                        }
                        isParameterMarker = false;
                    } else {
                        if (this.applicationParameterNumbers == null) {
                            this.applicationParameterNumbers = new int[parameterCount];
                        }
                        if (sqlParamNode instanceof UnaryOperatorNode) {
                            ParameterNode pn = ((UnaryOperatorNode)sqlParamNode).getParameterOperand();
                            this.applicationParameterNumbers[p] = pn.getParameterNumber();
                        } else {
                            this.applicationParameterNumbers[p] = ((ParameterNode)sqlParamNode).getParameterNumber();
                        }
                    }
                    DataTypeDescriptor paramdtd = new DataTypeDescriptor(parameterTypeId, td.getPrecision(), td.getScale(), td.isNullable(), td.getMaximumWidth());
                    boolean needCast = false;
                    if (!isParameterMarker) {
                        if (sqlParamNode instanceof UntypedNullConstantNode) {
                            sqlParamNode.setType(paramdtd);
                        } else {
                            DataTypeDescriptor dts;
                            TypeId argumentTypeId;
                            if (sqlParamNode != null) {
                                argumentTypeId = sqlParamNode.getTypeId();
                                dts = sqlParamNode.getTypeServices();
                            } else {
                                dts = DataTypeDescriptor.getSQLDataTypeDescriptor(this.methodParms[p].getJavaTypeName());
                                if (dts == null) {
                                    throw StandardException.newException("X0X57.S", this.methodParms[p].getJavaTypeName());
                                }
                                argumentTypeId = dts.getTypeId();
                            }
                            if (!this.getTypeCompiler(parameterTypeId).storable(argumentTypeId, this.getClassFactory())) {
                                throw StandardException.newException("42821", (Object)parameterTypeId.getSQLTypeName(), (Object)argumentTypeId.getSQLTypeName());
                            }
                            if (!paramdtd.isExactTypeAndLengthMatch(dts)) {
                                needCast = true;
                            }
                        }
                    } else if (parameterTypeId.variableLength() && parameterMode != 4) {
                        needCast = true;
                    }
                    if (needCast) {
                        if (sqlParamNode == null) {
                            sqlParamNode = (ValueNode)this.getNodeFactory().getNode(36, this.methodParms[p], this.getContextManager());
                        }
                        ValueNode castNode = (ValueNode)this.getNodeFactory().getNode(60, sqlParamNode, paramdtd, this.getContextManager());
                        this.methodParms[p] = (JavaValueNode)this.getNodeFactory().getNode(28, castNode, this.getContextManager());
                        this.methodParms[p] = this.methodParms[p].bindExpression(fromList, subqueryList, aggregateVector);
                    }
                    if (!isParameterMarker) continue;
                    sqlParamNode.setType(paramdtd);
                }
                if (sigParameterCount != parameterCount) {
                    TypeId typeId = TypeId.getUserDefinedTypeId("java.sql.ResultSet[]", false);
                    DataTypeDescriptor dtd = new DataTypeDescriptor(typeId, 0, 0, false, -1);
                    this.signature[parameterCount] = new JSQLType(dtd);
                }
                this.routineInfo = routineInfo;
                this.ad = proc;
                if (!sd.isSystemSchema() || routineInfo.getReturnType() != null || routineInfo.getSQLAllowed() == 3) break;
                this.isSystemCode = true;
                break;
            }
        }
    }

    private void generateSetupNestedSessionContext(ActivationClassBuilder acb, MethodBuilder mb) {
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "setupNestedSessionContext", "void", 1);
    }

    public void generateOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int parameterNumber) throws StandardException {
        int parameterMode;
        SQLToJavaValueNode sql2j = null;
        if (this.methodParms[parameterNumber] instanceof SQLToJavaValueNode) {
            sql2j = (SQLToJavaValueNode)this.methodParms[parameterNumber];
        }
        if (this.routineInfo != null) {
            parameterMode = this.routineInfo.getParameterModes()[parameterNumber];
        } else {
            parameterMode = 1;
            if (sql2j != null && sql2j.getSQLValueNode().requiresTypeFromContext()) {
                ParameterNode pn = sql2j.getSQLValueNode() instanceof UnaryOperatorNode ? ((UnaryOperatorNode)sql2j.getSQLValueNode()).getParameterOperand() : (ParameterNode)sql2j.getSQLValueNode();
                int applicationParameterNumber = pn.getParameterNumber();
                String parameterType = this.methodParameterTypes[parameterNumber];
                if (parameterType.endsWith("[]")) {
                    MethodBuilder constructor = acb.getConstructor();
                    acb.pushThisAsActivation(constructor);
                    constructor.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                    constructor.push(applicationParameterNumber);
                    constructor.push(0);
                    constructor.callMethod((short)185, null, "setParameterMode", "void", 2);
                    constructor.endStatement();
                }
            }
        }
        switch (parameterMode) {
            case 0: 
            case 1: 
            case 2: {
                if (sql2j != null) {
                    sql2j.returnsNullOnNullState = this.returnsNullOnNullState;
                }
                super.generateOneParameter(acb, mb, parameterNumber);
                break;
            }
        }
        switch (parameterMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                String methodParameterType = this.methodParameterTypes[parameterNumber];
                String arrayType = methodParameterType.substring(0, methodParameterType.length() - 2);
                LocalField lf = acb.newFieldDeclaration(2, methodParameterType);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[parameterNumber] = lf;
                mb.pushNewArray(arrayType, 1);
                mb.putField(lf);
                if (parameterMode == 4) break;
                mb.swap();
                mb.setArrayElement(0);
                mb.getField(lf);
                break;
            }
        }
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        pushable = pushable && super.categorize(referencedTabs, simplePredsOnly);
        return pushable;
    }

    public String toString() {
        return "javaClassName: " + (this.javaClassName != null ? this.javaClassName : "null") + "\n" + super.toString();
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int i;
        int compiledResultSets;
        if (this.routineInfo != null && !this.routineInfo.calledOnNullInput() && this.routineInfo.getParameterCount() != 0) {
            this.returnsNullOnNullState = acb.newFieldDeclaration(2, "boolean");
        }
        if (this.returnsNullOnNullState != null) {
            mb.push(false);
            mb.setField(this.returnsNullOnNullState);
            mb.pushThis();
        }
        int nargs = this.generateParameters(acb, mb);
        LocalField functionEntrySQLAllowed = null;
        if (this.routineInfo != null) {
            boolean isFunction;
            short sqlAllowed = this.routineInfo.getSQLAllowed();
            if (sqlAllowed != 3) {
                int sqlOperation = sqlAllowed == 1 ? 1 : (sqlAllowed == 0 ? 0 : 2);
                this.generateAuthorizeCheck((ActivationClassBuilder)acb, mb, sqlOperation);
            }
            int statmentContextReferences = this.isSystemCode ? 2 : 1;
            boolean bl = isFunction = this.routineInfo.getReturnType() != null;
            if (isFunction) {
                ++statmentContextReferences;
            }
            if (statmentContextReferences != 0) {
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                mb.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                for (int scc = 1; scc < statmentContextReferences; ++scc) {
                    mb.dup();
                }
            }
            if (this.isSystemCode) {
                mb.callMethod((short)185, null, "setSystemCode", "void", 0);
            }
            if (sqlAllowed != 3) {
                this.generateSetupNestedSessionContext((ActivationClassBuilder)acb, mb);
            }
            if (isFunction) {
                functionEntrySQLAllowed = acb.newFieldDeclaration(2, "short");
                mb.callMethod((short)185, null, "getSQLAllowed", "short", 0);
                mb.setField(functionEntrySQLAllowed);
            }
            mb.push(sqlAllowed);
            mb.push(false);
            mb.callMethod((short)185, null, "setSQLAllowed", "void", 2);
        }
        if (this.routineInfo != null && (compiledResultSets = this.methodParameterTypes.length - this.methodParms.length) != 0) {
            int maxDynamicResults = this.routineInfo.getMaxDynamicResultSets();
            if (maxDynamicResults > 0) {
                MethodBuilder gdr = acb.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
                gdr.push(maxDynamicResults);
                gdr.methodReturn();
                gdr.complete();
            }
            MethodBuilder gdr = acb.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
            MethodBuilder cons = acb.getConstructor();
            LocalField procedureResultSetsHolder = acb.newFieldDeclaration(2, "java.sql.ResultSet[][]");
            gdr.getField(procedureResultSetsHolder);
            cons.pushNewArray("java.sql.ResultSet[]", compiledResultSets);
            cons.setField(procedureResultSetsHolder);
            for (i = 0; i < compiledResultSets; ++i) {
                mb.pushNewArray("java.sql.ResultSet", 1);
                mb.dup();
                mb.getField(procedureResultSetsHolder);
                mb.swap();
                mb.setArrayElement(i);
            }
            gdr.methodReturn();
            gdr.complete();
            nargs += compiledResultSets;
        }
        String javaReturnType = this.getJavaTypeName();
        MethodBuilder mbnc = null;
        MethodBuilder mbcm = mb;
        if (this.returnsNullOnNullState != null) {
            mbnc = acb.newGeneratedFun(javaReturnType, 2, this.methodParameterTypes);
            Class<?>[] throwsSet = ((Method)this.method).getExceptionTypes();
            for (int te = 0; te < throwsSet.length; ++te) {
                mbnc.addThrownException(throwsSet[te].getName());
            }
            mbnc.getField(this.returnsNullOnNullState);
            mbnc.conditionalIf();
            mbnc.pushNull(javaReturnType);
            mbnc.startElseCode();
            if (!this.actualMethodReturnType.equals(javaReturnType)) {
                mbnc.pushNewStart(javaReturnType);
            }
            for (int pa = 0; pa < nargs; ++pa) {
                mbnc.getParameter(pa);
            }
            mbcm = mbnc;
        }
        mbcm.callMethod((short)184, this.method.getDeclaringClass().getName(), this.methodName, this.actualMethodReturnType, nargs);
        if (this.returnsNullOnNullState != null) {
            if (!this.actualMethodReturnType.equals(javaReturnType)) {
                if (this.actualMethodReturnType.equals("short") && javaReturnType.equals("java.lang.Integer")) {
                    mbnc.upCast("int");
                }
                mbnc.pushNewComplete(1);
            }
            mbnc.completeConditional();
            mbnc.methodReturn();
            mbnc.complete();
            mb.callMethod((short)182, acb.getClassBuilder().getFullName(), mbnc.getName(), javaReturnType, nargs);
            mbnc = null;
        }
        if (this.routineInfo != null) {
            if (functionEntrySQLAllowed != null) {
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                mb.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                mb.getField(functionEntrySQLAllowed);
                mb.push(true);
                mb.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
            if (this.outParamArrays != null) {
                MethodBuilder constructor = acb.getConstructor();
                acb.pushThisAsActivation(constructor);
                constructor.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                acb.pushThisAsActivation(mb);
                mb.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                int[] parameterModes = this.routineInfo.getParameterModes();
                for (i = 0; i < this.outParamArrays.length; ++i) {
                    int parameterMode = parameterModes[i];
                    if (parameterMode == 1) continue;
                    ValueNode sqlParamNode = ((SQLToJavaValueNode)this.methodParms[i]).getSQLValueNode();
                    int applicationParameterNumber = this.applicationParameterNumbers[i];
                    constructor.dup();
                    constructor.push(applicationParameterNumber);
                    constructor.push(parameterMode);
                    constructor.callMethod((short)185, null, "setParameterMode", "void", 2);
                    LocalField lf = this.outParamArrays[i];
                    mb.dup();
                    mb.push(applicationParameterNumber);
                    mb.callMethod((short)185, null, "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                    DataTypeDescriptor paramdtd = sqlParamNode.getTypeServices();
                    boolean isNumericType = paramdtd.getTypeId().isNumericTypeId();
                    boolean isPrimitive = ((Method)this.method).getParameterTypes()[i].getComponentType().isPrimitive();
                    if (isNumericType) {
                        if (!isPrimitive) {
                            mb.cast("org.apache.derby.iapi.types.NumberDataValue");
                        }
                    } else if (paramdtd.getTypeId().isBooleanTypeId() && !isPrimitive) {
                        mb.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    }
                    if (paramdtd.getTypeId().variableLength()) {
                        mb.dup();
                    }
                    mb.getField(lf);
                    mb.getArrayElement(0);
                    if (isNumericType && !isPrimitive) {
                        mb.upCast("java.lang.Number");
                    }
                    mb.callMethod((short)185, null, "setValue", "void", 1);
                    if (!paramdtd.getTypeId().variableLength()) continue;
                    mb.push(isNumericType ? paramdtd.getPrecision() : paramdtd.getMaximumWidth());
                    mb.push(paramdtd.getScale());
                    mb.push(isNumericType);
                    mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
                }
                constructor.endStatement();
                mb.endStatement();
            }
        }
    }

    int getPrivType() {
        return 6;
    }
}

