/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.AnyResultSet;
import org.apache.derby.impl.sql.execute.BulkTableScanResultSet;
import org.apache.derby.impl.sql.execute.CallStatementResultSet;
import org.apache.derby.impl.sql.execute.CurrentOfResultSet;
import org.apache.derby.impl.sql.execute.DeleteCascadeResultSet;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.DeleteVTIResultSet;
import org.apache.derby.impl.sql.execute.DependentResultSet;
import org.apache.derby.impl.sql.execute.DistinctGroupedAggregateResultSet;
import org.apache.derby.impl.sql.execute.DistinctScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.DistinctScanResultSet;
import org.apache.derby.impl.sql.execute.GroupedAggregateResultSet;
import org.apache.derby.impl.sql.execute.HashJoinResultSet;
import org.apache.derby.impl.sql.execute.HashLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.HashScanResultSet;
import org.apache.derby.impl.sql.execute.HashTableResultSet;
import org.apache.derby.impl.sql.execute.IndexRowToBaseRowResultSet;
import org.apache.derby.impl.sql.execute.InsertResultSet;
import org.apache.derby.impl.sql.execute.InsertVTIResultSet;
import org.apache.derby.impl.sql.execute.LastIndexKeyResultSet;
import org.apache.derby.impl.sql.execute.MaterializedResultSet;
import org.apache.derby.impl.sql.execute.MiscResultSet;
import org.apache.derby.impl.sql.execute.MultiProbeTableScanResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.OnceResultSet;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;
import org.apache.derby.impl.sql.execute.RowCountResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.ScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;
import org.apache.derby.impl.sql.execute.SetOpResultSet;
import org.apache.derby.impl.sql.execute.SetTransactionResultSet;
import org.apache.derby.impl.sql.execute.SortResultSet;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;
import org.apache.derby.impl.sql.execute.UpdateResultSet;
import org.apache.derby.impl.sql.execute.UpdateVTIResultSet;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.impl.sql.execute.WindowResultSet;

public class GenericResultSetFactory
implements ResultSetFactory {
    public ResultSet getInsertResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new InsertResultSet(source, generationClauses, checkGM, activation);
    }

    public ResultSet getInsertVTIResultSet(NoPutResultSet source, NoPutResultSet vtiRS) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new InsertVTIResultSet(source, vtiRS, activation);
    }

    public ResultSet getDeleteVTIResultSet(NoPutResultSet source) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new DeleteVTIResultSet(source, activation);
    }

    public ResultSet getDeleteResultSet(NoPutResultSet source) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new DeleteResultSet(source, activation);
    }

    public ResultSet getDeleteCascadeResultSet(NoPutResultSet source, int constantActionItem, ResultSet[] dependentResultSets, String resultSetId) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new DeleteCascadeResultSet(source, activation, constantActionItem, dependentResultSets, resultSetId);
    }

    public ResultSet getUpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM) throws StandardException {
        Activation activation = source.getActivation();
        SanityManager.ASSERT(GenericResultSetFactory.getAuthorizer(activation) != null, "Authorizer is null");
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new UpdateResultSet(source, generationClauses, checkGM, activation);
    }

    public ResultSet getUpdateVTIResultSet(NoPutResultSet source) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new UpdateVTIResultSet(source, activation);
    }

    public ResultSet getDeleteCascadeUpdateResultSet(NoPutResultSet source, GeneratedMethod generationClauses, GeneratedMethod checkGM, int constantActionItem, int rsdItem) throws StandardException {
        Activation activation = source.getActivation();
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 0);
        return new UpdateResultSet(source, generationClauses, checkGM, activation, constantActionItem, rsdItem);
    }

    public ResultSet getCallStatementResultSet(GeneratedMethod methodCall, Activation activation) throws StandardException {
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 3);
        return new CallStatementResultSet(methodCall, activation);
    }

    public NoPutResultSet getProjectRestrictResultSet(NoPutResultSet source, GeneratedMethod restriction, GeneratedMethod projection, int resultSetNumber, GeneratedMethod constantRestriction, int mapRefItem, boolean reuseResult, boolean doesProjection, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new ProjectRestrictResultSet(source, source.getActivation(), restriction, projection, resultSetNumber, constantRestriction, mapRefItem, reuseResult, doesProjection, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getHashTableResultSet(NoPutResultSet source, GeneratedMethod singleTableRestriction, Qualifier[][] equijoinQualifiers, GeneratedMethod projection, int resultSetNumber, int mapRefItem, boolean reuseResult, int keyColItem, boolean removeDuplicates, long maxInMemoryRowCount, int initialCapacity, float loadFactor, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new HashTableResultSet(source, source.getActivation(), singleTableRestriction, equijoinQualifiers, projection, resultSetNumber, mapRefItem, reuseResult, keyColItem, removeDuplicates, maxInMemoryRowCount, initialCapacity, loadFactor, true, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getSortResultSet(NoPutResultSet source, boolean distinct, boolean isInSortedOrder, int orderItem, GeneratedMethod rowAllocator, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new SortResultSet(source, distinct, isInSortedOrder, orderItem, source.getActivation(), rowAllocator, maxRowSize, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getScalarAggregateResultSet(NoPutResultSet source, boolean isInSortedOrder, int aggregateItem, int orderItem, GeneratedMethod rowAllocator, int maxRowSize, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new ScalarAggregateResultSet(source, isInSortedOrder, aggregateItem, source.getActivation(), rowAllocator, resultSetNumber, singleInputRow, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getDistinctScalarAggregateResultSet(NoPutResultSet source, boolean isInSortedOrder, int aggregateItem, int orderItem, GeneratedMethod rowAllocator, int maxRowSize, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new DistinctScalarAggregateResultSet(source, isInSortedOrder, aggregateItem, orderItem, source.getActivation(), rowAllocator, maxRowSize, resultSetNumber, singleInputRow, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getGroupedAggregateResultSet(NoPutResultSet source, boolean isInSortedOrder, int aggregateItem, int orderItem, GeneratedMethod rowAllocator, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new GroupedAggregateResultSet(source, isInSortedOrder, aggregateItem, orderItem, source.getActivation(), rowAllocator, maxRowSize, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getDistinctGroupedAggregateResultSet(NoPutResultSet source, boolean isInSortedOrder, int aggregateItem, int orderItem, GeneratedMethod rowAllocator, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new DistinctGroupedAggregateResultSet(source, isInSortedOrder, aggregateItem, orderItem, source.getActivation(), rowAllocator, maxRowSize, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getAnyResultSet(NoPutResultSet source, GeneratedMethod emptyRowFun, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new AnyResultSet(source, source.getActivation(), emptyRowFun, resultSetNumber, subqueryNumber, pointOfAttachment, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getOnceResultSet(NoPutResultSet source, GeneratedMethod emptyRowFun, int cardinalityCheck, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new OnceResultSet(source, source.getActivation(), emptyRowFun, cardinalityCheck, resultSetNumber, subqueryNumber, pointOfAttachment, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getRowResultSet(Activation activation, GeneratedMethod row, boolean canCacheRow, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        return new RowResultSet(activation, row, canCacheRow, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getVTIResultSet(Activation activation, GeneratedMethod row, int resultSetNumber, GeneratedMethod constructor, String javaClassName, Qualifier[][] pushedQualifiers, int erdNumber, boolean version2, boolean reuseablePs, int ctcNumber, boolean isTarget, int scanIsolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean isDerbyStyleTableFunction, int returnTypeNumber) throws StandardException {
        return new VTIResultSet(activation, row, resultSetNumber, constructor, javaClassName, pushedQualifiers, erdNumber, version2, reuseablePs, ctcNumber, isTarget, scanIsolationLevel, optimizerEstimatedRowCount, optimizerEstimatedCost, isDerbyStyleTableFunction, returnTypeNumber);
    }

    public NoPutResultSet getHashScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] scanQualifiers, Qualifier[][] nextQualifiers, int initialCapacity, float loadFactor, int maxCapacity, int hashKeyColumn, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new HashScanResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, scanQualifiers, nextQualifiers, initialCapacity, loadFactor, maxCapacity, hashKeyColumn, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, lockMode, tableLocked, isolationLevel, true, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getDistinctScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, int hashKeyColumn, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new DistinctScanResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, hashKeyColumn, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, colRefItem, lockMode, tableLocked, isolationLevel, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getTableScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new TableScanResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, 1, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getBulkTableScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new BulkTableScanResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, rowsPerRead, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getMultiProbeTableScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, DataValueDescriptor[] probeVals, int sortRequired, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new MultiProbeTableScanResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, probeVals, sortRequired, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getIndexRowToBaseRowResultSet(long conglomId, int scociItem, NoPutResultSet source, GeneratedMethod resultRowAllocator, int resultSetNumber, String indexName, int heapColRefItem, int allColRefItem, int heapOnlyColRefItem, int indexColMapItem, GeneratedMethod restriction, boolean forUpdate, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new IndexRowToBaseRowResultSet(conglomId, scociItem, source.getActivation(), source, resultRowAllocator, resultSetNumber, indexName, heapColRefItem, allColRefItem, heapOnlyColRefItem, indexColMapItem, restriction, forUpdate, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getWindowResultSet(Activation activation, NoPutResultSet source, GeneratedMethod rowAllocator, int resultSetNumber, int level, int erdNumber, GeneratedMethod restriction, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new WindowResultSet(activation, source, rowAllocator, resultSetNumber, level, erdNumber, restriction, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getNestedLoopJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, GeneratedMethod joinClause, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) throws StandardException {
        return new NestedLoopJoinResultSet(leftResultSet, leftNumCols, rightResultSet, rightNumCols, leftResultSet.getActivation(), joinClause, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
    }

    public NoPutResultSet getHashJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, GeneratedMethod joinClause, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) throws StandardException {
        return new HashJoinResultSet(leftResultSet, leftNumCols, rightResultSet, rightNumCols, leftResultSet.getActivation(), joinClause, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
    }

    public NoPutResultSet getNestedLoopLeftOuterJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, GeneratedMethod joinClause, int resultSetNumber, GeneratedMethod emptyRowFun, boolean wasRightOuterJoin, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) throws StandardException {
        return new NestedLoopLeftOuterJoinResultSet(leftResultSet, leftNumCols, rightResultSet, rightNumCols, leftResultSet.getActivation(), joinClause, resultSetNumber, emptyRowFun, wasRightOuterJoin, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
    }

    public NoPutResultSet getHashLeftOuterJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, GeneratedMethod joinClause, int resultSetNumber, GeneratedMethod emptyRowFun, boolean wasRightOuterJoin, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) throws StandardException {
        return new HashLeftOuterJoinResultSet(leftResultSet, leftNumCols, rightResultSet, rightNumCols, leftResultSet.getActivation(), joinClause, resultSetNumber, emptyRowFun, wasRightOuterJoin, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
    }

    public ResultSet getSetTransactionResultSet(Activation activation) throws StandardException {
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 2);
        return new SetTransactionResultSet(activation);
    }

    public NoPutResultSet getMaterializedResultSet(NoPutResultSet source, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new MaterializedResultSet(source, source.getActivation(), resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getScrollInsensitiveResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int sourceRowWidth, boolean scrollable, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        if (scrollable) {
            return new ScrollInsensitiveResultSet(source, activation, resultSetNumber, sourceRowWidth, optimizerEstimatedRowCount, optimizerEstimatedCost);
        }
        return source;
    }

    public NoPutResultSet getNormalizeResultSet(NoPutResultSet source, int resultSetNumber, int erdNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean forUpdate) throws StandardException {
        return new NormalizeResultSet(source, source.getActivation(), resultSetNumber, erdNumber, optimizerEstimatedRowCount, optimizerEstimatedCost, forUpdate);
    }

    public NoPutResultSet getCurrentOfResultSet(String cursorName, Activation activation, int resultSetNumber) {
        return new CurrentOfResultSet(cursorName, activation, resultSetNumber);
    }

    public ResultSet getDDLResultSet(Activation activation) throws StandardException {
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 4);
        return this.getMiscResultSet(activation);
    }

    public ResultSet getMiscResultSet(Activation activation) throws StandardException {
        GenericResultSetFactory.getAuthorizer(activation).authorize(activation, 2);
        return new MiscResultSet(activation);
    }

    public NoPutResultSet getUnionResultSet(NoPutResultSet leftResultSet, NoPutResultSet rightResultSet, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new UnionResultSet(leftResultSet, rightResultSet, leftResultSet.getActivation(), resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getSetOpResultSet(NoPutResultSet leftSource, NoPutResultSet rightSource, Activation activation, int resultSetNumber, long optimizerEstimatedRowCount, double optimizerEstimatedCost, int opType, boolean all, int intermediateOrderByColumnsSavedObject, int intermediateOrderByDirectionSavedObject, int intermediateOrderByNullsLowSavedObject) throws StandardException {
        return new SetOpResultSet(leftSource, rightSource, activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost, opType, all, intermediateOrderByColumnsSavedObject, intermediateOrderByDirectionSavedObject, intermediateOrderByNullsLowSavedObject);
    }

    public NoPutResultSet getLastIndexKeyResultSet(Activation activation, int resultSetNumber, GeneratedMethod resultRowAllocator, long conglomId, String tableName, String userSuppliedOptimizerOverrides, String indexName, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new LastIndexKeyResultSet(activation, resultSetNumber, resultRowAllocator, conglomId, tableName, userSuppliedOptimizerOverrides, indexName, colRefItem, lockMode, tableLocked, isolationLevel, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    public NoPutResultSet getRaDependentTableScanResultSet(Activation activation, long conglomId, int scociItem, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String parentResultSetId, long fkIndexConglomId, int fkColArrayItem, int rltItem) throws StandardException {
        StaticCompiledOpenConglomInfo scoci = (StaticCompiledOpenConglomInfo)activation.getPreparedStatement().getSavedObject(scociItem);
        return new DependentResultSet(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, lockMode, tableLocked, isolationLevel, 1, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, parentResultSetId, fkIndexConglomId, fkColArrayItem, rltItem);
    }

    public NoPutResultSet getRowCountResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, long offset, long fetchFirst, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        return new RowCountResultSet(source, activation, resultSetNumber, offset, fetchFirst, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    private static Authorizer getAuthorizer(Activation activation) {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        return lcc.getAuthorizer();
    }
}

